/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql;

import com.adobe.cq.dam.cfm.headless.backend.Paging;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.CompOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.ConditionBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.LogOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.QueryBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TimeAuthorInformation;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.jcr.query.Query;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.graphql.api.pagination.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingImpl
implements Paging {
    private static final String NULL = "null";
    static final String PN_SYNTHETIC_PAGING_CURSOR = "_syntheticPagingCursor";
    private static final Logger LOG = LoggerFactory.getLogger(PagingImpl.class);
    private final String[] cursorValues;
    private final List<Criterion> criteria = new ArrayList<Criterion>();
    private final long limit;

    public PagingImpl(@Nullable Cursor cursor, int limit) {
        this.limit = limit;
        String cursorValue = cursor != null ? cursor.getRawValue() : null;
        this.cursorValues = cursorValue != null ? cursorValue.split("\n") : null;
    }

    private void addToBuilder(ConditionBuilder builder, Criterion criterion, CompOp compOp, String cursorValue, LogOp logOp) {
        Object convertedValue = criterion.typeConversionFunc.apply(cursorValue);
        String secondaryName = criterion.getSecondaryName();
        if (secondaryName != null) {
            String alias = criterion.getAlias();
            String secondaryAlias = criterion.getSecondaryAlias();
            if (alias == null || secondaryAlias == null) {
                throw new IllegalStateException("Criterions with a secondary field need to have an alias defined for both fields involved.");
            }
            builder.fragment(logOp, () -> true, com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function.COALESCE, new Object[]{alias, criterion.getName(), secondaryAlias, secondaryName, compOp, convertedValue});
        } else {
            builder.fragment(logOp, criterion.getName(), criterion.getAlias(), compOp, convertedValue, () -> true);
        }
    }

    void buildSubCriterion(ConditionBuilder builder, int lastCriterionToInclude) {
        this.buildSubConditions(builder, lastCriterionToInclude);
        Criterion criterion = this.criteria.get(lastCriterionToInclude);
        String cursorValue = this.cursorValues[lastCriterionToInclude];
        boolean isFinal = lastCriterionToInclude == this.criteria.size() - 1;
        boolean isDescending = criterion.isDescending();
        if (cursorValue.equals(NULL) && !isDescending) {
            this.addToBuilder(builder, criterion, CompOp.IS_NOT, null, LogOp.AND);
        } else {
            CompOp compOp;
            CompOp compOp2 = isFinal ? (isDescending ? CompOp.LOWER_THAN_OR_EQUAL : CompOp.GREATER_THAN_OR_EQUAL) : (compOp = isDescending ? CompOp.LOWER_THAN : CompOp.GREATER_THAN);
            if (compOp.equals((Object)CompOp.LOWER_THAN)) {
                builder = builder.startSubCondition(LogOp.AND, () -> true);
                this.addToBuilder(builder, criterion, compOp, cursorValue, LogOp.AND);
                this.addToBuilder(builder, criterion, CompOp.IS, null, LogOp.OR);
                builder.endSubCondition(() -> true);
            } else {
                this.addToBuilder(builder, criterion, compOp, cursorValue, LogOp.AND);
            }
        }
    }

    void buildCriterion(ConditionBuilder builder, int lastCriterionToInclude) {
        this.buildSubConditions(builder, lastCriterionToInclude);
        Criterion criterion = this.criteria.get(lastCriterionToInclude);
        String cursorValue = this.cursorValues[lastCriterionToInclude];
        boolean isFinal = lastCriterionToInclude == this.criteria.size() - 1;
        boolean isDescending = criterion.isDescending();
        CompOp compOp = isFinal ? (isDescending ? CompOp.LOWER_THAN_OR_EQUAL : CompOp.GREATER_THAN_OR_EQUAL) : (isDescending ? CompOp.LOWER_THAN : CompOp.GREATER_THAN);
        this.addToBuilder(builder, criterion, compOp, cursorValue, LogOp.AND);
    }

    @Override
    public void addPagingToCondition(ConditionBuilder builder) {
        if (this.cursorValues != null && this.cursorValues.length > 0 && this.cursorValues.length == this.criteria.size()) {
            builder.startSubCondition(LogOp.AND, () -> true).execute(bldr -> {
                for (int c = 0; c < this.criteria.size(); ++c) {
                    if (this.criteria.get((int)c).secondaryName != null) {
                        this.buildCriterion((ConditionBuilder)bldr, c);
                        continue;
                    }
                    if (this.criteria.get((int)c).isDescending && this.cursorValues[c].equals(NULL)) continue;
                    bldr = bldr.startSubCondition(LogOp.OR, () -> true);
                    this.buildSubCriterion((ConditionBuilder)bldr, c);
                    bldr = bldr.endSubCondition(() -> true);
                }
            }).endSubCondition(() -> true);
        }
    }

    @Override
    public void addPagingToOrdering(QueryBuilder builder) {
        for (Criterion criterion : this.criteria) {
            String secondaryName = criterion.getSecondaryName();
            if (secondaryName != null) {
                String alias = criterion.getAlias();
                String secondaryAlias = criterion.getSecondaryAlias();
                if (alias == null || secondaryAlias == null) {
                    throw new IllegalStateException("Criterions with a secondary field need to have an alias defined for both fields involved.");
                }
                builder.orderBy(alias, criterion.getName(), secondaryAlias, secondaryName, criterion.isDescending());
                continue;
            }
            builder.orderBy(criterion.getAlias(), criterion.getName(), criterion.isDescending());
        }
    }

    @Override
    public void modifyQueryObject(Query query) {
        query.setOffset(0L);
    }

    String getData(Map<?, ?> data, String path) {
        String[] segs = path.split("/");
        for (int s = 0; s < segs.length - 1; ++s) {
            String seg = segs[s];
            Object obj = data.get(seg);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof Map)) {
                if (obj instanceof TimeAuthorInformation) {
                    if (segs[segs.length - 1].equals("at")) {
                        return ((TimeAuthorInformation)obj).getAt().toString();
                    }
                    return "\"" + ((TimeAuthorInformation)obj).getBy();
                }
                return null;
            }
            data = (Map)obj;
        }
        Object obj = data.get(segs[segs.length - 1]);
        if (obj instanceof String) {
            return ((String)obj).isEmpty() ? null : "\"" + obj;
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof Calendar) {
            return ISO8601.format((Calendar)((Calendar)obj));
        }
        return null;
    }

    String calculateCursor(Map<String, Object> data) {
        Object cursor;
        if (data.containsKey(PN_SYNTHETIC_PAGING_CURSOR) && (cursor = data.get(PN_SYNTHETIC_PAGING_CURSOR)) instanceof Cursor) {
            LOG.debug("Synthetic cursor: {}", cursor);
            return ((Cursor)cursor).getRawValue();
        }
        cursor = new StringBuilder();
        for (Criterion criterion : this.criteria) {
            if (((StringBuilder)cursor).length() > 0) {
                ((StringBuilder)cursor).append("\n");
            }
            String value = this.getData(data, criterion.getGraphqlField());
            ((StringBuilder)cursor).append(value);
        }
        return ((StringBuilder)cursor).toString();
    }

    public Function<Map<String, Object>, String> getCursorProvider() {
        return this::calculateCursor;
    }

    public void addCriterion(@Nullable String alias, @NotNull String name, @NotNull String graphqlField) {
        this.criteria.add(new Criterion(name, alias, graphqlField));
    }

    public void addCriterion(@Nullable String alias, @NotNull String name, @NotNull String graphqlField, boolean isDescending) {
        this.criteria.add(new Criterion(name, alias, graphqlField, isDescending));
    }

    public void addCriterion(@Nullable String alias, @NotNull String name, @NotNull String graphqlField, boolean isDescending, Function<String, Object> typeConversionFunc) {
        this.criteria.add(new Criterion(name, alias, graphqlField, isDescending, typeConversionFunc));
    }

    public void addCriterion(@NotNull String primaryAlias, @NotNull String primaryName, @NotNull String secondaryAlias, @NotNull String secondaryName, @NotNull String graphqlField, boolean isDescending, Function<String, Object> typeConversionFunc) {
        this.criteria.add(new Criterion(primaryName, primaryAlias, secondaryName, secondaryAlias, graphqlField, isDescending, typeConversionFunc));
    }

    public void addCriterion(@NotNull String name, @NotNull String graphqlField) {
        this.addCriterion(null, name, graphqlField);
    }

    public void addCriterion(@NotNull String name, @NotNull String graphqlField, boolean isDescending) {
        this.addCriterion(null, name, graphqlField, isDescending);
    }

    Iterator<Criterion> getCriteria() {
        return this.criteria.iterator();
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    public static Iterator<Map<String, Object>> ensureCursorAvailable(Iterator<Map<String, Object>> it, PagingImpl paging, String cursor) {
        Map<String, Object> data;
        String dataCursor;
        if (cursor == null) {
            return it;
        }
        List<Map<String, Object>> list = Util.toList(it);
        if (!list.isEmpty() && !(dataCursor = new Cursor(paging.calculateCursor(data = list.get(0))).getEncoded()).equals(cursor)) {
            HashMap<String, Cursor> dummyData = new HashMap<String, Cursor>(3);
            Cursor syntheticCursor = Cursor.fromEncodedString((String)cursor);
            LOG.debug("Using synthetic cursor: {}", (Object)syntheticCursor);
            dummyData.put(PN_SYNTHETIC_PAGING_CURSOR, syntheticCursor);
            list.add(0, dummyData);
        }
        return list.iterator();
    }

    private void buildSubConditions(ConditionBuilder builder, int lastCriterionToInclude) {
        for (int s = 0; s < lastCriterionToInclude; ++s) {
            Criterion subCriterion = this.criteria.get(s);
            if (!this.cursorValues[s].equals(NULL)) {
                this.addToBuilder(builder, subCriterion, CompOp.EQUAL, this.cursorValues[s], LogOp.AND);
                continue;
            }
            this.addToBuilder(builder, subCriterion, CompOp.IS, null, LogOp.AND);
        }
    }

    static class Criterion {
        @NotNull
        private final String name;
        @Nullable
        private final String alias;
        @NotNull
        private final String graphqlField;
        private final boolean isDescending;
        @NotNull
        private final Function<String, Object> typeConversionFunc;
        @Nullable
        private final String secondaryName;
        @Nullable
        private final String secondaryAlias;

        Criterion(@NotNull String primaryName, @Nullable String primaryAlias, @Nullable String secondaryName, @Nullable String secondaryAlias, @NotNull String graphqlField, boolean isDescending, @NotNull Function<String, Object> typeConversionFunc) {
            LOG.debug("Creating criterion for {}: {}.[{}] ({}.[{}]), {}", new Object[]{graphqlField, primaryAlias != null ? primaryAlias : "<>", primaryName, secondaryAlias != null ? secondaryAlias : "<>", secondaryName != null ? secondaryName : "<>", isDescending ? "DESC" : "ASC"});
            this.name = primaryName;
            this.alias = primaryAlias;
            this.secondaryName = secondaryName;
            this.secondaryAlias = secondaryAlias;
            this.graphqlField = graphqlField;
            this.isDescending = isDescending;
            this.typeConversionFunc = typeConversionFunc;
        }

        Criterion(@NotNull String name, @Nullable String alias, @NotNull String graphqlField, boolean isDescending, @NotNull Function<String, Object> typeConversionFunc) {
            this(name, alias, null, null, graphqlField, isDescending, typeConversionFunc);
        }

        Criterion(@NotNull String name, @Nullable String alias, @NotNull String graphqlField, boolean isDescending) {
            this(name, alias, graphqlField, isDescending, o -> o);
        }

        Criterion(@NotNull String name, @Nullable String alias, @NotNull String graphqlField) {
            this(name, alias, graphqlField, false);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getAlias() {
            return this.alias;
        }

        @Nullable
        public String getSecondaryName() {
            return this.secondaryName;
        }

        @Nullable
        public String getSecondaryAlias() {
            return this.secondaryAlias;
        }

        @NotNull
        public String getGraphqlField() {
            return this.graphqlField;
        }

        public boolean isDescending() {
            return this.isDescending;
        }

        @NotNull
        public Function<String, Object> getTypeConversionFunc() {
            return this.typeConversionFunc;
        }
    }
}

