/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql;

import com.adobe.cq.dam.cfm.headless.backend.FieldDefinition;
import com.adobe.cq.dam.cfm.headless.backend.FragmentField;
import com.adobe.cq.dam.cfm.headless.backend.SortingField;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.PagingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentSorting {
    public static final String FN_PUBLISHED_BY = "publishedBy";
    public static final String FN_PUBLISHED_AT = "publishedAt";
    public static final String FN_MODIFIED_BY = "modifiedBy";
    private static Map<String, FragmentField> fields = new HashMap<String, FragmentField>();
    private static final Logger LOG;
    private final List<SortingDef> sortingFields = new ArrayList<SortingDef>();

    public static void setFields(Map<String, FragmentField> fields) {
        FragmentSorting.fields = fields;
    }

    public FragmentSorting(String sortingDef) {
        String[] segs;
        if (sortingDef == null) {
            return;
        }
        for (String seg : segs = sortingDef.split(",")) {
            String field;
            seg = seg.trim();
            boolean isDescending = false;
            int sepPos = seg.indexOf(" ");
            if (sepPos < 0) {
                field = seg.trim();
            } else {
                field = seg.substring(0, sepPos).trim();
                isDescending = "DESC".equalsIgnoreCase(seg.substring(sepPos + 1).trim());
            }
            FieldDefinition fieldDef = null;
            if (fields.containsKey(field)) {
                fieldDef = fields.get(field);
            } else {
                LOG.warn("Unsupported field name detected: {}.", (Object)field);
            }
            if (fieldDef == null) continue;
            this.addField(fieldDef, isDescending);
        }
    }

    public Iterator<SortingField> getSorting() {
        return this.sortingFields.stream().map(SortingDef::getField).collect(Collectors.toList()).iterator();
    }

    public void toPaging(PagingImpl paging) {
        this.sortingFields.forEach(def -> {
            SortingField field = def.getField();
            if (field.getSecondaryName() != null) {
                if (field.getSecondaryAlias() == null || field.getAlias() == null) {
                    throw new IllegalArgumentException("For coalesced fields an alias is required for both fields.");
                }
                paging.addCriterion(field.getAlias(), field.getName(), field.getSecondaryAlias(), field.getSecondaryName(), def.getGraphqlLink(), field.isDescending(), def.getTypeConversionFunc());
            } else {
                paging.addCriterion(field.getAlias(), field.getName(), def.getGraphqlLink(), field.isDescending(), def.getTypeConversionFunc());
            }
        });
        paging.addCriterion(FragmentField.UUID.getAlias(), FragmentField.UUID.getPropertyPath(), FragmentField.UUID.getNameInResult(), false, FragmentField.UUID.getConversionFunc());
    }

    private void addField(FieldDefinition fieldDef, boolean isDescending) {
        String alias = fieldDef.getAlias();
        String propertyPath = fieldDef.getPropertyPath();
        String secondaryAlias = fieldDef.getSecondaryAlias();
        String secondaryPath = fieldDef.getSecondaryPropertyPath();
        LOG.debug("Adding sorting criterion on {}; {}.[{}] ({}.[{}])", new Object[]{fieldDef.getNameInResult(), alias != null ? alias : "<>", propertyPath != null ? propertyPath : "<>", secondaryAlias != null ? secondaryAlias : "<>", secondaryPath != null ? secondaryPath : "<>"});
        this.sortingFields.add(new SortingDef(new SortingField(alias, propertyPath, isDescending, secondaryAlias, secondaryPath), fieldDef.getNameInResult(), fieldDef.getConversionFunc()));
    }

    static {
        fields.put("title", FragmentField.TITLE);
        fields.put("created", FragmentField.CREATED_AT);
        fields.put("modified", FragmentField.MODIFIED_AT);
        fields.put("modifiedOrCreated", FragmentField.MODIFIED_OR_CREATED_AT);
        fields.put(FN_PUBLISHED_BY, FragmentField.PUBLISHED_BY);
        fields.put(FN_PUBLISHED_AT, FragmentField.PUBLISHED_AT);
        fields.put(FN_MODIFIED_BY, FragmentField.MODIFIED_BY);
        fields.put("name", FragmentField.NAME);
        LOG = LoggerFactory.getLogger(FragmentSorting.class);
    }

    private static class SortingDef {
        private final SortingField field;
        private final String graphqlLink;
        private final Function<String, Object> typeConversionFunc;

        SortingDef(SortingField field, String graphqlLink, Function<String, Object> typeConversionFunc) {
            this.field = field;
            this.graphqlLink = graphqlLink;
            this.typeConversionFunc = typeConversionFunc;
        }

        public SortingField getField() {
            return this.field;
        }

        public String getGraphqlLink() {
            return this.graphqlLink;
        }

        public Function<String, Object> getTypeConversionFunc() {
            return this.typeConversionFunc;
        }
    }
}

