/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql;

import com.adobe.cq.dam.cfm.headless.backend.FragmentListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryMode;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.AbstractFetcher;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.FragmentFilterImpl;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.FragmentSorting;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.PagingImpl;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.api.SlingDataFetcherEnvironment;
import org.apache.sling.graphql.api.pagination.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingDataFetcher.class}, property={"name=aemremote/cfmlist"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentListFetcher
extends AbstractFetcher<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentListFetcher.class);
    @Reference
    private FragmentListGenerator listGenerator;

    @Nullable
    public Object get(@NotNull SlingDataFetcherEnvironment env) {
        Resource resource = env.getCurrentResource();
        if (resource == null) {
            throw new NullPointerException("No resource available.");
        }
        String filterDef = (String)env.getArgument("filter", null);
        String sortDef = (String)env.getArgument("sort", null);
        String after = (String)env.getArgument("after", null);
        int limit = (Integer)env.getArgument("limit", (Object)25);
        Cursor cursor = Cursor.fromEncodedString((String)after);
        if (cursor != null) {
            LOG.debug("Cursor: {} -> {}", (Object)cursor, (Object)cursor.getRawValue());
        } else {
            LOG.debug("No cursor, start from the beginning");
        }
        PagingImpl paging = new PagingImpl(cursor, limit);
        new FragmentSorting(sortDef).toPaging(paging);
        ResourceResolver resolver = resource.getResourceResolver();
        FragmentFilterImpl filter = new FragmentFilterImpl(filterDef);
        String modeParam = (String)env.getArgument("ftsMode");
        LOG.debug("Mode argument: {}", (Object)modeParam);
        FullTextQueryMode mode = modeParam != null ? FullTextQueryMode.valueOf(modeParam) : null;
        mode = mode != null ? mode : FullTextQueryMode.AS_IS;
        LOG.debug("Mode: {}", (Object)mode);
        Iterator<Map<String, Object>> listIt = this.getListGenerator().getList(resolver, filter, paging, mode);
        listIt = PagingImpl.ensureCursorAvailable(listIt, paging, after);
        return this.createConnBuilder(listIt, paging.getCursorProvider()).withStartAfter(cursor).withLimit(limit).build();
    }

    protected FragmentListGenerator getListGenerator() {
        return this.listGenerator;
    }
}

