/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql;

import com.adobe.cq.dam.cfm.headless.backend.FragmentFilter;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.day.cq.commons.LanguageUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jackrabbit.util.ISO8601;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentFilterImpl
implements FragmentFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentFilterImpl.class);
    private static final String FN_AFTER = "After";
    private static final String FN_BEFORE = "Before";
    private static final String FN_BY = "By";
    private static final String FLT_MODIFIED_AFTER = "modifiedAfter";
    private static final String FLT_MODIFIED_BEFORE = "modifiedBefore";
    private static final String FLT_MODIFIED_BY = "modifiedBy";
    private static final String FLT_MODIFIED_CREATED_AFTER = "modifiedOrCreatedAfter";
    private static final String FLT_MODIFIED_CREATED_BEFORE = "modifiedOrCreatedBefore";
    private static final String FLT_MODIFIED_CREATED_BY = "modifiedOrCreatedBy";
    private static final String FLT_CREATED_AFTER = "createdAfter";
    private static final String FLT_CREATED_TO = "createdBefore";
    private static final String FLT_CREATED_BY = "createdBy";
    private static final String FLT_PUBLISHED_AFTER = "publishedAfter";
    private static final String FLT_PUBLISHED_BEFORE = "publishedBefore";
    private static final String FLT_PUBLISHED_BY = "publishedBy";
    private static final String FLT_MODEL_PATH = "modelPath";
    private static final String FLT_TAGS_PATH = "tags";
    private static final String FLT_LOCALE = "locale";
    private static final String FLT_FULLTEXT_SEARCH = "fts";
    private Set<String> model;
    private String fullTextSearch;
    private String path;
    private Calendar modifiedAfter;
    private Calendar modifiedBefore;
    private Set<String> modifiedBy;
    private Calendar modifiedOrCreatedAfter;
    private Calendar modifiedOrCreatedBefore;
    private Set<String> modifiedOrCreatedBy;
    private Calendar createdAfter;
    private Calendar createdBefore;
    private Set<String> createdBy;
    private Calendar publishedAfter;
    private Calendar publishedBefore;
    private Set<String> publishedBy;
    private Set<StatusInfo> status;
    private Set<Locale> locale;
    private Set<String> tags;

    public FragmentFilterImpl(String filterDef) {
        String[] filterSegs;
        if (filterDef == null) {
            return;
        }
        block40: for (String filterSeg : filterSegs = filterDef.split(";")) {
            String[] filterParts = filterSeg.split("=");
            if (filterParts.length != 2) continue;
            String name = filterParts[0];
            String value = filterParts[1];
            switch (name) {
                case "modelPath": {
                    this.model = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                case "fts": {
                    this.fullTextSearch = value;
                    continue block40;
                }
                case "path": {
                    this.path = value;
                    continue block40;
                }
                case "modifiedAfter": {
                    this.modifiedAfter = ISO8601.parse((String)value);
                    continue block40;
                }
                case "modifiedBefore": {
                    this.modifiedBefore = ISO8601.parse((String)value);
                    continue block40;
                }
                case "modifiedBy": {
                    this.modifiedBy = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                case "modifiedOrCreatedAfter": {
                    this.modifiedOrCreatedAfter = ISO8601.parse((String)value);
                    continue block40;
                }
                case "modifiedOrCreatedBefore": {
                    this.modifiedOrCreatedBefore = ISO8601.parse((String)value);
                    continue block40;
                }
                case "modifiedOrCreatedBy": {
                    this.modifiedOrCreatedBy = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                case "createdAfter": {
                    this.createdAfter = ISO8601.parse((String)value);
                    continue block40;
                }
                case "createdBefore": {
                    this.createdBefore = ISO8601.parse((String)value);
                    continue block40;
                }
                case "createdBy": {
                    this.createdBy = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                case "publishedAfter": {
                    this.publishedAfter = ISO8601.parse((String)value);
                    continue block40;
                }
                case "publishedBefore": {
                    this.publishedBefore = ISO8601.parse((String)value);
                    continue block40;
                }
                case "publishedBy": {
                    this.publishedBy = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                case "locale": {
                    this.locale = FragmentFilterImpl.convertParameter(value, FragmentFilterImpl::transformToLocale);
                    continue block40;
                }
                case "status": {
                    this.status = FragmentFilterImpl.convertParameter(value, FragmentFilterImpl::transformToStatusInfo);
                    continue block40;
                }
                case "tags": {
                    this.tags = FragmentFilterImpl.convertParameter(value);
                    continue block40;
                }
                default: {
                    LOG.warn("Unsupported filter name detected: {}.", (Object)name);
                }
            }
        }
    }

    @Override
    public Set<String> model() {
        return this.model;
    }

    @Override
    public String fullTextSearch() {
        return this.fullTextSearch;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Calendar modifiedAfter() {
        return this.modifiedAfter;
    }

    @Override
    public Calendar modifiedBefore() {
        return this.modifiedBefore;
    }

    @Override
    public Set<String> modifiedBy() {
        return this.modifiedBy;
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    @Override
    public Calendar modifiedOrCreatedAfter() {
        return this.modifiedOrCreatedAfter;
    }

    @Override
    public Calendar modifiedOrCreatedBefore() {
        return this.modifiedOrCreatedBefore;
    }

    @Override
    public Set<String> modifiedOrCreatedBy() {
        return this.modifiedOrCreatedBy;
    }

    @Override
    public Calendar createdAfter() {
        return this.createdAfter;
    }

    @Override
    public Calendar createdBefore() {
        return this.createdBefore;
    }

    @Override
    public Set<String> createdBy() {
        return this.createdBy;
    }

    @Override
    public Calendar publishedAfter() {
        return this.publishedAfter;
    }

    @Override
    public Calendar publishedBefore() {
        return this.publishedBefore;
    }

    @Override
    public Set<String> publishedBy() {
        return this.publishedBy;
    }

    @Override
    public Set<Locale> locale() {
        return this.locale;
    }

    @Override
    public Set<StatusInfo> status() {
        return this.status != null ? this.status : Collections.emptySet();
    }

    private static Set<String> convertParameter(String commaSeparated) {
        return FragmentFilterImpl.convertParameter(commaSeparated, s -> s);
    }

    private static <T> Set<T> convertParameter(String commaSeparated, Function<String, T> transform) {
        return Stream.of(commaSeparated.split(",")).map(transform).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static StatusInfo transformToStatusInfo(String value) {
        try {
            return StatusInfo.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static Locale transformToLocale(String value) {
        try {
            return LanguageUtil.getLocale((String)value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

