/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql;

import com.adobe.cq.dam.cfm.headless.backend.FolderListGenerator;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.AbstractFetcher;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.PagingImpl;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.graphql.api.SlingDataFetcher;
import org.apache.sling.graphql.api.SlingDataFetcherEnvironment;
import org.apache.sling.graphql.api.pagination.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingDataFetcher.class}, property={"name=aemremote/folderlist"}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FolderListFetcher
extends AbstractFetcher<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(FolderListFetcher.class);
    @Reference
    private FolderListGenerator listGenerator;

    @Nullable
    public Object get(@NotNull SlingDataFetcherEnvironment env) {
        Resource resource = env.getCurrentResource();
        if (resource == null) {
            throw new NullPointerException("No resource available.");
        }
        String rootPath = (String)env.getArgument("rootPath", null);
        String after = (String)env.getArgument("after", null);
        int limit = (Integer)env.getArgument("limit", (Object)25);
        Cursor cursor = Cursor.fromEncodedString((String)after);
        if (cursor != null) {
            LOG.debug("Cursor: {} -> {}", (Object)cursor, (Object)cursor.getRawValue());
        } else {
            LOG.debug("No cursor, start from the beginning");
        }
        PagingImpl paging = new PagingImpl(cursor, limit);
        FolderListFetcher.addNameCriterionToPaging(paging);
        ResourceResolver resolver = resource.getResourceResolver();
        Iterator<Map<String, Object>> listIt = this.getListGenerator().getList(resolver, paging, rootPath);
        return this.createConnBuilder(listIt, paging.getCursorProvider()).withStartAfter(cursor).withLimit(limit).build();
    }

    protected FolderListGenerator getListGenerator() {
        return this.listGenerator;
    }

    static void addNameCriterionToPaging(PagingImpl paging) {
        paging.addCriterion(null, "name()", "name", false, folderName -> folderName.substring(1));
    }
}

