/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.remoteapi.impl;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.DataType;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferenceType;
import com.adobe.cq.xf.ExperienceFragment;
import com.day.cq.dam.api.Asset;
import com.day.cq.wcm.api.reference.Reference;
import com.day.cq.wcm.api.reference.ReferenceProvider;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.component.annotations.Component;

@Component(service={ReferenceProvider.class})
public class ContentFragmentReferenceProvider
implements ReferenceProvider {
    public static final String SEARCH_PATH = "/content";
    private static final Pattern SEARCH_PATTERN = Pattern.compile("(.[\"']|^|^[\"'])(" + Pattern.quote("/content") + ")\\b");

    protected ReferenceType getType(@Nonnull Resource resource) {
        if (resource.adaptTo(ContentFragment.class) != null) {
            return ReferenceType.CONTENT_FRAGMENT;
        }
        if (this.isXF(resource)) {
            return ReferenceType.EXPERIENCE_FRAGMENT;
        }
        if (this.isPage(resource)) {
            return ReferenceType.PAGE;
        }
        if (this.isAsset(resource)) {
            return ReferenceType.ASSET;
        }
        return ReferenceType.MISC;
    }

    Calendar determineLastModified(ReferenceType type, Resource resource) {
        ValueMap props = resource.getValueMap();
        switch (type) {
            case ASSET: {
                return (Calendar)props.get("jcr:content/jcr:lastModified", (Object)((Calendar)props.get("jcr:created", (Object)Calendar.getInstance())));
            }
            case PAGE: {
                return (Calendar)props.get("jcr:content/cq:lastModified", (Object)((Calendar)props.get("jcr:content/jcr:lastModified", (Object)((Calendar)props.get("jcr:created", (Object)Calendar.getInstance())))));
            }
        }
        Resource jcrContent = resource.getChild("jcr:content");
        if (jcrContent != null) {
            ValueMap jcrContentValueMap = jcrContent.getValueMap();
            return (Calendar)jcrContentValueMap.get("jcr:lastModified", (Object)((Calendar)props.get("jcr:created", (Object)Calendar.getInstance())));
        }
        return (Calendar)props.get("jcr:created", (Object)Calendar.getInstance());
    }

    private Set<Reference> getReferencesFromReferenceDataType(ContentElement element, ResourceResolver resourceResolver) {
        HashSet<Reference> references = new HashSet<Reference>();
        this.extractReferenceFromData(resourceResolver, references, element.getValue());
        Iterator variations = element.getVariations();
        while (variations.hasNext()) {
            ContentVariation variation = (ContentVariation)variations.next();
            FragmentData data = variation.getValue();
            this.extractReferenceFromData(resourceResolver, references, data);
        }
        return references;
    }

    private void extractReferenceFromData(ResourceResolver resourceResolver, Set<Reference> references, FragmentData data) {
        if (data.getDataType().isMultiValue()) {
            this.addReferenceFromPaths(resourceResolver, references, (String[])data.getValue(String[].class));
        } else {
            this.addReferenceFromPaths(resourceResolver, references, (String)data.getValue(String.class));
        }
    }

    private void addReferenceFromPaths(ResourceResolver resourceResolver, Set<Reference> references, String ... referenceResourcePaths) {
        if (referenceResourcePaths != null) {
            List referenceResources = Arrays.stream(referenceResourcePaths).filter(StringUtils::isNotEmpty).map(arg_0 -> ((ResourceResolver)resourceResolver).getResource(arg_0)).collect(Collectors.toList());
            for (Resource referenceResource : referenceResources) {
                if (referenceResource == null) continue;
                ReferenceType type = this.getType(referenceResource);
                Calendar modified = this.determineLastModified(type, referenceResource);
                references.add(new Reference(type.getValue(), referenceResource.getName(), referenceResource, modified.getTimeInMillis()));
            }
        }
    }

    private Set<Reference> getReferencesFromMultilineDataType(ContentElement element, ResourceResolver resourceResolver) {
        HashSet<Reference> references = new HashSet<Reference>();
        HashSet<String> refs = new HashSet<String>();
        Iterator variations = element.getVariations();
        while (variations.hasNext()) {
            ContentVariation variation = (ContentVariation)variations.next();
            this.extractedRefs(refs, variation);
        }
        for (String ref : refs) {
            Resource referencedResource = resourceResolver.getResource(ref);
            if (referencedResource == null) continue;
            ReferenceType type = this.getType(referencedResource);
            Calendar modified = this.determineLastModified(type, referencedResource);
            references.add(new Reference(type.toString(), referencedResource.getName(), referencedResource, modified.getTimeInMillis()));
        }
        return references;
    }

    private void extractedRefs(Set<String> refs, ContentVariation variation) {
        FragmentData data = variation.getValue();
        if (data.getDataType().isMultiValue()) {
            String[] values = (String[])data.getValue(String[].class);
            if (values == null) {
                return;
            }
            for (String value : values) {
                if (!SEARCH_PATTERN.matcher(value).find()) continue;
                refs.addAll(this.getRefs(value));
            }
        } else {
            String value = (String)data.getValue(String.class);
            if (value == null) {
                return;
            }
            refs.addAll(this.getRefs(value));
        }
    }

    private Set<Reference> addElementReferences(ContentFragment fragment) {
        HashSet<Reference> refs = new HashSet<Reference>();
        Iterator elements = fragment.getElements();
        Resource fragRsc = (Resource)fragment.adaptTo(Resource.class);
        if (fragRsc == null) {
            return refs;
        }
        ResourceResolver resourceResolver = fragRsc.getResourceResolver();
        while (elements.hasNext()) {
            DataType dataType;
            String semanticDataType;
            ContentElement element = (ContentElement)elements.next();
            FragmentData data = element.getValue();
            if (data == null || (semanticDataType = (dataType = data.getDataType()).getSemanticType()) == null) continue;
            if (semanticDataType.equals("content-fragment") || semanticDataType.equals("reference")) {
                refs.addAll(this.getReferencesFromReferenceDataType(element, resourceResolver));
                continue;
            }
            if (!semanticDataType.equals("multiline")) continue;
            refs.addAll(this.getReferencesFromMultilineDataType(element, resourceResolver));
        }
        return refs;
    }

    public List<Reference> findReferences(Resource resource) {
        LinkedList<Reference> references = new LinkedList<Reference>();
        if (resource == null) {
            return references;
        }
        if (resource.getPath().endsWith("jcr:content") && (resource = resource.getParent()) == null) {
            return references;
        }
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment != null) {
            references.addAll(this.addElementReferences(contentFragment));
        }
        return references;
    }

    private boolean isPage(Resource resource) {
        return resource != null && "cq:Page".equals(resource.getResourceType());
    }

    private boolean isAsset(Resource resource) {
        return resource.adaptTo(Asset.class) != null;
    }

    private boolean isXF(Resource resource) {
        return resource.adaptTo(ExperienceFragment.class) != null;
    }

    private Set<String> getRefs(String value) {
        HashSet<String> refs = new HashSet<String>();
        int startPos = value.indexOf(SEARCH_PATH, 1);
        while (startPos != -1) {
            int endPos;
            char charBeforeStartPos = value.charAt(startPos - 1);
            if ((charBeforeStartPos == '\'' || charBeforeStartPos == '\"') && (endPos = value.indexOf(charBeforeStartPos, startPos)) > startPos) {
                String ref = value.substring(startPos, endPos);
                refs.add(ref);
                startPos = endPos;
            }
            startPos = value.indexOf(SEARCH_PATH, startPos + 1);
        }
        return refs;
    }
}

