/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow.workflowpackage;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class WorkflowPackageBuilder {
    private static final String ATT_SLING_RT = "sling:resourceType";
    private static final String PATH_TEMPLATE_COLLECTIONPAGE = "/libs/cq/workflow/templates/collectionpage";
    private static final String RT_FILTER = "cq/workflow/components/collection/definition/resourcelist";
    private static final String RT_FILTER_RESOURCE = "cq/workflow/components/collection/definition/resource";
    private String workflowPackagesPath;

    public void setWorkflowPackagesPath(String workflowPackagesPath) {
        this.workflowPackagesPath = workflowPackagesPath;
    }

    public Resource create(ResourceResolver resourceResolver, String title, Iterator<Resource> payload) throws PersistenceException {
        Resource wfPackage = this.createPackage(resourceResolver, title);
        Resource payloadContainer = this.createPayloadContainer(wfPackage, title);
        this.addPayload(payloadContainer, payload);
        return wfPackage;
    }

    private Resource createPackage(ResourceResolver resourceResolver, String title) throws PersistenceException {
        Resource root = this.getPackageRoot(resourceResolver);
        return this.createPackage(root, title);
    }

    private Resource getPackageRoot(ResourceResolver resourceResolver) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resourceResolver, (String)this.workflowPackagesPath, (String)"sling:Folder", (String)"sling:Folder", (boolean)true);
    }

    private Resource createPackage(Resource root, String title) throws PersistenceException {
        String excapedName = ISO9075.encode((String)title);
        ValueMap properties = this.getPrimaryTypeMap("cq:Page");
        return this.add(root, excapedName, properties);
    }

    private Resource createPayloadContainer(Resource page, String title) throws PersistenceException {
        Resource content = this.createContentResource(page, title);
        Resource definition = this.add(content, "vlt:definition", this.getPrimaryTypeMap("vlt:PackageDefinition"));
        return this.add(definition, "filter", this.getValueMap(ATT_SLING_RT, RT_FILTER));
    }

    private Resource createContentResource(Resource page, String name) throws PersistenceException {
        ResourceResolver resolver = page.getResourceResolver();
        String templatePath = "/libs/cq/workflow/templates/collectionpage/jcr:content";
        Resource template = resolver.getResource("/libs/cq/workflow/templates/collectionpage/jcr:content");
        if (template == null) {
            throw new PersistenceException(String.format("Resource not found %s", templatePath));
        }
        ValueMap vm = (ValueMap)template.adaptTo(ValueMap.class);
        if (vm == null) {
            throw new PersistenceException(String.format("Could adapt resource %s to value map", templatePath));
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)vm);
        properties.put("cq:template", PATH_TEMPLATE_COLLECTIONPAGE);
        properties.put("jcr:title", name);
        properties.remove("jcr:created");
        properties.remove("jcr:createdBy");
        return this.add(page, "jcr:content", (ValueMap)new ValueMapDecorator(properties));
    }

    private void addPayload(Resource container, Iterator<Resource> payload) throws PersistenceException {
        while (payload.hasNext()) {
            Resource resource = payload.next();
            if (resource == null) continue;
            String path = resource.getPath();
            ValueMap properties = this.getFilterResourceProperties(path);
            this.add(container, "resource", properties);
        }
    }

    private ValueMap getFilterResourceProperties(String path) {
        ValueMap properties = this.getValueMap("root", path);
        properties.put((Object)"rules", (Object)new String[]{"include:" + path, "include:" + path + "/jcr:content(/.*)?"});
        properties.put((Object)ATT_SLING_RT, (Object)RT_FILTER_RESOURCE);
        return properties;
    }

    private Resource add(Resource parent, String name, ValueMap properties) throws PersistenceException {
        ResourceResolver resourceResolver = parent.getResourceResolver();
        String uniqueName = ResourceUtil.createUniqueChildName((Resource)parent, (String)name);
        return resourceResolver.create(parent, uniqueName, (Map)properties);
    }

    private ValueMap getPrimaryTypeMap(String nodeType) {
        return this.getValueMap("jcr:primaryType", nodeType);
    }

    private ValueMap getValueMap(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return new ValueMapDecorator(map);
    }
}

