/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process;

import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process.ProcessHelper;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process.ReplicationParams;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.replication.Location;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.Replicator;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplicatePageProcess
implements WorkflowProcess {
    private static final int REPLICATION_BATCH_SIZE = 50;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicatePageProcess.class);
    private static final String METADATA_PN_LAST_PROCESSED_PATH = "replicatePageLastProcessedPath";
    private static final String METADATA_NO_REPLICATION_PRIVILEGE_LIST = "noReplicationPrivilegePathsList";
    @Reference
    protected Replicator replicator;
    @Reference
    protected EventAdmin eventAdmin;
    @Reference
    protected AgentManager agentManager;
    @Reference
    protected SlingRepository repository;
    @Reference
    protected ResourceCollectionManager rcManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        Session session = ProcessHelper.getWorkflowSession(workflowSession, workItem);
        Session participantSession = this.getParticipantSession(workItem, workflowSession, args);
        Session replicationSession = this.getReplicationSession(workItem, workflowSession, session, participantSession);
        try {
            WorkflowData data = ProcessHelper.getWorkflowData(workItem);
            MetaDataMap metaDataMap = data.getMetaDataMap();
            Map<String, String> versionMap = this.getVersions(metaDataMap);
            String agentId = this.computeAgentId(metaDataMap);
            List<String> paths = ProcessHelper.getPaths(session, this.rcManager, data);
            List<String> references = ProcessHelper.getMetadataValueAsList(metaDataMap, "collectedReferences");
            paths.addAll(references);
            String lastProcessedPath = this.getLastProcessedPath(metaDataMap);
            Iterator<String> it = ProcessHelper.getPathIteratorStartingWith(paths, lastProcessedPath);
            ReplicationParams replicationParams = ReplicationParams.Builder.newInstance().setWorkflowSession(workflowSession).setSession(session).setWorkItem(workItem).setReplicationSession(replicationSession).setVersionMap(versionMap).setAgentId(agentId).setPageIterator(it).build();
            this.replicate(replicationParams);
        }
        catch (ReplicationException | JSONException e) {
            throw new WorkflowException(e);
        }
        catch (IOException e) {
            LOG.error("Failed to read data {}", (Object)e.getMessage());
        }
        finally {
            if (participantSession != null && participantSession.isLive()) {
                participantSession.logout();
            }
        }
    }

    protected List<String> replicate(ReplicationParams replicationParams) throws ReplicationException, WorkflowException {
        String lastBatchedPageSuccessfullyProcessed;
        ArrayList<String> replicationResultSummary = new ArrayList<String>();
        WorkItem workItem = replicationParams.getWorkItem();
        Iterator<String> it = replicationParams.getIt();
        Session replicationSession = replicationParams.getReplicationSession();
        Map<String, String> versionMap = replicationParams.getVersionMap();
        String agentId = replicationParams.getAgentId();
        WorkflowSession workflowSession = replicationParams.getWorkflowSession();
        Session session = replicationParams.getSession();
        ArrayList<String> batchAccumulator = new ArrayList<String>();
        Object noReplicationProvilegeList = ProcessHelper.getWorkflowData(workItem).getMetaDataMap().get((Object)METADATA_NO_REPLICATION_PRIVILEGE_LIST);
        Set<String> noReplicationPrivilegePagesAccumulator = this.getSetOfStringFromObject(noReplicationProvilegeList);
        while (it.hasNext()) {
            String path = it.next();
            if (this.canReplicate(replicationSession, path)) {
                if (batchAccumulator.size() < 50) {
                    batchAccumulator.add(path);
                }
                if (batchAccumulator.size() != 50) continue;
                replicationResultSummary.add("Full batch replication.");
                this.replicateBatch(batchAccumulator, versionMap, agentId, replicationSession);
                lastBatchedPageSuccessfullyProcessed = (String)batchAccumulator.get(batchAccumulator.size() - 1);
                this.updateMetadata(workItem, workflowSession, lastBatchedPageSuccessfullyProcessed, noReplicationPrivilegePagesAccumulator);
                batchAccumulator.clear();
                continue;
            }
            noReplicationPrivilegePagesAccumulator.add(path);
        }
        replicationResultSummary.add("Replicate non-full batch.");
        this.replicateBatch(batchAccumulator, versionMap, agentId, replicationSession);
        lastBatchedPageSuccessfullyProcessed = (String)batchAccumulator.get(batchAccumulator.size() - 1);
        this.updateMetadata(workItem, workflowSession, lastBatchedPageSuccessfullyProcessed, noReplicationPrivilegePagesAccumulator);
        batchAccumulator.clear();
        Iterator<String> iterator = noReplicationPrivilegePagesAccumulator.iterator();
        while (iterator.hasNext()) {
            String noReplicationPrivilegePage = iterator.next();
            replicationResultSummary.add("Request replication for: " + noReplicationPrivilegePage);
            this.requestForReplication(session, noReplicationPrivilegePage, agentId);
            iterator.remove();
            this.updateMetadata(workItem, workflowSession, lastBatchedPageSuccessfullyProcessed, noReplicationPrivilegePagesAccumulator);
        }
        return replicationResultSummary;
    }

    private Session getParticipantSession(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) {
        if (!this.replicateAsParticipant(args)) {
            return null;
        }
        String participantId = this.resolveParticipantId(workItem, workflowSession);
        if (participantId == null) {
            return null;
        }
        return this.getParticipantSession(participantId, workflowSession);
    }

    private Session getReplicationSession(WorkItem workItem, WorkflowSession workflowSession) {
        String initiatorUserId = workItem.getWorkflow().getInitiator();
        if (StringUtils.isEmpty((CharSequence)initiatorUserId)) {
            return null;
        }
        return ProcessHelper.getUserSession(this.repository, initiatorUserId, workflowSession);
    }

    private Map<String, String> getVersions(MetaDataMap metaDataMap) throws JSONException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        if (metaDataMap.containsKey((Object)"versions")) {
            JSONObject versionJs = new JSONObject((String)metaDataMap.get("versions", String.class));
            Iterator iterator = versionJs.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                versionMap.put(key, (String)versionJs.get(key));
            }
        }
        return versionMap;
    }

    private Session getReplicationSession(WorkItem workItem, WorkflowSession workflowSession, Session session, Session participantSession) {
        Session replicationSession;
        Session session2 = replicationSession = participantSession != null ? participantSession : this.getReplicationSession(workItem, workflowSession);
        if (replicationSession == null) {
            replicationSession = session;
        }
        return replicationSession;
    }

    private void requestForReplication(Session session, String path, String agentId) {
        LOG.debug("'The user {}' is not allowed to replicate the page/asset `{}`. Issuing request for replication.", (Object)session.getUserID(), (Object)path);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("path", path);
        properties.put("replicationType", (String)this.getReplicationType());
        properties.put("userId", session.getUserID());
        if (StringUtils.isNotEmpty((CharSequence)agentId)) {
            properties.put("agentId", agentId);
        }
        Event event = new Event("com/day/cq/wcm/workflow/req/for/activation", properties);
        this.eventAdmin.sendEvent(event);
    }

    private void updateMetadata(WorkItem workItem, WorkflowSession session, String lastProcessedPath, Set<String> noReplicationPrivilegePages) throws WorkflowException {
        MetaDataMap metadata = ProcessHelper.getWorkflowData(workItem).getMetaDataMap();
        metadata.put((Object)METADATA_PN_LAST_PROCESSED_PATH, (Object)lastProcessedPath);
        metadata.put((Object)METADATA_NO_REPLICATION_PRIVILEGE_LIST, noReplicationPrivilegePages);
        session.updateWorkflowData(workItem.getWorkflow(), workItem.getWorkflowData());
    }

    private String computeAgentId(MetaDataMap metaDataMap) {
        String agentId = null;
        if (metaDataMap.containsKey((Object)"agentId")) {
            agentId = (String)metaDataMap.get("agentId", String.class);
        }
        return agentId;
    }

    private void replicateBatch(List<String> batch, Map<String, String> versions, String agentId, Session session) throws ReplicationException {
        ReplicationOptions opts = this.buildReplicationOptions(agentId);
        Location[] locations = (Location[])batch.stream().map(path -> new Location(path, this.getVersionLabel((String)path, versions))).collect(Collectors.toList()).toArray(Location[]::new);
        this.replicator.replicate(session, this.getReplicationType(), locations, opts);
    }

    @NotNull
    private ReplicationOptions buildReplicationOptions(String agentId) {
        Agent agent;
        ReplicationOptions opts = new ReplicationOptions();
        if (StringUtils.isNotEmpty((CharSequence)agentId) && (agent = ProcessHelper.getAgent(agentId, this.agentManager)) != null) {
            String targetAgentId = agent.getId();
            opts.setFilter(fltAgent -> fltAgent.getId().equals(targetAgentId));
        }
        return opts;
    }

    private String getLastProcessedPath(MetaDataMap metadata) {
        return (String)metadata.get(METADATA_PN_LAST_PROCESSED_PATH, String.class);
    }

    private String getVersionLabel(String path, Map<String, String> versionMap) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        if (versionMap.containsKey(path)) {
            return versionMap.get(path);
        }
        if (!((String)path).endsWith("/jcr:content")) {
            path = (String)path + "/jcr:content";
        }
        return versionMap.get(path);
    }

    private boolean replicateAsParticipant(MetaDataMap args) {
        String processArgs = (String)args.get(Arguments.PROCESS_ARGS.getArgumentName(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            String[] arguments;
            for (String argument : arguments = processArgs.split(",")) {
                String[] split = argument.split("=");
                if (split.length != 2) continue;
                String key = split[0];
                String value = split[1];
                if (!key.equalsIgnoreCase(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName())) continue;
                return Boolean.parseBoolean(value);
            }
            return false;
        }
        return (Boolean)args.get(Arguments.REPLICATE_AS_PARTICIPANT.getArgumentName(), (Object)Boolean.FALSE);
    }

    private Session getParticipantSession(String participantId, WorkflowSession workflowSession) {
        try {
            return this.repository.impersonateFromService(workflowSession.getSession().getUserID(), (Credentials)new SimpleCredentials(participantId, new char[0]), null);
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    private String resolveParticipantId(WorkItem workItem, WorkflowSession workflowSession) {
        try {
            List history = workflowSession.getHistory(workItem.getWorkflow());
            for (int index = history.size() - 1; index >= 0; --index) {
                HistoryItem previous = (HistoryItem)history.get(index);
                String type = previous.getWorkItem().getNode().getType();
                if (type == null || !type.equals("PARTICIPANT") && !type.equals("DYNAMIC_PARTICIPANT")) continue;
                return previous.getUserId();
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    public abstract ReplicationActionType getReplicationType();

    protected boolean canReplicate(Session session, String path) {
        try {
            AccessControlManager acMgr = session.getAccessControlManager();
            return acMgr.hasPrivileges(path, new Privilege[]{acMgr.privilegeFromName("{http://www.day.com/crx/1.0}replicate")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private Set<String> getSetOfStringFromObject(Object objectSet) {
        HashSet<String> stringSet = new HashSet<String>();
        if (objectSet instanceof Set) {
            for (Object object : (Set)objectSet) {
                if (object instanceof String) {
                    stringSet.add((String)object);
                    continue;
                }
                return Collections.emptySet();
            }
        }
        return stringSet;
    }

    private static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        REPLICATE_AS_PARTICIPANT("replicateAsParticipant");

        private final String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }
    }
}

