/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process;

import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.wcm.workflow.process.ResourceCollectionHelper;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessHelper.class);

    private ProcessHelper() {
    }

    public static Set<String> getMetadataValueAsSet(WorkItem workItem, String key) throws IOException, WorkflowException {
        MetaDataMap metaDataMap = ProcessHelper.getWorkflowData(workItem).getMetaDataMap();
        if (!metaDataMap.containsKey((Object)key)) {
            return new HashSet<String>();
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = (String)metaDataMap.get(key, String.class);
        List values = (List)mapper.readValue(jsonString, (TypeReference)new TypeReference<List<String>>(){});
        return values != null ? new HashSet<String>(values) : new HashSet();
    }

    public static List<String> getMetadataValueAsList(MetaDataMap metaDataMap, String key) throws IOException {
        if (!metaDataMap.containsKey((Object)key)) {
            return new ArrayList<String>();
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = (String)metaDataMap.get(key, String.class);
        List references = (List)mapper.readValue(jsonString, (TypeReference)new TypeReference<List<String>>(){});
        return references != null ? references : new ArrayList();
    }

    public static Iterator<String> getPathIteratorStartingWith(List<String> paths, String lastProcessedPath) {
        Iterator<String> it = paths.iterator();
        if (lastProcessedPath != null) {
            String path = null;
            while (it.hasNext() && !lastProcessedPath.equals(path)) {
                path = it.next();
            }
        }
        return it;
    }

    public static Agent getAgent(String agentId, AgentManager agentManager) {
        LOG.debug("Get agent: {}", (Object)agentId);
        if (agentId == null || agentManager == null) {
            return null;
        }
        Map agents = agentManager.getAgents();
        Set entries = agents.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Agent agent = (Agent)entry.getValue();
            if (!name.equals(agentId)) continue;
            return agent;
        }
        return null;
    }

    public static WorkflowData getWorkflowData(WorkItem workItem) throws WorkflowException {
        WorkflowData data = workItem.getWorkflowData();
        if (data == null) {
            throw new WorkflowException(String.format("Unable to get the workflow data for work item with id:%s", workItem.getId()));
        }
        return data;
    }

    public static Session getWorkflowSession(WorkflowSession workflowSession, WorkItem workItem) throws WorkflowException {
        Session session = workflowSession.getSession();
        if (session == null) {
            throw new WorkflowException("Session is not available for work item " + workItem);
        }
        return session;
    }

    public static Session getUserSession(SlingRepository repository, String userId, WorkflowSession workflowSession) {
        try {
            SimpleCredentials sc = new SimpleCredentials(userId, new char[0]);
            String sessionUserId = workflowSession.getSession().getUserID();
            return repository.impersonateFromService(sessionUserId, (Credentials)sc, null);
        }
        catch (Exception e) {
            LOG.warn("cannot get a JCR session for user {}, message: {}", (Object)userId, (Object)e.getMessage());
            return null;
        }
    }

    public static List<String> getPaths(Session session, ResourceCollectionManager rcManager, WorkflowData data) {
        String type = data.getPayloadType();
        if (!type.equals("JCR_PATH") || data.getPayload() == null) {
            return Collections.emptyList();
        }
        String path = (String)data.getPayload();
        try {
            if (!session.itemExists(path)) {
                return Collections.emptyList();
            }
        }
        catch (RepositoryException e) {
            LOG.warn("Resource {} does not exist, {}", (Object)path, (Object)e);
            return Collections.emptyList();
        }
        List rcCollections = null;
        try {
            rcCollections = rcManager.getCollectionsForNode((Node)session.getItem(path));
        }
        catch (RepositoryException e) {
            LOG.warn("Could load resource {}, {}", (Object)path, (Object)e);
        }
        return ResourceCollectionHelper.getPaths((String)path, (List)rcCollections);
    }
}

