/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process;

import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.RevisionManager;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process.ProcessHelper;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Session;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"process.label=Create Versions (Headless API)"}, service={WorkflowProcess.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class CreateVersionProcess
implements WorkflowProcess {
    private static final Logger LOG = LoggerFactory.getLogger(CreateVersionProcess.class);
    protected static final String METADATA_PN_LAST_PROCESSED_PATH = "createVersionsLastProcessedPath";
    protected static final int MAX_RETRIES = 10;
    @Reference
    public ResourceResolverFactory resolverFactory;
    @Reference
    public ResourceCollectionManager rcManager;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = ProcessHelper.getWorkflowSession(workflowSession, workItem);
            ResourceResolver resolver = this.resolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            WorkflowData data = ProcessHelper.getWorkflowData(workItem);
            MetaDataMap metadata = data.getMetaDataMap();
            HashMap<String, String> revisionMap = new HashMap<String, String>();
            String lastProcessedPath = this.getLastProcessedPath(metadata);
            LOG.debug("Last processed path: {}", (Object)lastProcessedPath);
            List<String> references = ProcessHelper.getMetadataValueAsList(metadata, "collectedReferences");
            List<String> paths = ProcessHelper.getPaths(session, this.rcManager, data);
            paths.addAll(references);
            LOG.debug("All paths: {}", paths);
            Iterator<String> it = ProcessHelper.getPathIteratorStartingWith(paths, lastProcessedPath);
            while (it.hasNext()) {
                String path = it.next();
                this.createRevisionOrRetry(resolver, path, workItem, revisionMap, 0);
                this.updateMetadata(workItem, workflowSession, path);
            }
            LOG.debug("Revision map: {}", revisionMap);
            if (!revisionMap.isEmpty()) {
                JSONObject revisionJs = new JSONObject();
                for (Map.Entry entry : revisionMap.entrySet()) {
                    revisionJs.put((String)entry.getKey(), entry.getValue());
                }
                metadata.put((Object)"versions", (Object)revisionJs.toString());
                if (ProcessHelper.getWorkflowData(workItem).getMetaDataMap().get("absoluteTime", String.class) != null) {
                    Calendar cal = this.getTime(workItem);
                    metadata.put((Object)"comment", (Object)("Activate version " + revisionMap + " on " + cal.getTime()));
                }
                workflowSession.updateWorkflowData(workItem.getWorkflow(), data);
            }
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
    }

    protected void createRevisionOrRetry(ResourceResolver resolver, String path, WorkItem workItem, Map<String, String> revisionMap, int retryIndex) throws WorkflowException {
        Resource res = resolver.getResource(path);
        LOG.debug("Create revision for path {}, retry index {}", (Object)path, (Object)retryIndex);
        if (res == null) {
            LOG.warn("Cannot create version for {}, resource is not found.", (Object)path);
            return;
        }
        String labelHint = this.getAbsTime(workItem);
        try {
            Pair<String, String> revision = RevisionManager.createRevision(resolver, path, labelHint);
            if (Objects.nonNull(revision)) {
                revisionMap.put((String)revision.getLeft(), (String)revision.getRight());
            }
        }
        catch (Exception e) {
            if (retryIndex < 10) {
                resolver.refresh();
                this.createRevisionOrRetry(resolver, path, workItem, revisionMap, retryIndex + 1);
            }
            LOG.warn("Couldn't create the revision for {}, maximum retries exceeded.", (Object)path, (Object)e);
        }
    }

    protected void updateMetadata(WorkItem workItem, WorkflowSession session, String lastProcessedPath) throws WorkflowException {
        MetaDataMap metadata = ProcessHelper.getWorkflowData(workItem).getMetaDataMap();
        metadata.put((Object)METADATA_PN_LAST_PROCESSED_PATH, (Object)lastProcessedPath);
        session.updateWorkflowData(workItem.getWorkflow(), workItem.getWorkflowData());
    }

    private String getLastProcessedPath(MetaDataMap metadata) {
        return (String)metadata.get(METADATA_PN_LAST_PROCESSED_PATH, String.class);
    }

    private String getAbsTime(WorkItem workItem) throws WorkflowException {
        if (ProcessHelper.getWorkflowData(workItem).getMetaDataMap().get("absoluteTime", String.class) != null) {
            Calendar cal = this.getTime(workItem);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
            return "Used for scheduled publication at " + formatter.format(cal.getTime());
        }
        return null;
    }

    private Calendar getTime(WorkItem workItem) throws WorkflowException {
        Long time = (Long)ProcessHelper.getWorkflowData(workItem).getMetaDataMap().get("absoluteTime", Long.class);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal;
    }
}

