/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process;

import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.process.ProcessHelper;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.workflow.collection.ResourceCollectionManager;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.wcm.core.reference.ActivationReferenceSearchService;
import com.day.cq.wcm.core.reference.ReferenceSearchFilter;
import com.day.cq.wcm.core.reference.ReferenceSearchFilterConstants;
import com.day.cq.wcm.core.reference.ReferenceSearchFilterFactory;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"process.label=Collect references (Headless API)"}, service={WorkflowProcess.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class CollectReferencesProcess
implements WorkflowProcess {
    private static final String METADATA_PN_LAST_PROCESSED_PATH = "collectReferencesLastProcessedPath";
    private static final String JSON_KEY_ASSETS = "assets";
    private static final String JSON_KEY_PATH = "path";
    private static final Logger LOG = LoggerFactory.getLogger(CollectReferencesProcess.class);
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SlingRepository repository;
    @Reference
    private ResourceCollectionManager rcManager;
    @Reference
    private ActivationReferenceSearchService activationReferenceSearchService;
    @Reference
    private AgentManager agentManager;
    @Reference
    private ReferenceSearchFilterFactory referenceSearchFilterFactory;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = ProcessHelper.getWorkflowSession(workflowSession, workItem);
            ResourceResolver resolver = this.resolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            WorkflowData data = ProcessHelper.getWorkflowData(workItem);
            MetaDataMap metadata = data.getMetaDataMap();
            String lastProcessedPath = this.getLastProcessedPath(metadata);
            LOG.debug("Last processed path: {}", (Object)lastProcessedPath);
            Set<String> filters = ProcessHelper.getMetadataValueAsSet(workItem, "filterReferencesByStatus");
            List<String> paths = ProcessHelper.getPaths(session, this.rcManager, data);
            List<String> references = ProcessHelper.getMetadataValueAsList(metadata, "collectedReferences");
            Iterator<String> it = ProcessHelper.getPathIteratorStartingWith(paths, lastProcessedPath);
            String agentId = null;
            if (metadata.containsKey((Object)"agentId")) {
                agentId = (String)metadata.get("agentId", String.class);
            }
            Agent agent = ProcessHelper.getAgent(agentId, this.agentManager);
            while (it.hasNext()) {
                String path = it.next();
                if (references.contains(path)) {
                    LOG.debug("Skip collecting the references for path: {}, it's already collected.", (Object)path);
                    continue;
                }
                LOG.debug("Collecting references for path: {}", (Object)path);
                this.collectReferencesForPath(resolver, path, references, filters, agent);
                LOG.debug("IT Collected references: {}", references);
                this.updateMetadata(workItem, workflowSession, references, path);
            }
            LOG.debug("Collected references: {}", references);
        }
        catch (IOException | LoginException | JSONException e) {
            throw new WorkflowException(e);
        }
    }

    private void updateMetadata(WorkItem workItem, WorkflowSession session, List<String> references, String lastProcessedPath) throws WorkflowException {
        String referencesAsString;
        WorkflowData data = ProcessHelper.getWorkflowData(workItem);
        MetaDataMap metadata = data.getMetaDataMap();
        ArrayList<String> uniqueReferences = new ArrayList<String>(new LinkedHashSet<String>(references));
        try {
            referencesAsString = new ObjectMapper().writeValueAsString(uniqueReferences);
        }
        catch (JsonProcessingException e) {
            throw new WorkflowException((Throwable)e);
        }
        metadata.put((Object)"collectedReferences", (Object)referencesAsString);
        metadata.put((Object)METADATA_PN_LAST_PROCESSED_PATH, (Object)lastProcessedPath);
        session.updateWorkflowData(workItem.getWorkflow(), workItem.getWorkflowData());
    }

    private String getLastProcessedPath(MetaDataMap metadata) {
        return (String)metadata.get(METADATA_PN_LAST_PROCESSED_PATH, String.class);
    }

    private void collectReferencesForPath(ResourceResolver resourceResolver, String path, List<String> refPaths, Set<String> filters, Agent agent) throws JSONException {
        String agentId = agent == null ? null : agent.getId();
        ReferenceSearchFilter statusFilter = this.referenceSearchFilterFactory.createFilter(ReferenceSearchFilterConstants.STATUS_FILTER, filters, agentId);
        JSONObject refsJsonObject = this.activationReferenceSearchService.getReferences(resourceResolver, new String[]{path}, statusFilter, agent);
        JSONArray array = refsJsonObject.getJSONArray(JSON_KEY_ASSETS);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject arrayEntry = array.getJSONObject(i);
            String refPath = arrayEntry.getString(JSON_KEY_PATH);
            if (refPaths.contains(refPath)) continue;
            refPaths.add(refPath);
        }
        LOG.trace("For the path {} the following refs have been returned: {}", (Object)path, refPaths);
    }
}

