/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow;

import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.WorkflowContext;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.WorkflowManagerException;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.workflowpackage.WorkflowPackageBuilder;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowManager {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowManager.class);
    private static final String DEFAULT_PACKAGE_TITLE = "generated-package";

    private WorkflowManager() {
    }

    public static Workflow createInstance(ResourceResolver resourceResolver, WorkflowContext ctx) throws WorkflowManagerException, PersistenceException {
        WorkflowSession session = WorkflowManager.getWorkflowSession(resourceResolver);
        WorkflowModel model = WorkflowManager.getWorkflowModel(session, ctx.getModelId());
        WorkflowData data = WorkflowManager.getWorkflowData(session, resourceResolver, ctx.getPaths());
        Workflow workflow = WorkflowManager.startWorkflow(session, model, data, ctx.getMetadata());
        LOG.debug("Managed to create the workflow instance having the id: {}", (Object)workflow.getId());
        return workflow;
    }

    private static WorkflowSession getWorkflowSession(ResourceResolver resResolver) throws WorkflowManagerException {
        WorkflowSession session = (WorkflowSession)resResolver.adaptTo(WorkflowSession.class);
        if (session == null) {
            LOG.error("Unable to obtain the workflow session");
            throw new WorkflowManagerException("Unable to obtain the workflow session");
        }
        return session;
    }

    private static WorkflowModel getWorkflowModel(WorkflowSession session, String id) throws WorkflowManagerException {
        WorkflowModel model;
        try {
            model = session.getModel(id);
        }
        catch (WorkflowException ex) {
            LOG.error("Unknown workflow model with id: {}, cause: {}", (Object)id, (Object)ex.getMessage());
            throw new WorkflowManagerException(String.format("Unknown workflow model with id: {%s}", id));
        }
        if (model == null) {
            LOG.error("Unknown workflow model with id: {}", (Object)id);
            throw new WorkflowManagerException(String.format("Unknown workflow model with id: {%s}", id));
        }
        return model;
    }

    private static WorkflowData getWorkflowData(WorkflowSession session, ResourceResolver resourceResolver, List<String> paths) throws PersistenceException {
        Iterator<Resource> payload = WorkflowManager.pathsToResource(resourceResolver, paths);
        Resource wfPackage = WorkflowManager.createWorkflowPackage(resourceResolver, payload);
        return session.newWorkflowData("JCR_PATH", (Object)wfPackage.getPath());
    }

    private static Iterator<Resource> pathsToResource(ResourceResolver resourceResolver, List<String> paths) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : paths) {
            Resource resource = resourceResolver.getResource(path);
            if (null == resource) {
                LOG.debug("Can't load resource {}", (Object)path);
                continue;
            }
            resources.add(resource);
        }
        return resources.iterator();
    }

    private static Resource createWorkflowPackage(ResourceResolver resourceResolver, Iterator<Resource> payload) throws PersistenceException {
        try {
            WorkflowPackageBuilder packageBuilder = new WorkflowPackageBuilder();
            packageBuilder.setWorkflowPackagesPath("/etc/workflow/packages");
            return packageBuilder.create(resourceResolver, DEFAULT_PACKAGE_TITLE, payload);
        }
        catch (PersistenceException ex) {
            throw new PersistenceException("Can't create package", (Throwable)ex);
        }
    }

    private static Workflow startWorkflow(WorkflowSession session, WorkflowModel model, WorkflowData data, Map<String, Object> metaData) throws WorkflowManagerException {
        try {
            LOG.debug("Starting workflow with modelId: {}, data: {}, metadata: {}", new Object[]{model.getId(), data, metaData});
            return session.startWorkflow(model, data, metaData);
        }
        catch (WorkflowException ex) {
            throw new WorkflowManagerException(String.format("Unable to start workflow with id: {%s}", model.getId()), ex);
        }
    }
}

