/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.workflow;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Revision;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionManager {
    private static final Logger LOG = LoggerFactory.getLogger(RevisionManager.class);

    private RevisionManager() {
    }

    protected static boolean shouldCreateNewVersion(@NotNull Resource resource, @Nullable Calendar lastModified) {
        ReplicationStatus rs = (ReplicationStatus)resource.adaptTo(ReplicationStatus.class);
        if (rs == null) {
            LOG.warn("Unable to adapt resource {} to ReplicationStatus", (Object)resource.getPath());
            return false;
        }
        Calendar lr = rs.getLastPublished();
        return lr == null || lastModified == null || lr.before(lastModified);
    }

    public static boolean shouldCreateNewVersion(@NotNull Asset asset) {
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        if (resource == null) {
            LOG.warn("Unable to adapt asset {} to Resource", (Object)asset.getPath());
            return false;
        }
        Calendar lm = Calendar.getInstance();
        lm.setTimeInMillis(asset.getLastModified());
        return RevisionManager.shouldCreateNewVersion(resource, lm);
    }

    public static boolean shouldCreateNewVersion(@NotNull ContentFragment cf) {
        Asset asset = (Asset)cf.adaptTo(Asset.class);
        if (asset == null) {
            LOG.warn("Unable to adapt Content Fragment to Asset");
            return false;
        }
        return RevisionManager.shouldCreateNewVersion(asset);
    }

    public static boolean shouldCreateNewVersion(@NotNull Page page) {
        Resource resource = (Resource)page.adaptTo(Resource.class);
        if (resource == null) {
            LOG.warn("Unable to adapt Page {} to resource.", (Object)page.getPath());
            return false;
        }
        return RevisionManager.shouldCreateNewVersion(resource, page.getLastModified());
    }

    public static Pair<String, String> createRevision(ResourceResolver resolver, String path, String versionLabelHint) throws Exception {
        Resource res = resolver.getResource(path);
        if (res == null) {
            LOG.warn("Cannot create version of {}, resource is not found.", (Object)path);
            return null;
        }
        Page page = (Page)res.adaptTo(Page.class);
        if (page != null) {
            PageManager pageManager = page.getPageManager();
            LOG.debug("Create version for page: {}", (Object)res.getPath());
            return RevisionManager.createPageVersion(page, pageManager, versionLabelHint);
        }
        Asset asset = (Asset)res.adaptTo(Asset.class);
        if (asset != null) {
            LOG.debug("Create version for asset: {}", (Object)res.getPath());
            return RevisionManager.createAssetVersion(asset, versionLabelHint);
        }
        LOG.warn("Failed to adapt resource {} to a Page or Asset,", (Object)path);
        return null;
    }

    protected static Pair<String, String> createPageVersion(@NotNull Page page, PageManager pageManager, String versionLabelHint) throws WCMException, RepositoryException {
        String versionLabel = RevisionManager.createUniqueVersionLabel(pageManager.getRevisions(page.getPath(), null), versionLabelHint);
        com.day.cq.wcm.api.Revision rev = pageManager.createRevision(page, versionLabel, null);
        return new ImmutablePair((Object)page.getContentResource().getPath(), (Object)rev.getVersion().getName());
    }

    protected static Pair<String, String> createAssetVersion(@NotNull Asset asset, String versionLabelHint) throws Exception {
        String versionLabel = RevisionManager.createUniqueVersionLabel(asset.getRevisions(null), versionLabelHint);
        Revision rev = asset.createRevision(versionLabel, null);
        return new ImmutablePair((Object)asset.getPath(), (Object)rev.getVersion().getName());
    }

    protected static String createUniqueVersionLabel(Collection<?> revisions, String labelHint) throws RepositoryException {
        if (labelHint == null) {
            return null;
        }
        List<Version> versions = RevisionManager.collectVersions(revisions);
        Object versionLabel = labelHint;
        int count = 1;
        boolean idUnique = false;
        block0: while (!idUnique) {
            idUnique = true;
            for (Version v : versions) {
                if (!v.getContainingHistory().hasVersionLabel((String)versionLabel)) continue;
                versionLabel = labelHint + " (" + count + ")";
                ++count;
                idUnique = false;
                continue block0;
            }
        }
        return versionLabel;
    }

    private static List<Version> collectVersions(Collection<?> revisions) {
        LinkedList<Version> versions = new LinkedList<Version>();
        if (Objects.isNull(revisions)) {
            return versions;
        }
        for (Object rev : revisions) {
            Object ver = rev instanceof com.day.cq.wcm.api.Revision ? ((com.day.cq.wcm.api.Revision)rev).getVersion() : (rev instanceof Revision ? ((Revision)rev).getVersion() : null);
            if (null == ver) continue;
            versions.add((Version)ver);
        }
        return versions;
    }
}

