/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferenceElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.TagElement;
import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Variation {
    private String name;
    private String title;
    private String description;
    private List<Element> elements;
    private List<Tag> tags;

    public ContentFragmentVariation convert(boolean fullyHydrated) {
        List<Tag> fieldTags;
        ContentFragmentVariation dto = new ContentFragmentVariation().name(this.getName()).title(this.getTitle()).description(this.getDescription());
        if (this.getTags() != null && !this.getTags().isEmpty()) {
            dto.setTags(this.getTags());
        }
        for (Element element2 : this.getElements()) {
            if (element2 == null) continue;
            dto.addFieldsItem(element2.convert());
        }
        List<BaseReference> referenceDtos = this.getElements().stream().filter(element -> element instanceof ReferenceElement).map(element -> (ReferenceElement)element).flatMap(referenceElement -> referenceElement.getReferences().stream()).filter(Objects::nonNull).map(referencedResource -> referencedResource.convert(fullyHydrated)).collect(Collectors.toList());
        if (!referenceDtos.isEmpty()) {
            dto.setReferences(referenceDtos);
        }
        if (!(fieldTags = this.getElements().stream().filter(element -> element instanceof TagElement).map(element -> (TagElement)element).flatMap(tagElement -> tagElement.getTags().stream()).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            dto.setFieldTags(fieldTags);
        }
        return dto;
    }

    public Set<BaseReference> convertToReferences() {
        Comparator<BaseReference> byName = Comparator.comparing(BaseReference::getName);
        Supplier<TreeSet> references = () -> new TreeSet(byName);
        return this.elements.stream().filter(element -> element instanceof ReferenceElement).map(element -> (ReferenceElement)element).flatMap(referenceElement -> referenceElement.getReferences().stream()).filter(Objects::nonNull).map(referencedResource -> referencedResource.convert(false)).collect(Collectors.toCollection(references));
    }

    public ContentFragmentVariation convert() {
        return this.convert(false);
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

