/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.cq.dam.cfm.openapi.models.TagFragmentField;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TagElement
extends Element {
    private final List<Tag> tags;
    private final boolean multiValue;

    public TagElement(String name, List<Tag> tags, boolean multiValue) {
        super(name);
        this.multiValue = multiValue;
        this.tags = tags;
    }

    @Override
    public ContentFragmentField convert() {
        Set<String> tagIds = this.tags.stream().map(Tag::getId).collect(Collectors.toUnmodifiableSet());
        return new TagFragmentField().values(tagIds).name(this.getName()).multiple(this.multiValue).type(DataType.TAG);
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }
}

