/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.MimeType;
import com.adobe.cq.dam.cfm.openapi.models.TextFragmentField;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringElement
extends Element {
    private static final Logger log = LoggerFactory.getLogger(StringElement.class);
    private final List<String> values;
    private final boolean multiValue;
    private final boolean multiLine;
    private final String contentType;

    public StringElement(String name, List<String> values, boolean multiValue, boolean multiLine, String contentType) {
        super(name);
        this.values = values;
        this.multiValue = multiValue;
        this.multiLine = multiLine;
        this.contentType = contentType;
    }

    @Override
    public ContentFragmentField convert() {
        if (this.multiLine) {
            return new LongTextFragmentField().mimeType(this.getMimeType()).values(this.values).name(this.getName()).multiple(this.multiValue).type(DataType.LONG_TEXT);
        }
        return new TextFragmentField().values(this.values).name(this.getName()).multiple(this.multiValue).type(DataType.TEXT);
    }

    private MimeType getMimeType() {
        if (this.contentType == null) {
            return null;
        }
        try {
            return MimeType.fromString(this.contentType);
        }
        catch (IllegalArgumentException e) {
            log.warn("Unknown content type: {}", (Object)this.contentType);
            return null;
        }
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public String getContentType() {
        return this.contentType;
    }
}

