/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.FragmentConverter;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.SchemaConverter;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferenceElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedResource;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class ReferencedFragment
extends ReferencedResource {
    private final String description;
    private final ContentFragmentModel model;
    private final UUID id;
    private final List<Element> elements;
    private final List<Variation> variations;
    private final List<Tag> tags;

    public ReferencedFragment(Fragment fragment) {
        this.id = fragment.getId();
        this.description = fragment.getDescription();
        this.model = fragment.getModel();
        this.elements = fragment.getElements();
        this.variations = fragment.getVariations();
        this.tags = fragment.getTags();
        this.setCreated(fragment.getCreated());
        this.setModified(fragment.getModified());
        this.setPublished(fragment.getPublished());
        this.setStatus(fragment.getStatus());
        this.setPreviewStatus(fragment.getPreviewStatus());
        this.setName(fragment.getName());
        this.setTitle(fragment.getTitle());
        this.setPath(fragment.getPath());
    }

    @Override
    public BaseReference convert(boolean fullyHydrated) {
        ContentFragmentReference contentFragmentReference = new ContentFragmentReference();
        if (fullyHydrated) {
            contentFragmentReference.description(this.description);
            for (Element element2 : this.elements) {
                if (element2 == null) continue;
                contentFragmentReference.addFieldsItem(element2.convert());
            }
            contentFragmentReference.tags(this.tags);
            List<ContentFragmentVariation> variationDtos = this.variations == null ? List.of() : this.variations.stream().map(variation -> variation.convert(true)).collect(Collectors.toUnmodifiableList());
            contentFragmentReference.setVariations(variationDtos);
        }
        contentFragmentReference.id(this.id).model(FragmentConverter.convertModel(this.getModel())).created(SchemaConverter.convert(this.getCreated(), AuthoringInfo.class)).modified(SchemaConverter.convert(this.getModified(), AuthoringInfo.class)).published(SchemaConverter.convert(this.getPublished(), AuthoringInfo.class)).status(FragmentConverter.convertStatus(this.getStatus())).previewStatus(FragmentConverter.convertPreviewStatus(this.getPreviewStatus())).name(this.getName()).title(this.getTitle()).fieldName(this.getFieldName()).type(BaseReference.TypeEnum.CONTENT_FRAGMENT).path(this.getPath());
        if (this.elements != null) {
            List<BaseReference> references = this.elements.stream().filter(element -> element instanceof ReferenceElement).map(element -> (ReferenceElement)element).flatMap(referenceElement -> referenceElement.getReferences().stream()).filter(Objects::nonNull).map(referencedResource -> referencedResource.convert(fullyHydrated)).collect(Collectors.toList());
            contentFragmentReference.setReferences(references);
        }
        return contentFragmentReference;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentFragmentModel getModel() {
        return this.model;
    }

    public UUID getId() {
        return this.id;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<Variation> getVariations() {
        return this.variations;
    }

    public List<Tag> getTags() {
        return this.tags;
    }
}

