/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedResource;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentReferenceFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.FragmentReferenceFragmentField;
import java.util.List;
import java.util.Set;

public class ReferenceElement
extends Element {
    private final Set<ReferencedResource> references;
    private final List<String> paths;
    private final boolean multiValue;
    private final String semanticType;

    public ReferenceElement(String name, String semanticType, List<String> paths, Set<ReferencedResource> references, boolean multiValue) {
        super(name);
        this.semanticType = semanticType;
        this.references = references;
        this.paths = paths;
        this.multiValue = multiValue;
    }

    @Override
    public ContentFragmentField convert() {
        if ("content-fragment".equals(this.semanticType)) {
            return new FragmentReferenceFragmentField().values(this.paths).name(this.getName()).multiple(this.multiValue).type(DataType.CONTENT_FRAGMENT);
        }
        if ("reference".equals(this.semanticType)) {
            return new ContentReferenceFragmentField().values(this.paths).name(this.getName()).multiple(this.multiValue).type(DataType.CONTENT_REFERENCE);
        }
        return new FragmentReferenceFragmentField();
    }

    public Set<ReferencedResource> getReferences() {
        return this.references;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    public String getSemanticType() {
        return this.semanticType;
    }
}

