/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.backend.FragmentConverter;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.SchemaConverter;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.GenericResource;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferenceElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.TagElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.openapi.models.AuthoringInfo;
import com.adobe.cq.dam.cfm.openapi.models.BaseReference;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.cq.dam.cfm.tags.TagsHelper;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fragment
extends GenericResource {
    private static final Logger log = LoggerFactory.getLogger(Fragment.class);
    private ContentFragment contentFragment;
    private String description;
    private ContentFragmentModel model;
    private UUID id;
    private List<Element> elements;
    private List<Variation> variations;
    private List<Tag> tags = List.of();

    public com.adobe.cq.dam.cfm.openapi.models.ContentFragment convert() {
        return this.convert(false);
    }

    public com.adobe.cq.dam.cfm.openapi.models.ContentFragment convert(boolean fullyHydrated) {
        List<Tag> fieldTags;
        List<BaseReference> referenceDtos;
        Resource resource;
        List<ContentFragmentVariation> variationDtos = this.getVariations() == null ? List.of() : this.getVariations().stream().map(variation -> variation.convert(fullyHydrated)).collect(Collectors.toUnmodifiableList());
        com.adobe.cq.dam.cfm.openapi.models.ContentFragment dto = new com.adobe.cq.dam.cfm.openapi.models.ContentFragment().id(this.getId()).path(this.getPath()).description(this.getDescription()).title(this.getTitle()).status(FragmentConverter.convertStatus(this.getStatus())).previewStatus(FragmentConverter.convertPreviewStatus(this.getPreviewStatus())).model(FragmentConverter.convertModel(this.getModel())).variations(variationDtos).created(SchemaConverter.convert(this.getCreated(), AuthoringInfo.class)).modified(SchemaConverter.convert(this.getModified(), AuthoringInfo.class)).published(SchemaConverter.convert(this.getPublished(), AuthoringInfo.class));
        for (Element element2 : this.getElements()) {
            if (element2 == null) continue;
            dto.addFieldsItem(element2.convert());
        }
        TagManager tagManager = null;
        if (this.contentFragment != null && (resource = (Resource)this.contentFragment.adaptTo(Resource.class)) != null) {
            tagManager = (TagManager)resource.getResourceResolver().adaptTo(TagManager.class);
        }
        if (this.getTags() != null && !this.getTags().isEmpty() && tagManager != null) {
            String[] tagIds = (String[])this.getTags().stream().map(Tag::getId).toArray(String[]::new);
            dto.setTags(this.getTags(tagManager, tagIds));
        }
        if (!(referenceDtos = this.getElements().stream().filter(element -> element instanceof ReferenceElement).map(element -> (ReferenceElement)element).flatMap(referenceElement -> referenceElement.getReferences().stream()).filter(Objects::nonNull).map(referencedResource -> referencedResource.convert(fullyHydrated)).collect(Collectors.toList())).isEmpty()) {
            dto.setReferences(referenceDtos);
        }
        if (!(fieldTags = this.getElements().stream().filter(element -> element instanceof TagElement).map(element -> (TagElement)element).flatMap(tagElement -> tagElement.getTags().stream()).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            dto.setFieldTags(fieldTags);
        }
        return dto;
    }

    private List<Tag> getTags(TagManager tagManager, String[] tagIds) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (String tag : tagIds) {
            com.day.cq.tagging.Tag currentTag = tagManager.resolve(tag);
            if (currentTag == null) continue;
            tags.add(new Tag().id(currentTag.getTagID()).title(currentTag.getTitle()).titlePath(currentTag.getTitlePath()).path(currentTag.getPath()).name(currentTag.getName()).i18n(TagsHelper.getTagI18nList(currentTag)).description(currentTag.getDescription()));
        }
        return tags;
    }

    public Set<BaseReference> convertToReferences() {
        Comparator<BaseReference> byName = Comparator.comparing(BaseReference::getName);
        Supplier<TreeSet> references = () -> new TreeSet(byName);
        return this.elements.stream().filter(element -> element instanceof ReferenceElement).map(element -> (ReferenceElement)element).flatMap(referenceElement -> referenceElement.getReferences().stream()).filter(Objects::nonNull).map(referencedResource -> referencedResource.convert(false)).collect(Collectors.toCollection(references));
    }

    public Optional<Variation> getVariationByName(String variationName) {
        return this.variations.stream().filter(variation -> variation.getName().equals(variationName)).findFirst();
    }

    public void deleteVariation(String variationName) throws ContentFragmentException {
        this.contentFragment.removeVariation(variationName);
    }

    public ContentFragment getContentFragment() {
        return this.contentFragment;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentFragmentModel getModel() {
        return this.model;
    }

    public UUID getId() {
        return this.id;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public List<Variation> getVariations() {
        return this.variations;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setContentFragment(ContentFragment contentFragment) {
        this.contentFragment = contentFragment;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModel(ContentFragmentModel model) {
        this.model = model;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }
}

