/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment;

import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.DateFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.DateTimeFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TimeFragmentField;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.List;

public class CalendarElement
extends Element {
    private final OffsetDateTime offsetDateTime;
    private final String semanticType;

    public CalendarElement(String name, Calendar calendar, String semanticType) {
        super(name);
        this.offsetDateTime = Utils.convertCalendarToOffsetDateTime(calendar);
        this.semanticType = semanticType;
    }

    @Override
    public ContentFragmentField convert() {
        switch (this.semanticType) {
            case "date": {
                return new DateFragmentField().values(this.getDate()).name(this.getName()).type(DataType.DATE);
            }
            case "time": {
                return new TimeFragmentField().values(this.getTime()).name(this.getName()).type(DataType.TIME);
            }
            case "datetime": {
                return new DateTimeFragmentField().values(this.getDateTime()).name(this.getName()).type(DataType.DATE_TIME);
            }
        }
        throw new IllegalArgumentException("Unsupported semantic type: " + this.semanticType);
    }

    public List<LocalDate> getDate() {
        return this.offsetDateTime == null ? List.of() : List.of(this.offsetDateTime.toLocalDate());
    }

    public List<OffsetDateTime> getDateTime() {
        return this.offsetDateTime == null ? List.of() : List.of(this.offsetDateTime);
    }

    public List<LocalTime> getTime() {
        return this.offsetDateTime == null ? List.of() : List.of(this.offsetDateTime.toLocalTime());
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.offsetDateTime;
    }

    public String getSemanticType() {
        return this.semanticType;
    }
}

