/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fieldserializers;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.DataType;
import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.AssetReferenceSerializerImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.ExperienceFragmentReferenceSerializerImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.PageReferenceSerializerImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fieldserializers.FieldSerializerContext;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.BooleanElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.CalendarElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.DoubleElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.EnumerationElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.JsonElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.LongElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferenceElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedFragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedResource;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.StringElement;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.TagElement;
import com.adobe.cq.xf.ExperienceFragment;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.dam.api.Asset;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FieldSerializer.class})
public class FieldSerializer {
    private static final Logger log = LoggerFactory.getLogger(FieldSerializer.class);
    public static final String CT_PLAINTEXT = "text/plain";
    @Reference
    private ToggleRouter toggleRouter;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile FragmentSerializer fragmentSerializer;
    private final AssetReferenceSerializerImpl assetReferenceSerializer = new AssetReferenceSerializerImpl();
    private final PageReferenceSerializerImpl pageReferenceSerializer = new PageReferenceSerializerImpl();
    private final ExperienceFragmentReferenceSerializerImpl xfReferenceSerializer = new ExperienceFragmentReferenceSerializerImpl();

    public Optional<Element> transform(FieldSerializerContext context, ResourceResolver resourceResolver) {
        return this.transform(context, resourceResolver, 0);
    }

    public Optional<Element> transform(FieldSerializerContext context, ResourceResolver resourceResolver, int depth) {
        boolean multiValue = context.isMultiValue();
        String valueType = context.getValueType();
        String semanticType = context.getSemanticType();
        String name = context.getName();
        Object value = context.getValue();
        if ("tag".equals(semanticType)) {
            return Optional.of(this.transformTag(name, value, multiValue, resourceResolver));
        }
        if ("json".equals(semanticType)) {
            return Optional.of(new JsonElement(name, (String)value));
        }
        if ("content-fragment".equals(semanticType) || "reference".equals(semanticType)) {
            return Optional.of(this.transformReference(name, semanticType, value, multiValue, resourceResolver, depth));
        }
        if ("enum".equals(semanticType)) {
            return Optional.of(this.transformEnum(name, value, multiValue));
        }
        if (valueType.equals("boolean")) {
            return Optional.of(new BooleanElement(name, (Boolean)value));
        }
        if (valueType.equals("long")) {
            return Optional.of(this.transformLong(name, value, multiValue));
        }
        if (valueType.equals("double")) {
            return Optional.of(this.transformDouble(name, value, multiValue));
        }
        if (valueType.equals("calendar")) {
            return Optional.of(new CalendarElement(name, (Calendar)value, semanticType));
        }
        if (valueType.equals("string")) {
            String contentType = this.toggleRouter != null && this.toggleRouter.isEnabled("FT_SITES-9388") ? context.getContentType() : (context.getContentType() == null ? CT_PLAINTEXT : context.getContentType());
            boolean multiLine = "multiline".equals(semanticType);
            return Optional.of(this.transformString(name, value, multiValue, multiLine, multiLine ? contentType : null));
        }
        return Optional.empty();
    }

    public List<com.adobe.cq.dam.cfm.openapi.models.Tag> getTags(List<String> tagIds, ResourceResolver resourceResolver) {
        if (tagIds == null || tagIds.isEmpty()) {
            return List.of();
        }
        TagManager tagManager = (TagManager)resourceResolver.adaptTo(TagManager.class);
        return tagIds.stream().map(tagId -> {
            if (tagManager == null) {
                return new com.adobe.cq.dam.cfm.openapi.models.Tag().id((String)tagId);
            }
            Tag tag = tagManager.resolve(tagId);
            if (tag == null) {
                return new com.adobe.cq.dam.cfm.openapi.models.Tag().id((String)tagId);
            }
            return new com.adobe.cq.dam.cfm.openapi.models.Tag().id(tag.getTagID()).name(tag.getName()).title(tag.getTitle()).path(tag.getPath()).description(tag.getDescription()).titlePath(tag.getTitlePath());
        }).collect(Collectors.toUnmodifiableList());
    }

    private Element transformLong(String name, Object value, boolean multiValue) {
        if (value == null) {
            return new LongElement(name, List.of(), multiValue);
        }
        return multiValue ? new LongElement(name, Arrays.asList((Long[])value), true) : new LongElement(name, List.of((Long)value), false);
    }

    private Element transformDouble(String name, Object value, boolean multiValue) {
        if (value == null) {
            return new DoubleElement(name, List.of(), multiValue);
        }
        return multiValue ? new DoubleElement(name, Arrays.asList((Double[])value), true) : new DoubleElement(name, List.of((Double)value), false);
    }

    private Element transformString(String name, Object value, boolean multiValue, boolean multiLine, String contentType) {
        if (value == null) {
            return new StringElement(name, List.of(), multiValue, multiLine, contentType);
        }
        return multiValue ? new StringElement(name, Arrays.asList((String[])value), true, multiLine, contentType) : new StringElement(name, List.of((String)value), false, multiLine, contentType);
    }

    private Element transformTag(String name, Object value, boolean multiValue, ResourceResolver resourceResolver) {
        if (value == null) {
            return new TagElement(name, Collections.emptyList(), multiValue);
        }
        List<String> tagIds = null;
        if (value instanceof String) {
            tagIds = List.of(value.toString());
        } else if (value instanceof String[]) {
            tagIds = Arrays.stream((String[])value).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        } else {
            log.warn("Unexpected value type for tag element: {}", (Object)value.getClass().getName());
        }
        List<com.adobe.cq.dam.cfm.openapi.models.Tag> tags = this.getTags(tagIds, resourceResolver);
        return new TagElement(name, tags, multiValue);
    }

    private Element transformReference(String name, String semanticType, Object value, boolean multiValue, ResourceResolver resourceResolver, int depth) {
        if (value == null) {
            return new ReferenceElement(name, semanticType, List.of(), Set.of(), multiValue);
        }
        List<String> referencePaths = multiValue ? Arrays.stream((String[])value).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList()) : List.of(value.toString());
        HashSet<ReferencedResource> references = new HashSet<ReferencedResource>();
        ArrayList<String> paths = new ArrayList<String>();
        for (String path : referencePaths) {
            ReferencedResource referencedResource = this.getTransformedResource(path, resourceResolver, depth);
            if (referencedResource == null) {
                paths.add(path);
                references.add(null);
                continue;
            }
            referencedResource.setFieldName(name);
            paths.add(path);
            references.add(referencedResource);
        }
        return new ReferenceElement(name, semanticType, paths, references, multiValue);
    }

    @Nullable
    public ReferencedResource getTransformedResource(String path, ResourceResolver resourceResolver, int depth) {
        if (resourceResolver == null) {
            return null;
        }
        Resource referencedResource = resourceResolver.getResource(path);
        if (referencedResource == null) {
            return null;
        }
        return this.transformResource(referencedResource, depth);
    }

    private ReferencedResource transformResource(Resource resource, int depth) {
        if (depth == 0) {
            return null;
        }
        ContentFragment cf = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (cf != null) {
            return new ReferencedFragment((Fragment)this.fragmentSerializer.transform(cf, --depth));
        }
        Asset asset = (Asset)resource.adaptTo(Asset.class);
        if (asset != null) {
            return this.assetReferenceSerializer.transform(asset, 0);
        }
        ExperienceFragment xf = (ExperienceFragment)resource.adaptTo(ExperienceFragment.class);
        if (xf != null) {
            return this.xfReferenceSerializer.transform(xf, 0);
        }
        Page page = (Page)resource.adaptTo(Page.class);
        if (page != null) {
            return this.pageReferenceSerializer.transform(page, 0);
        }
        return null;
    }

    private Element transformEnum(String name, Object value, boolean multiValue) {
        if (value == null) {
            return new EnumerationElement(name, Set.of(), multiValue);
        }
        return multiValue ? new EnumerationElement(name, new LinkedHashSet<String>(List.of((String[])value)), true) : new EnumerationElement(name, Set.of((String)value), false);
    }

    public List<Element> getFields(ContentFragment contentFragment, Function<ContentElement, FragmentData> fragmentDataFunction, ResourceResolver resourceResolver, int depth) {
        ArrayList<Element> fields = new ArrayList<Element>();
        if (contentFragment == null) {
            return fields;
        }
        Iterator elements = contentFragment.getElements();
        elements.forEachRemaining(el -> {
            Optional<Element> optionalElement;
            Object multiple;
            Map metadata;
            ElementTemplate elementTemplate;
            FragmentData elData = (FragmentData)fragmentDataFunction.apply((ContentElement)el);
            if (elData == null) {
                return;
            }
            if ("tab".equals(elData.getDataType().getSemanticType())) {
                return;
            }
            Object metaType = ((Resource)contentFragment.getTemplate().getForElement(el).adaptTo(Resource.class)).getValueMap().get((Object)"metaType");
            DataType dataType = elData.getDataType();
            String semanticType = metaType.equals("enumeration") ? "enum" : dataType.getSemanticType();
            FieldSerializerContext context = FieldSerializerContext.builder().name(el.getName()).value(elData.getValue()).valueType(dataType.getValueType()).semanticType(semanticType).multiValue(dataType.isMultiValue()).contentType(el.getContentType()).build();
            if ("tag".equals(elData.getDataType().getSemanticType()) && (elementTemplate = contentFragment.getTemplate().getForElement(el)) != null && (metadata = elementTemplate.getMetaData()).containsKey("allowMultipleTags") && (multiple = metadata.get("allowMultipleTags")) instanceof Boolean) {
                context.setMultiValue(Boolean.TRUE.equals(multiple));
            }
            if ((optionalElement = this.transform(context, resourceResolver, depth)).isEmpty()) {
                log.warn("Cannot transform element with name={}", (Object)el.getName());
            } else {
                fields.add(optionalElement.get());
            }
        });
        return fields;
    }
}

