/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TypedSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fieldserializers.FieldSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Element;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Metadata;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={VariationSerializerImpl.class})
public class VariationSerializerImpl
implements TypedSerializer<Pair<ContentFragment, VariationDef>, Variation> {
    private static final Logger log = LoggerFactory.getLogger(VariationSerializerImpl.class);
    @Reference
    private ToggleRouter toggleRouter;
    @Reference
    private FieldSerializer fieldSerializer;
    @Reference
    private JsonDataProcessor jsonDataProcessor;

    @Override
    public Variation transform(@NotNull Pair<ContentFragment, VariationDef> variationData, int depth) {
        ContentFragment contentFragment = (ContentFragment)variationData.getLeft();
        Resource resource = (Resource)contentFragment.adaptTo(Resource.class);
        if (resource == null) {
            return new Variation();
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        if (!this.toggleRouter.isEnabled("FT_SITES-16027") & depth > 1) {
            depth = 1;
        }
        Variation variation = this.getVariation(contentFragment, (VariationDef)variationData.getRight(), resourceResolver, depth);
        this.setVariationTags(contentFragment, variation, resourceResolver);
        return variation;
    }

    private Variation getVariation(ContentFragment contentFragment, VariationDef variationDef, ResourceResolver resourceResolver, int depth) {
        Variation variation = new Variation();
        if (variationDef.getName() != null) {
            variation.setName(variationDef.getName());
        }
        if (variationDef.getTitle() != null) {
            variation.setTitle(variationDef.getTitle());
        }
        if (variationDef.getDescription() != null) {
            variation.setDescription(variationDef.getDescription());
        }
        Function<ContentElement, FragmentData> fragmentDataFunction = VariationSerializerImpl.getVariationDataFunction(variationDef.getName());
        List<Element> elements = this.fieldSerializer.getFields(contentFragment, fragmentDataFunction, resourceResolver, depth);
        variation.setElements(elements);
        return variation;
    }

    private static Function<ContentElement, FragmentData> getVariationDataFunction(String variationName) {
        return el -> {
            ContentVariation contentVariation = el.getVariation(variationName);
            if (contentVariation == null) {
                log.warn("Cannot obtain a content variationName={}", (Object)variationName);
                return null;
            }
            return contentVariation.getValue();
        };
    }

    private void setVariationTags(ContentFragment contentFragment, Variation variation, ResourceResolver resourceResolver) {
        try {
            Optional<Metadata> metaData = Optional.of(this.jsonDataProcessor.convertValue(contentFragment.getMetaData(), Metadata.class));
            List<Tag> tags = this.fieldSerializer.getTags(metaData.get().getVariationTags(variation.getName()), resourceResolver);
            variation.setTags(tags);
        }
        catch (Exception ex) {
            log.error("Cannot convert to metadata", (Throwable)ex);
        }
    }
}

