/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.day.cq.replication.ReplicationActionType;
import java.time.OffsetDateTime;
import java.util.Calendar;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeAuthorInformation {
    private OffsetDateTime at;
    private String by;

    @Nullable
    public static TimeAuthorInformation created(@NotNull ValueMap map) {
        return map.containsKey((Object)"jcr:createdBy") ? new TimeAuthorInformation(Utils.convertCalendarToOffsetDateTime((Calendar)map.get("jcr:created", Calendar.class)), (String)map.get("jcr:createdBy", String.class)) : null;
    }

    @Nullable
    public static TimeAuthorInformation modified(@NotNull ValueMap map) {
        return map.containsKey((Object)"cq:lastModifiedBy") ? new TimeAuthorInformation(Utils.convertCalendarToOffsetDateTime((Calendar)map.get("cq:lastModified", Calendar.class)), (String)map.get("cq:lastModifiedBy", String.class)) : null;
    }

    @Nullable
    public static TimeAuthorInformation published(@NotNull ValueMap map) {
        if (ReplicationActionType.ACTIVATE.getName().equalsIgnoreCase((String)map.get("cq:lastReplicationAction", String.class))) {
            return map.containsKey((Object)"cq:lastReplicatedBy") ? new TimeAuthorInformation(Utils.convertCalendarToOffsetDateTime((Calendar)map.get("cq:lastReplicated", Calendar.class)), (String)map.get("cq:lastReplicatedBy", String.class)) : null;
        }
        return null;
    }

    public OffsetDateTime getAt() {
        return this.at;
    }

    public String getBy() {
        return this.by;
    }

    public TimeAuthorInformation(OffsetDateTime at, String by) {
        this.at = at;
        this.by = by;
    }

    public void setAt(OffsetDateTime at) {
        this.at = at;
    }

    public void setBy(String by) {
        this.by = by;
    }
}

