/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.ElementTemplate;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.headless.backend.Field;
import com.adobe.cq.dam.cfm.headless.backend.ModelSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.FieldMapper;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.ModelFieldMapper;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ModelSerializer.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ModelSerializerImpl
implements ModelSerializer {
    public static final String META_TYPE = "metaType";
    public static final String FIELD_LABEL = "fieldLabel";
    public static final String FIELD_VALUE = "fieldValue";
    public static final String OPTIONS = "options";
    public static final String GRANITE_DATA = "granite:data";
    public static final String OPTIONSMULTIFIELD = "optionsmultifield";
    public static final String MULTIVALUE = "multivalue";
    public static final String VALUE_TYPE = "valueType";
    @Reference
    private ToggleRouter toggleRouter;

    @Override
    public List<Field> transform(FragmentTemplate contentFragment) {
        ArrayList<Field> fields = new ArrayList<Field>();
        contentFragment.getElements().forEachRemaining(elementTemplate -> {
            Resource elementTemplateResource = (Resource)elementTemplate.adaptTo(Resource.class);
            if (elementTemplateResource != null) {
                Map<String, Object> elementValueMap = this.transformFragmentResource(elementTemplateResource, (ElementTemplate)elementTemplate);
                String metaType = (String)elementValueMap.get(META_TYPE);
                if (metaType == null) {
                    return;
                }
                FieldMapper serializer = ModelFieldMapper.getSerializer((String)elementValueMap.get(META_TYPE));
                Field wrappedValueMap = (Field)serializer.apply(elementValueMap);
                fields.add(wrappedValueMap);
            }
        });
        return fields;
    }

    Map<String, Object> transformFragmentResource(Resource resource, ElementTemplate elementTemplate) {
        Map<String, Object> mergedValueMap = this.transformRsc(resource);
        Resource graniteNode = resource.getChild(GRANITE_DATA);
        if (graniteNode != null) {
            mergedValueMap.putAll(this.transformRsc(graniteNode));
        }
        Resource optionsmultifield = resource.getChild(OPTIONSMULTIFIELD);
        String enumOptions = (String)resource.getValueMap().get((Object)OPTIONS);
        List<Object> options = new ArrayList();
        if (optionsmultifield != null) {
            for (Resource item : optionsmultifield.getChildren()) {
                Map<String, Object> option2 = this.transformRsc(item);
                options.add(Map.of(FIELD_LABEL, option2.get(FIELD_LABEL), FIELD_VALUE, option2.get(FIELD_VALUE)));
            }
            mergedValueMap.put(OPTIONS, options);
        } else if (enumOptions != null) {
            options = Arrays.stream(enumOptions.split(",")).map(String::trim).map(option -> Map.of(FIELD_LABEL, option, FIELD_VALUE, option)).collect(Collectors.toList());
            mergedValueMap.put(OPTIONS, options);
        }
        mergedValueMap.put(MULTIVALUE, elementTemplate.getDataType().isMultiValue());
        mergedValueMap.put(VALUE_TYPE, elementTemplate.getDataType().getValueType());
        if (this.toggleRouter.isEnabled("FT_SITES-11210")) {
            mergedValueMap.put("resourceResolver", resource.getResourceResolver());
            mergedValueMap.put("toggleRouter", this.toggleRouter);
        }
        return mergedValueMap;
    }

    private Map<String, Object> transformRsc(Resource resource) {
        return resource.getValueMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

