/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.FieldMapper;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.BooleanField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.ContentFragmentReferenceField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.ContentReferenceField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.DateTimeField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.DefaultField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.EnumerationField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.NumberField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.TagsField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.TextMultiField;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.representation.TextSingleField;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.RangeIterator;
import com.day.cq.tagging.TagManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;

class ModelFieldMapper {
    public static final String VALUE = "value";
    public static final String ROOT_PATH = "rootPath";
    private static final String CONF_ROOT = "/conf";
    private static final FieldMapper booleanFieldMapper = valueMap -> {
        BooleanField.BooleanFieldBuilder builder = BooleanField.builder();
        return ((BooleanField.BooleanFieldBuilder)((BooleanField.BooleanFieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setEmptyText(null)).setFieldLabel((String)valueMap.get("text"))).setValue((Boolean)valueMap.get("checked")).setCustomErrorMsg((String)valueMap.get("customErrorMsg")).build();
    };
    private static final FieldMapper textFieldMapper = valueMap -> {
        TextSingleField.TextSingleFieldBuilder builder = TextSingleField.builder();
        String validation = (String)valueMap.get("validation");
        if (validation != null && validation.equals("None")) {
            validation = null;
        }
        if (validation != null) {
            String[] validationText = validation.split("\\.");
            validation = validationText[validationText.length - 1];
        }
        if ("custom".equals(validation)) {
            validation = "regexp";
        }
        String unique = (String)valueMap.get("unique");
        return ModelFieldMapper.buildCommonProperties(builder, valueMap).setMaxLength(Integer.parseInt(valueMap.getOrDefault("maxlength", "-1"))).setValue((String)valueMap.get(VALUE)).setValidation(validation).setValidationRegex((String)valueMap.get("validationRegex")).setUnique(unique == null ? null : Boolean.valueOf("true".equals(unique))).setCustomErrorMsg((String)valueMap.get("customErrorMsg")).build();
    };
    private static final FieldMapper textMultiFieldMapper = valueMap -> {
        TextMultiField.TextMultiFieldBuilder builder = TextMultiField.builder();
        Object fragmentModelReference = valueMap.get("fragmentmodelreference");
        List<String> allowedModels = ModelFieldMapper.extractAllowedModels(fragmentModelReference);
        return ((TextMultiField.TextMultiFieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setFieldLabel((String)valueMap.get("cfm-element"))).setAllowedModels(allowedModels).setDefaultMimeType((String)valueMap.get("default-mime-type")).build();
    };
    private static final FieldMapper numberFieldMapper = valueMap -> {
        NumberField.NumberFieldBuilder builder = NumberField.builder();
        String numberMax = (String)valueMap.get("number-max");
        String numberMin = (String)valueMap.get("number-min");
        String value = (String)valueMap.get(VALUE);
        return ModelFieldMapper.buildCommonProperties(builder, valueMap).setNumberMax(numberMax == null ? null : Integer.valueOf(Integer.parseInt(numberMax))).setNumberMin(numberMin == null ? null : Integer.valueOf(Integer.parseInt(numberMin))).setValue(value == null ? null : Double.valueOf(Double.parseDouble(value))).build();
    };
    private static final FieldMapper dateTimeMapper = valueMap -> {
        DateTimeField.DateTimeFieldBuilder builder = DateTimeField.builder();
        Calendar date = (Calendar)valueMap.get(VALUE);
        String isoDate = null;
        if (date != null) {
            isoDate = Utils.getDateOrTimeLocalized(date, (String)valueMap.get("type"));
        }
        return ((DateTimeField.DateTimeFieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setValueType((String)valueMap.get("type"))).setValue(isoDate).build();
    };
    private static final FieldMapper jsonFieldMapper = valueMap -> {
        DefaultField.FieldBuilder builder = DefaultField.builder();
        return ((DefaultField.FieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setFieldLabel((String)valueMap.get("cfm-element"))).build();
    };
    private static final FieldMapper contentFragmentReferenceFieldMapper = valueMap -> {
        ContentFragmentReferenceField.ContentFragmentReferenceFieldBuilder builder = ContentFragmentReferenceField.builder();
        String mvmaxitems = (String)valueMap.get("mvmaxitems");
        String required = (String)valueMap.get("required");
        Object fragmentModelReference = valueMap.get("fragmentmodelreference");
        List<String> allowedModels = ModelFieldMapper.extractAllowedModels(fragmentModelReference);
        ToggleRouter toggleRouter = (ToggleRouter)valueMap.get("toggleRouter");
        if (toggleRouter != null && toggleRouter.isEnabled("FT_SITES-11210")) {
            Object fragmentModelReferenceByTag = valueMap.get("fragmentmodelreferencebytag");
            if (allowedModels == null) {
                allowedModels = new ArrayList<String>();
            }
            allowedModels.addAll(ModelFieldMapper.getModelsByTag(fragmentModelReferenceByTag, valueMap.get("resourceResolver")));
        }
        return ((ContentFragmentReferenceField.ContentFragmentReferenceFieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setRequired(required == null ? null : Boolean.valueOf("on".equals(required)))).setValue((String)valueMap.get(VALUE)).setRootPath((String)valueMap.get(ROOT_PATH)).setAllowNew((Boolean)valueMap.get("allowNew")).setMaxSize(mvmaxitems == null ? null : Integer.valueOf(Integer.parseInt(mvmaxitems))).setAllowedModels(allowedModels).build();
    };
    private static final FieldMapper enumerationFieldMapper = valueMap -> {
        EnumerationField.EnumerationFieldBuilder builder = EnumerationField.builder();
        List enumerationOptions = (List)valueMap.get("options");
        List<EnumerationField.Option> options = null;
        if (enumerationOptions != null) {
            options = enumerationOptions.stream().map(elem -> new EnumerationField.Option((String)elem.get("fieldLabel"), (String)elem.get("fieldValue"))).collect(Collectors.toList());
        }
        String resourceType = (String)valueMap.get("sling:resourceType");
        String renderAs = null;
        if (resourceType != null) {
            if (resourceType.endsWith("multicheckbox")) {
                renderAs = "checkbox";
            } else if (resourceType.endsWith("radiogroup")) {
                renderAs = "radio";
            } else if (resourceType.endsWith("select")) {
                renderAs = "select";
            }
        }
        String unique = (String)valueMap.get("unique");
        return ModelFieldMapper.buildCommonProperties(builder, valueMap).setOptions(options).setEmptyOption((Boolean)valueMap.get("emptyOption")).setRenderAs(renderAs).setUnique(unique == null ? null : Boolean.valueOf("true".equals(unique))).build();
    };
    private static final FieldMapper tagsFieldMapper = valueMap -> {
        TagsField.TagsFieldBuilder builder = TagsField.builder();
        return ((TagsField.TagsFieldBuilder)ModelFieldMapper.buildCommonProperties(builder, valueMap).setRootPath((String)valueMap.get(ROOT_PATH)).setAllowMultiple("true".equals(valueMap.get("multiple"))).setMultifield(Boolean.FALSE)).build();
    };
    private static final FieldMapper contentReferenceFieldMapper = valueMap -> {
        String[] acceptedTypes;
        ContentReferenceField.ContentReferenceFieldBuilder builder = ContentReferenceField.builder();
        String showThumbnail = (String)valueMap.get("showThumbnail");
        String filesizeMin = (String)valueMap.get("filesize-min");
        String filesizeMax = (String)valueMap.get("filesize-max");
        String imageHeightMax = (String)valueMap.get("imageheight-max");
        String imageHeightMin = (String)valueMap.get("imageheight-min");
        String imageWidthMax = (String)valueMap.get("imagewidth-max");
        String imageWidthMin = (String)valueMap.get("imagewidth-min");
        Object validation = valueMap.get("validation");
        String mvmaxitems = (String)valueMap.get("mvmaxitems");
        if (validation != null && !validation.getClass().isArray()) {
            validation = new String[]{(String)validation};
        }
        if ((acceptedTypes = (String[])validation) != null) {
            acceptedTypes = (String[])Arrays.stream(acceptedTypes).filter(Objects::nonNull).map(val -> {
                String[] validationText = val.split("\\.");
                return validationText[validationText.length - 1];
            }).toArray(String[]::new);
        }
        return ModelFieldMapper.buildCommonProperties(builder, valueMap).setShowThumbnail(showThumbnail == null ? null : Boolean.valueOf("true".equals(showThumbnail))).setFilesizeMin(filesizeMin == null ? null : Double.valueOf(Double.parseDouble(filesizeMin))).setFilesizeMax(filesizeMax == null ? null : Double.valueOf(Double.parseDouble(filesizeMax))).setFilesizeMinUnit((String)valueMap.get("filesize-minunit")).setFilesizeMaxUnit((String)valueMap.get("filesize-maxunit")).setImageHeightMax(imageHeightMax == null ? null : Double.valueOf(Double.parseDouble(imageHeightMax))).setImageHeightMin(imageHeightMin == null ? null : Double.valueOf(Double.parseDouble(imageHeightMin))).setImageWidthMax(imageWidthMax == null ? null : Double.valueOf(Double.parseDouble(imageWidthMax))).setImageWidthMin(imageWidthMin == null ? null : Double.valueOf(Double.parseDouble(imageWidthMin))).setMaxSize(mvmaxitems == null ? null : Integer.valueOf(Integer.parseInt(mvmaxitems))).setRootPath((String)valueMap.get(ROOT_PATH)).setAcceptedTypes(acceptedTypes).build();
    };
    private static final FieldMapper fallbackFieldMapper = valueMap -> {
        DefaultField.FieldBuilder builder = DefaultField.builder();
        return ModelFieldMapper.buildCommonProperties(builder, valueMap).build();
    };
    static Map<String, FieldMapper> fieldMapping = Map.ofEntries(Map.entry("boolean", booleanFieldMapper), Map.entry("text-single", textFieldMapper), Map.entry("text-multi", textMultiFieldMapper), Map.entry("number", numberFieldMapper), Map.entry("date", dateTimeMapper), Map.entry("tags", tagsFieldMapper), Map.entry("json", jsonFieldMapper), Map.entry("enumeration", enumerationFieldMapper), Map.entry("fragment-reference", contentFragmentReferenceFieldMapper), Map.entry("reference", contentReferenceFieldMapper), Map.entry("fallback", fallbackFieldMapper));

    private ModelFieldMapper() {
    }

    static FieldMapper getSerializer(@NotNull String mapping) {
        if (fieldMapping.containsKey(mapping)) {
            return fieldMapping.get(mapping);
        }
        return fieldMapping.get("fallback");
    }

    static <T extends DefaultField.FieldBuilder> T buildCommonProperties(T builder, Map<String, Object> valueMap) {
        String listOrder = (String)valueMap.get("listOrder");
        Integer listOrderInt = null;
        if (listOrder != null) {
            listOrderInt = Integer.parseInt(listOrder);
        }
        String required = (String)valueMap.get("required");
        Boolean requiredBool = null;
        if (required != null) {
            requiredBool = "true".equals(required) || "on".equals(required);
        }
        Object valueObject = valueMap.get("emptyText");
        String emptyText = null;
        if (valueObject instanceof String) {
            emptyText = (String)valueObject;
        } else if (valueObject instanceof String[]) {
            String[] values = (String[])valueObject;
            emptyText = values.length > 0 ? values[0] : null;
        }
        return ((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)((DefaultField.FieldBuilder)builder.setEmptyText(emptyText)).setFieldLabel((String)valueMap.get("fieldLabel"))).setFieldDescription((String)valueMap.get("fieldDescription"))).setListOrder(listOrderInt)).setMetaType((String)valueMap.get("metaType"))).setName((String)valueMap.get("name"))).setRequired(requiredBool)).setValueType((String)valueMap.get("valueType"))).setMultifield((Boolean)valueMap.get("multivalue"));
    }

    private static List<String> extractAllowedModels(Object fragmentModelReference) {
        List<Object> allowedModels = null;
        if (fragmentModelReference != null) {
            if (fragmentModelReference instanceof String) {
                allowedModels = Arrays.stream(((String)fragmentModelReference).split(",")).map(String::trim).collect(Collectors.toList());
            } else if (fragmentModelReference instanceof String[]) {
                allowedModels = Lists.newArrayList((Object[])((String[])fragmentModelReference));
            }
        }
        return allowedModels;
    }

    public static List<String> getModelsByTag(Object tags, Object resourceResolver) {
        ArrayList<String> allowedModels = new ArrayList<String>();
        if (tags != null && resourceResolver != null) {
            ArrayList<String> modelsByTag = new ArrayList<String>();
            TagManager tagManager = (TagManager)((ResourceResolver)resourceResolver).adaptTo(TagManager.class);
            if (tagManager != null) {
                RangeIterator rangeIterator = tagManager.find(CONF_ROOT, (String[])tags, true);
                while (rangeIterator != null && rangeIterator.hasNext()) {
                    Resource modelResource = (Resource)rangeIterator.next();
                    if (StringUtils.endsWith((CharSequence)modelResource.getPath(), (CharSequence)"jcr:content")) {
                        modelResource = modelResource.getParent();
                    }
                    if (modelResource == null) continue;
                    modelsByTag.add(modelResource.getPath());
                }
            }
            allowedModels.addAll(modelsByTag);
        }
        return allowedModels;
    }
}

