/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.JsonDataProcessor;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.Metrics;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.VariationSerializerImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fieldserializers.FieldSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Metadata;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.impl.persistence.legacy.Converter;
import com.adobe.cq.dam.cfm.openapi.models.Tag;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.metrics.MetricsService;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FragmentSerializer.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentSerializerImpl
implements FragmentSerializer {
    private static final Logger log = LoggerFactory.getLogger(FragmentSerializerImpl.class);
    private final int maxReferenceRetrievalDepth;
    public static final String SEMANTIC_DATA_TYPE_TAB = "tab";
    private static final String METRIC_LIST = "ContentFragmentSerializer";
    private final FieldSerializer fieldSerializer;
    private final VariationSerializerImpl variationSerializer;
    private final MetricsService metrics;
    private final ToggleRouter toggleRouter;
    private final JsonDataProcessor jsonDataProcessor;
    private final Converter converter;

    @Override
    public int getMaxReferenceRetrievalDepth() {
        return this.maxReferenceRetrievalDepth;
    }

    @Activate
    public FragmentSerializerImpl(Configuration configuration, @Reference MetricsService metricsService, @Reference ToggleRouter toggleRouter, @Reference JsonDataProcessor jsonDataProcessor, @Reference Converter converter, @Reference FieldSerializer fieldSerializer, @Reference VariationSerializerImpl variationSerializer) {
        this.maxReferenceRetrievalDepth = configuration.maxReferenceRetrievalDepth();
        this.metrics = metricsService;
        this.toggleRouter = toggleRouter;
        this.jsonDataProcessor = jsonDataProcessor;
        this.converter = converter;
        this.fieldSerializer = fieldSerializer;
        this.variationSerializer = variationSerializer;
    }

    private Optional<Metadata> createMetadataInformation(ContentFragment contentFragment) {
        try {
            return Optional.of(this.jsonDataProcessor.convertValue(contentFragment.getMetaData(), Metadata.class));
        }
        catch (Exception ex) {
            log.error("Cannot convert to metadata", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    public Fragment transform(@NotNull ContentFragment contentFragment, int depth) {
        if (depth > this.maxReferenceRetrievalDepth) {
            log.warn("Requested depth {} is higher than maximum allowed depth of {} for reference retrieval. Maximum depth will be enforced.", (Object)depth, (Object)this.maxReferenceRetrievalDepth);
            depth = this.maxReferenceRetrievalDepth;
        }
        long start = System.currentTimeMillis();
        Fragment fragment = new Fragment();
        fragment.setContentFragment(contentFragment);
        fragment.setName(contentFragment.getName());
        fragment.setTitle(contentFragment.getTitle());
        fragment.setDescription(contentFragment.getDescription());
        fragment.setModel(this.converter.convert(contentFragment.getTemplate()));
        Resource resource = (Resource)contentFragment.adaptTo(Resource.class);
        if (resource == null) {
            return fragment;
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Optional<Metadata> optionalMetadata = this.createMetadataInformation(contentFragment);
        optionalMetadata.ifPresent(metadata -> {
            List<Tag> tags = this.fieldSerializer.getTags(metadata.getTags(), resourceResolver);
            fragment.setTags(tags);
        });
        fragment.setPath(resource.getPath());
        String uuidStr = (String)resource.getValueMap().get("jcr:uuid", String.class);
        if (uuidStr != null) {
            fragment.setId(UUID.fromString(uuidStr));
        }
        fragment.setCreated(Utils.getCreatedInfo(resource.getValueMap()));
        Utils.setModifiedPublishedStatus(resource, fragment);
        if (this.toggleRouter.isEnabled("ft-sites-125")) {
            Utils.setPreviewStatus(resource, fragment);
        }
        ArrayList<Variation> variations = new ArrayList<Variation>();
        fragment.setElements(this.fieldSerializer.getFields(contentFragment, ContentElement::getValue, resourceResolver, depth));
        int variationDepth = depth;
        contentFragment.listAllVariations().forEachRemaining(variationDef -> {
            Variation variation = this.variationSerializer.transform((Pair<ContentFragment, VariationDef>)Pair.of((Object)contentFragment, (Object)variationDef), variationDepth);
            variations.add(variation);
        });
        fragment.setVariations(variations);
        Metrics.duration(this.metrics, start, "ContentFragmentSerializer.transform");
        return fragment;
    }

    public static @interface Configuration {
        public int maxReferenceRetrievalDepth() default 5;
    }
}

