/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.serializer;

import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TypedSerializer;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedAsset;
import com.day.cq.dam.api.Asset;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;

public class AssetReferenceSerializerImpl
implements TypedSerializer<Asset, ReferencedAsset> {
    private static final String URN_AAID_AEM = "urn:aaid:aem:";
    private static final String JCR_CONTENT = "jcr:content";

    @Override
    public ReferencedAsset transform(@NotNull Asset asset, int depth) {
        ReferencedAsset referencedAsset = new ReferencedAsset();
        referencedAsset.setName(asset.getName());
        referencedAsset.setTitle(asset.getMetadataValue("dc:title"));
        referencedAsset.setMimeType(asset.getMimeType());
        referencedAsset.setSize(asset.getMetadata().getOrDefault("dam:size", null));
        referencedAsset.setWidth(asset.getMetadata().getOrDefault("tiff:ImageWidth", null));
        referencedAsset.setHeight(asset.getMetadata().getOrDefault("tiff:ImageLength", null));
        referencedAsset.setPath(asset.getPath());
        referencedAsset.setAssetId(URN_AAID_AEM + asset.getID());
        Resource resource = (Resource)asset.adaptTo(Resource.class);
        if (resource != null) {
            Utils.setStatus(resource, referencedAsset);
            referencedAsset.setCreated(Utils.getCreatedInfo(resource.getValueMap()));
            referencedAsset.setModified(Utils.getModifiedInfo(resource.getChild(JCR_CONTENT).getValueMap()));
        }
        return referencedAsset;
    }
}

