/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.search;

import com.adobe.cq.dam.cfm.headless.backend.FragmentFilter;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.search.SearchFilterImpl;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentSearchFilter;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentSearchModel;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentSearchConverters {
    private static final Logger log = LoggerFactory.getLogger(FragmentSearchConverters.class);

    private FragmentSearchConverters() {
    }

    public static FragmentFilter convertFragmentSearchFilter(ContentFragmentSearchModel searchModel) {
        ContentFragmentSearchFilter searchFilter = searchModel.getFilter();
        return SearchFilterImpl.builder().fullTextSearch(FragmentSearchConverters.getFilterFullTextSearch(searchFilter)).model(FragmentSearchConverters.getFilterModel(searchFilter)).createdBy(FragmentSearchConverters.getFilterCreatedBy(searchFilter)).modifiedBy(FragmentSearchConverters.getFilterModifiedBy(searchFilter)).modifiedOrCreatedBy(FragmentSearchConverters.getFilterModifiedOrCreatedBy(searchFilter)).publishedBy(FragmentSearchConverters.getFilterPublishedBy(searchFilter)).tags(FragmentSearchConverters.getFilterTags(searchFilter)).path(FragmentSearchConverters.getFilterPath(searchFilter)).createdAfter(FragmentSearchConverters.getFilterCreatedAfter(searchFilter)).modifiedOrCreatedAfter(FragmentSearchConverters.getFilterModifiedOrCreatedAfter(searchFilter)).modifiedAfter(FragmentSearchConverters.getFilterModifiedAfter(searchFilter)).publishedAfter(FragmentSearchConverters.getFilterPublishedAfter(searchFilter)).createdBefore(FragmentSearchConverters.getFilterCreatedBefore(searchFilter)).modifiedOrCreatedBefore(FragmentSearchConverters.getFilterModifiedOrCreatedBefore(searchFilter)).modifiedBefore(FragmentSearchConverters.getFilterModifiedBefore(searchFilter)).publishedBefore(FragmentSearchConverters.getFilterPublishedBefore(searchFilter)).status(FragmentSearchConverters.getStatus(searchFilter)).build();
    }

    @Nullable
    private static Calendar getFilterPublishedBefore(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getPublish() != null && searchFilter.getPublish().getBefore() != null && Utils.convertDateTime(searchFilter.getPublish().getBefore()) != null ? Utils.convertDateTime(searchFilter.getPublish().getBefore()) : null;
    }

    @Nullable
    private static Calendar getFilterModifiedBefore(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModified() != null && searchFilter.getModified().getBefore() != null && Utils.convertDateTime(searchFilter.getModified().getBefore()) != null ? Utils.convertDateTime(searchFilter.getModified().getBefore()) : null;
    }

    @Nullable
    private static Calendar getFilterModifiedOrCreatedBefore(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModifiedOrCreated() != null && searchFilter.getModifiedOrCreated().getBefore() != null && Utils.convertDateTime(searchFilter.getModifiedOrCreated().getBefore()) != null ? Utils.convertDateTime(searchFilter.getModifiedOrCreated().getBefore()) : null;
    }

    @Nullable
    private static Calendar getFilterCreatedBefore(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getCreated() != null && searchFilter.getCreated().getBefore() != null && Utils.convertDateTime(searchFilter.getCreated().getBefore()) != null ? Utils.convertDateTime(searchFilter.getCreated().getBefore()) : null;
    }

    @Nullable
    private static Calendar getFilterPublishedAfter(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getPublish() != null && searchFilter.getPublish().getAfter() != null && Utils.convertDateTime(searchFilter.getPublish().getAfter()) != null ? Utils.convertDateTime(searchFilter.getPublish().getAfter()) : null;
    }

    @Nullable
    private static Calendar getFilterModifiedAfter(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModified() != null && searchFilter.getModified().getAfter() != null && Utils.convertDateTime(searchFilter.getModified().getAfter()) != null ? Utils.convertDateTime(searchFilter.getModified().getAfter()) : null;
    }

    @Nullable
    private static Calendar getFilterModifiedOrCreatedAfter(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModifiedOrCreated() != null && searchFilter.getModifiedOrCreated().getAfter() != null && Utils.convertDateTime(searchFilter.getModifiedOrCreated().getAfter()) != null ? Utils.convertDateTime(searchFilter.getModifiedOrCreated().getAfter()) : null;
    }

    @Nullable
    private static Calendar getFilterCreatedAfter(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getCreated() != null && searchFilter.getCreated().getAfter() != null && Utils.convertDateTime(searchFilter.getCreated().getAfter()) != null ? Utils.convertDateTime(searchFilter.getCreated().getAfter()) : null;
    }

    @Nullable
    private static String getFilterPath(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getPath() != null ? searchFilter.getPath() : null;
    }

    @NotNull
    private static Set<String> getFilterTags(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getTags() != null ? new HashSet<String>(searchFilter.getTags()) : new HashSet();
    }

    private static Set<StatusInfo> getStatus(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getStatus() != null ? (Set)searchFilter.getStatus().stream().map(Utils::convertStatus).collect(Collectors.toCollection(HashSet::new)) : new HashSet<StatusInfo>();
    }

    @NotNull
    private static Set<String> getFilterPublishedBy(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getPublish() != null && searchFilter.getPublish().getBy() != null ? new HashSet<String>(searchFilter.getPublish().getBy()) : new HashSet<String>();
    }

    @NotNull
    private static Set<String> getFilterModifiedOrCreatedBy(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModifiedOrCreated() != null && searchFilter.getModifiedOrCreated().getBy() != null ? new HashSet<String>(searchFilter.getModifiedOrCreated().getBy()) : new HashSet<String>();
    }

    @NotNull
    private static Set<String> getFilterModifiedBy(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModified() != null && searchFilter.getModified().getBy() != null ? new HashSet<String>(searchFilter.getModified().getBy()) : new HashSet<String>();
    }

    @NotNull
    private static Set<String> getFilterCreatedBy(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getCreated() != null && searchFilter.getCreated().getBy() != null ? new HashSet<String>(searchFilter.getCreated().getBy()) : new HashSet<String>();
    }

    @NotNull
    private static Set<String> getFilterModel(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getModelIds() != null ? (Set)searchFilter.getModelIds().stream().map(Base64URLHelper::toPath).collect(Collectors.toCollection(HashSet::new)) : new HashSet<String>();
    }

    @Nullable
    private static String getFilterFullTextSearch(ContentFragmentSearchFilter searchFilter) {
        return searchFilter.getFullText() != null && !searchFilter.getFullText().getText().isEmpty() ? searchFilter.getFullText().getText() : null;
    }
}

