/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.search;

import com.adobe.aem.openapi.pagination.Cursor;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.backend.FragmentListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryMode;
import com.adobe.cq.dam.cfm.headless.backend.impl.search.ContentFragmentSearchService;
import com.adobe.cq.dam.cfm.headless.backend.impl.search.FragmentSearchConverters;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.FragmentSorting;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.graphql.PagingImpl;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentListResult;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentSearchModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentSearchSortInner;
import com.adobe.cq.dam.cfm.openapi.models.FullTextSearchCriteria;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ContentFragmentSearchService.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-11206)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ContentFragmentSearchServiceImpl
implements ContentFragmentSearchService {
    private static final Logger log = LoggerFactory.getLogger(ContentFragmentSearchServiceImpl.class);
    @Reference
    private FragmentListGenerator fragmentListGenerator;
    @Reference
    private FragmentService fragmentService;

    @Override
    @NotNull
    public ContentFragmentListResult search(@NotNull ResourceResolver resolver, @NotNull ContentFragmentSearchModel searchModel, @Nullable String startAfter, int limit) throws ContentFragmentException {
        org.apache.sling.graphql.api.pagination.Cursor gqlCursor = null;
        if (startAfter != null) {
            String rawCursorValue = Cursor.decode((String)startAfter);
            if (rawCursorValue == null) {
                throw new ContentFragmentException("Invalid cursor value: " + startAfter);
            }
            gqlCursor = new org.apache.sling.graphql.api.pagination.Cursor(rawCursorValue);
        }
        PagingImpl paging = new PagingImpl(gqlCursor, limit);
        List<ContentFragmentSearchSortInner> sortingCriteria = searchModel.getSort();
        String sorting = sortingCriteria != null ? sortingCriteria.stream().map(sortCriteria -> sortCriteria.getOn().value() + " " + sortCriteria.getOrder()).collect(Collectors.joining(",")) : "";
        new FragmentSorting(sorting).toPaging(paging);
        Optional<FullTextSearchCriteria.QueryModeEnum> queryMode = this.getQueryMode(searchModel);
        Iterator<Map<String, Object>> searchResultIt = this.fragmentListGenerator.getList(resolver, FragmentSearchConverters.convertFragmentSearchFilter(searchModel), paging, queryMode.isPresent() ? Utils.convertQueryMode(queryMode.get()) : FullTextQueryMode.AS_IS);
        searchResultIt = PagingImpl.ensureCursorAvailable(searchResultIt, paging, gqlCursor != null ? gqlCursor.getEncoded() : null);
        return this.buildPage(resolver, searchResultIt, limit, gqlCursor, paging.getCursorProvider());
    }

    ContentFragmentListResult buildPage(ResourceResolver resolver, Iterator<Map<String, Object>> searchResultIt, int limit, org.apache.sling.graphql.api.pagination.Cursor startAfter, Function<Map<String, Object>, String> cursorStringProvider) throws ContentFragmentException {
        ArrayList<ContentFragment> fragments = new ArrayList<ContentFragment>();
        String endCursor = null;
        boolean currentNodeIsInRange = false;
        int itemsToAdd = limit;
        while (itemsToAdd > 0 && searchResultIt.hasNext()) {
            Map<String, Object> node = searchResultIt.next();
            boolean nodeShouldBeAddedToResult = false;
            if (currentNodeIsInRange) {
                nodeShouldBeAddedToResult = true;
            } else {
                currentNodeIsInRange = this.computeIfCurrentNodeIsInRange(startAfter, node, cursorStringProvider);
                boolean bl = nodeShouldBeAddedToResult = startAfter == null;
            }
            if (!nodeShouldBeAddedToResult) continue;
            ContentFragment fragment = this.getFragment(node, resolver);
            if (fragment != null) {
                fragments.add(fragment);
            }
            if (--itemsToAdd != 0 || !searchResultIt.hasNext()) continue;
            endCursor = cursorStringProvider.apply(node);
        }
        if (!currentNodeIsInRange && limit > 0 && startAfter != null) {
            throw new ContentFragmentException("Start cursor not found in supplied data:" + startAfter);
        }
        ContentFragmentListResult full = new ContentFragmentListResult();
        full.setItems(fragments);
        if (StringUtils.isNotEmpty(endCursor)) {
            full.setCursor(new Cursor(endCursor).toString());
        }
        return full;
    }

    private boolean computeIfCurrentNodeIsInRange(org.apache.sling.graphql.api.pagination.Cursor startAfter, Map<String, Object> node, Function<Map<String, Object>, String> cursorStringProvider) {
        if (startAfter == null) {
            return true;
        }
        String rawCursor = cursorStringProvider.apply(node);
        return startAfter.getRawValue().equals(rawCursor);
    }

    private ContentFragment getFragment(Map<String, Object> node, ResourceResolver resolver) {
        String path;
        Resource resource;
        if (node.containsKey("path") && (resource = resolver.getResource(path = node.get("path").toString())) != null) {
            try {
                return this.fragmentService.getFragment(resource).convert();
            }
            catch (ContentFragmentException ex) {
                log.info("Content Fragment at path: {} could not be retrieved. ", (Object)resource.getPath());
            }
        }
        return null;
    }

    Optional<FullTextSearchCriteria.QueryModeEnum> getQueryMode(ContentFragmentSearchModel searchModel) {
        return Optional.ofNullable(searchModel.getFilter().getFullText()).flatMap(fullText -> Optional.ofNullable(fullText.getQueryMode()));
    }
}

