/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.references;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.extensions.ContentFragmentReferenceResolver;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencesSearchService {
    private static final Logger LOG = LoggerFactory.getLogger(ReferencesSearchService.class);
    private final ContentFragmentReferenceResolver contentFragmentReferenceResolver;
    private final ResourceResolver resourceResolver;
    private ReferenceSearch referenceSearch;

    public ReferencesSearchService(ResourceResolver resourceResolver, ContentFragmentReferenceResolver contentFragmentReferenceResolver, ReferenceSearch referenceSearch) {
        this.contentFragmentReferenceResolver = contentFragmentReferenceResolver;
        this.resourceResolver = resourceResolver;
        this.referenceSearch = referenceSearch;
    }

    public Iterator<Page> searchPages(String path, String searchRoot, int limit, int offset) {
        this.referenceSearch.setHollow(false);
        if (!StringUtils.isEmpty((CharSequence)searchRoot)) {
            this.referenceSearch.setSearchRoot(searchRoot);
        }
        List pages = this.referenceSearch.findPageReferencesForResource(this.resourceResolver, path, limit, offset);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} Pages as parent references: {}", (Object)pages.size(), (Object)pages);
        }
        return pages.iterator();
    }

    public Iterator<Page> searchPages(String path, String searchRoot) {
        this.referenceSearch.setHollow(false);
        if (!StringUtils.isEmpty((CharSequence)searchRoot)) {
            this.referenceSearch.setSearchRoot(searchRoot);
        }
        Map result = this.referenceSearch.search(this.resourceResolver, path);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Map.Entry entry : result.entrySet()) {
            if (((ReferenceSearch.Info)entry.getValue()).getPage() != null && ((ReferenceSearch.Info)entry.getValue()).getPage().getPath().equals(path)) continue;
            pages.add(((ReferenceSearch.Info)entry.getValue()).getPage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} Pages as parent references: {}", (Object)pages.size(), pages);
        }
        return pages.iterator();
    }

    public Iterator<ContentFragment> searchContentFragments(String path) {
        Map result = this.contentFragmentReferenceResolver.getReferences(path, this.resourceResolver);
        ArrayList<ContentFragment> contentFragments = new ArrayList<ContentFragment>();
        for (String key : result.keySet()) {
            Resource resource = this.resourceResolver.getResource(key);
            if (resource == null || resource.getPath().equals(path)) {
                LOG.warn("Resource is not a valid reference for {}", (Object)key);
                continue;
            }
            ContentFragment cf = (ContentFragment)resource.adaptTo(ContentFragment.class);
            if (cf != null) {
                contentFragments.add(cf);
                continue;
            }
            LOG.warn("Couldn't adapt resource {} to content fragment", (Object)resource.getPath());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} Content Fragments as parent references: {}", (Object)contentFragments.size(), contentFragments);
        }
        return contentFragments.iterator();
    }
}

