/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.permissions;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.Permission;
import com.adobe.granite.security.authorization.AuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrivilegeCollection;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFragmentPermissions {
    private static final Logger LOG = LoggerFactory.getLogger(ContentFragmentPermissions.class);
    private static final String WORKFLOW_MODELS_PATH = "/var/workflow/models";
    private static final String REP_WRITE = "rep:write";
    private static final String RT_SLING_FOLDER = "sling:Folder";
    private static final String NT_FOLDER = "nt:folder";
    private static final String RT_SLING_ORDERED_FOLDER = "sling:OrderedFolder";

    private ContentFragmentPermissions() {
    }

    public static boolean isAdmin(AuthorizationService authorizationService, Session session) {
        return null != authorizationService && authorizationService.hasAdministrativeAccess(session);
    }

    public static List<Permission> getAllowedPermissions(JackrabbitSession session, JackrabbitAccessControlManager jAcMgr, Resource resource, List<Permission> preferredPermissions, AuthorizationService authorizationService, Map<String, PrivilegeCollection> cache) {
        boolean isAdmin = ContentFragmentPermissions.isAdmin(authorizationService, (Session)session);
        List<Permission> permissions = ContentFragmentPermissions.getPermissions(resource, preferredPermissions);
        if (isAdmin) {
            return permissions;
        }
        ArrayList<Permission> allowedPermissions = new ArrayList<Permission>();
        for (Permission permission : permissions) {
            boolean hasAccess = ContentFragmentPermissions.isContentFragment(resource) ? ContentFragmentPermissions.hasAccessOnContentFragment(session, jAcMgr, resource, permission, cache) : (ContentFragmentPermissions.isFolder(resource) ? ContentFragmentPermissions.hasAccessOnFolder(jAcMgr, resource, permission, cache) : false);
            if (!hasAccess) continue;
            allowedPermissions.add(permission);
        }
        return allowedPermissions;
    }

    private static boolean hasAccessOnContentFragment(JackrabbitSession session, JackrabbitAccessControlManager jAcMgr, Resource resource, Permission permission, Map<String, PrivilegeCollection> cache) {
        if (permission.equals((Object)Permission.READ)) {
            return ContentFragmentPermissions.canRead(jAcMgr, resource, cache);
        }
        if (permission.equals((Object)Permission.EDIT)) {
            return ContentFragmentPermissions.canEdit(jAcMgr, resource, cache);
        }
        if (permission.equals((Object)Permission.DELETE)) {
            return ContentFragmentPermissions.canDelete(jAcMgr, resource, cache);
        }
        if (permission.equals((Object)Permission.RENAME)) {
            return ContentFragmentPermissions.canRename(jAcMgr, resource, cache);
        }
        if (permission.equals((Object)Permission.PUBLISH)) {
            return ContentFragmentPermissions.canReplicate(session, jAcMgr, resource, cache);
        }
        return false;
    }

    private static boolean hasAccessOnFolder(JackrabbitAccessControlManager jAcMgr, Resource resource, Permission permission, Map<String, PrivilegeCollection> cache) {
        if (permission.equals((Object)Permission.CREATE_CONTENT_FRAGMENT)) {
            return ContentFragmentPermissions.canCreateContentFragment(jAcMgr, resource, cache);
        }
        return false;
    }

    private static boolean canRead(JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection pCollection = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, resource.getPath(), cache);
        String[] requiredPrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}read"};
        return ContentFragmentPermissions.hasPrivileges(pCollection, requiredPrivileges);
    }

    private static boolean canEdit(JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection pCollection = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, resource.getPath(), cache);
        String[] requiredPrivileges = new String[]{REP_WRITE, "{http://www.jcp.org/jcr/1.0}versionManagement"};
        return ContentFragmentPermissions.hasPrivileges(pCollection, requiredPrivileges);
    }

    private static boolean canDelete(JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection pCollection = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, resource.getPath(), cache);
        String[] requiredPrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}removeNode"};
        if (!ContentFragmentPermissions.hasPrivileges(pCollection, requiredPrivileges)) {
            return false;
        }
        Resource parent = resource.getParent();
        if (null == parent) {
            return false;
        }
        PrivilegeCollection pCollectionOnParent = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, parent.getPath(), cache);
        String[] requiredPrivilegesOnParent = new String[]{"{http://www.jcp.org/jcr/1.0}removeChildNodes"};
        return ContentFragmentPermissions.hasPrivileges(pCollectionOnParent, requiredPrivilegesOnParent);
    }

    private static boolean canRename(JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection pCollection = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, resource.getPath(), cache);
        String[] requiredPrivileges = new String[]{"{http://www.jcp.org/jcr/1.0}read", "{http://www.jcp.org/jcr/1.0}removeNode"};
        if (!ContentFragmentPermissions.hasPrivileges(pCollection, requiredPrivileges)) {
            return false;
        }
        Resource parent = resource.getParent();
        if (null == parent) {
            return false;
        }
        PrivilegeCollection pCollectionOnParent = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, parent.getPath(), cache);
        String[] requiredPrivilegesOnParent = new String[]{"{http://www.jcp.org/jcr/1.0}addChildNodes", "{http://www.jcp.org/jcr/1.0}removeChildNodes"};
        return ContentFragmentPermissions.hasPrivileges(pCollectionOnParent, requiredPrivilegesOnParent);
    }

    private static boolean canReplicate(JackrabbitSession session, JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection pCollection = ContentFragmentPermissions.getPrivilegeCollection(jAcMgr, resource.getPath(), cache);
        String[] requiredPrivileges = new String[]{"{http://www.day.com/crx/1.0}replicate"};
        if (!ContentFragmentPermissions.hasPrivileges(pCollection, requiredPrivileges)) {
            return false;
        }
        try {
            return session.itemExists(WORKFLOW_MODELS_PATH);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private static boolean canCreateContentFragment(JackrabbitAccessControlManager jAcMgr, Resource resource, Map<String, PrivilegeCollection> cache) {
        return ContentFragmentPermissions.canEdit(jAcMgr, resource, cache);
    }

    private static List<Permission> getPermissions(Resource resource, List<Permission> preferredPermissions) {
        List<Permission> allowedPermissions;
        if (ContentFragmentPermissions.isContentFragment(resource)) {
            allowedPermissions = List.of(Permission.READ, Permission.EDIT, Permission.DELETE, Permission.RENAME, Permission.PUBLISH);
        } else if (ContentFragmentPermissions.isFolder(resource)) {
            allowedPermissions = List.of(Permission.CREATE_CONTENT_FRAGMENT);
        } else {
            return Collections.emptyList();
        }
        if (null == preferredPermissions || preferredPermissions.isEmpty()) {
            return allowedPermissions;
        }
        return allowedPermissions.stream().distinct().filter(preferredPermissions::contains).collect(Collectors.toList());
    }

    private static PrivilegeCollection getPrivilegeCollection(JackrabbitAccessControlManager jAcMgr, String path, Map<String, PrivilegeCollection> cache) {
        PrivilegeCollection collection;
        if (cache.containsKey(path)) {
            return cache.get(path);
        }
        try {
            collection = jAcMgr.getPrivilegeCollection(path);
        }
        catch (RepositoryException e) {
            LOG.warn("Unable to retrieve the privilege collection for path: {}, {}", (Object)path, (Object)e);
            collection = null;
        }
        cache.put(path, collection);
        return collection;
    }

    private static boolean hasPrivileges(PrivilegeCollection pCollection, String[] privileges) {
        try {
            return null != pCollection && null != privileges && pCollection.includes(privileges);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private static boolean isContentFragment(Resource resource) {
        return null != resource && null != resource.adaptTo(ContentFragment.class);
    }

    private static boolean isFolder(Resource resource) {
        if (null == resource) {
            return false;
        }
        return resource.isResourceType(RT_SLING_FOLDER) || resource.isResourceType(RT_SLING_ORDERED_FOLDER) || resource.isResourceType(NT_FOLDER);
    }
}

