/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.operations;

import com.adobe.cq.dam.cfm.headless.backend.impl.operations.AbstractOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Action;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Status;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.status.WorkflowStatus;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledOperation
extends AbstractOperation {
    private static final String WORKFLOW_ROOT = "/var/workflow/models";
    protected static final String SCHEDULED_ACTIVATION_WITH_REFERENCES_WORKFLOW_ID_VAR = "/var/workflow/models/scheduled_activation_with_references";
    protected static final String SCHEDULED_TREE_ACTIVATION_WORKFLOW_ID_VAR = "/var/workflow/models/scheduled_tree_activation";
    protected static final String SCHEDULED_TREE_DEACTIVATION_WORKFLOW_ID_VAR = "/var/workflow/models/scheduled_tree_deactivation";
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledOperation.class);
    private String scheduledBy;
    private String scheduledDate;

    private ScheduledOperation() {
    }

    public static ScheduledOperation getOperation(Resource resource) {
        long startTime = System.currentTimeMillis();
        WorkflowStatus workflowStatus = (WorkflowStatus)resource.adaptTo(WorkflowStatus.class);
        if (workflowStatus == null) {
            return null;
        }
        List<Workflow> scheduledWorkflows = ScheduledOperation.getScheduledWorkflows(workflowStatus);
        if (scheduledWorkflows.isEmpty()) {
            return null;
        }
        ScheduledOperation op = new ScheduledOperation();
        Workflow workflow = scheduledWorkflows.get(0);
        if (workflow == null) {
            return null;
        }
        LOG.debug("Scheduled Workflow found {} ", (Object)workflow.getId());
        Action action = ScheduledOperation.isScheduledActivationWorkflow(workflow) ? Action.PUBLISH : Action.UNPUBLISH;
        op.setAction(action);
        op.setScheduledBy(workflow.getInitiator());
        Long absoluteTime = ScheduledOperation.getScheduledTime(workflow);
        String scheduledDate = ScheduledOperation.formatTime(absoluteTime);
        op.setScheduledDate(scheduledDate);
        Status status = ScheduledOperation.isScheduled(absoluteTime) ? Status.SCHEDULED : Status.PENDING;
        op.setStatus(status);
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            LOG.debug("Time Elapsed {}", (Object)(endTime - startTime));
        }
        return op;
    }

    private static boolean isScheduled(Long absoluteTime) {
        long currentTimestamp = System.currentTimeMillis();
        return absoluteTime != null && absoluteTime > currentTimestamp;
    }

    private static Long getScheduledTime(Workflow workflow) {
        MetaDataMap metadata = workflow.getMetaDataMap();
        if (!metadata.containsKey((Object)"absoluteTime")) {
            return null;
        }
        return (Long)metadata.get("absoluteTime", Long.class);
    }

    private static String formatTime(Long absoluteTime) {
        if (absoluteTime == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(absoluteTime);
        return ISO8601.format((Calendar)cal);
    }

    private static List<Workflow> getScheduledWorkflows(WorkflowStatus workflowStatus) {
        LinkedList<Workflow> scheduledWorkflows = new LinkedList<Workflow>();
        if (workflowStatus == null) {
            return scheduledWorkflows;
        }
        List workflows = workflowStatus.getWorkflows(false);
        for (Workflow workflow : workflows) {
            if (!ScheduledOperation.isScheduledActivationWorkflow(workflow) && !ScheduledOperation.isScheduledDeactivationWorkflow(workflow)) continue;
            scheduledWorkflows.add(workflow);
        }
        scheduledWorkflows.sort(Comparator.nullsLast(Comparator.comparing(ScheduledOperation::getScheduledTime)));
        return scheduledWorkflows;
    }

    private static boolean isScheduledActivationWorkflow(Workflow workflow) {
        if (workflow == null) {
            return false;
        }
        String workflowId = workflow.getWorkflowModel().getId();
        return Arrays.asList("/var/workflow/models/scheduled_activation", SCHEDULED_ACTIVATION_WITH_REFERENCES_WORKFLOW_ID_VAR, SCHEDULED_TREE_ACTIVATION_WORKFLOW_ID_VAR).contains(workflowId);
    }

    private static boolean isScheduledDeactivationWorkflow(Workflow workflow) {
        if (workflow == null) {
            return false;
        }
        String workflowId = workflow.getWorkflowModel().getId();
        return Arrays.asList("/var/workflow/models/scheduled_deactivation", SCHEDULED_TREE_DEACTIVATION_WORKFLOW_ID_VAR).contains(workflowId);
    }

    public String getScheduledBy() {
        return this.scheduledBy;
    }

    public void setScheduledBy(String scheduledBy) {
        this.scheduledBy = scheduledBy;
    }

    public String getScheduledDate() {
        return this.scheduledDate;
    }

    public void setScheduledDate(String scheduledDate) {
        this.scheduledDate = scheduledDate;
    }
}

