/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.operations;

import com.adobe.cq.dam.cfm.headless.backend.impl.operations.AbstractOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Action;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Status;
import com.day.cq.replication.Agent;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationQueue;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationOperation
extends AbstractOperation {
    private static final Logger LOG = LoggerFactory.getLogger(PublicationOperation.class);
    private int queuePosition;

    private PublicationOperation() {
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public void setQueuePosition(int position) {
        this.queuePosition = position;
    }

    public static PublicationOperation getOperation(String path, Map<String, Pair<String, Integer>> cachedEntries, Agent agent) {
        long startTime = System.currentTimeMillis();
        PublicationOperation op = null;
        if (null == cachedEntries) {
            cachedEntries = PublicationOperation.buildReplicationQueueEntries(agent);
        }
        if (cachedEntries.containsKey(path)) {
            op = new PublicationOperation();
            Pair<String, Integer> pair = cachedEntries.get(path);
            String actionType = (String)pair.getKey();
            if ("Activate".equals(actionType)) {
                op.setAction(Action.PUBLISH);
            } else if ("Deactivate".equals(actionType)) {
                op.setAction(Action.UNPUBLISH);
            } else {
                LOG.warn("Invalid action type: {}", (Object)actionType);
            }
            op.setStatus(Status.QUEUED);
            op.setQueuePosition((Integer)pair.getValue());
        }
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            LOG.debug("Time Elapsed {}", (Object)(endTime - startTime));
        }
        return op;
    }

    public static Map<String, Pair<String, Integer>> buildReplicationQueueEntries(Agent agent) {
        ReplicationQueue queue;
        HashMap<String, Pair<String, Integer>> entries = new HashMap<String, Pair<String, Integer>>();
        long startTime = System.currentTimeMillis();
        int assetsTraversed = 0;
        if (null != agent && !agent.isInMaintenanceMode() && (queue = agent.getQueue()) != null) {
            for (ReplicationQueue.Entry entry : queue.entries()) {
                ++assetsTraversed;
                ReplicationAction action = entry.getAction();
                String path = action.getPath();
                String actionType = action.getType().getName();
                int currentItemPosition = entry.getQueuePosition();
                if (entries.containsKey(path) && (Integer)((Pair)entries.get(path)).getValue() >= currentItemPosition) continue;
                entries.put(path, (Pair<String, Integer>)new MutablePair((Object)actionType, (Object)currentItemPosition));
            }
        }
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            LOG.debug("Time Elapsed {}", (Object)(endTime - startTime));
            LOG.debug("assetsTraversed {}", (Object)assetsTraversed);
        }
        return entries;
    }
}

