/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.misc;

import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryMode;
import java.util.Arrays;

public class FullTextQueryGenerator {
    private static final String TO_ESCAPE = "+-&|!(){}[]^\"~*?:\\/";

    private FullTextQueryGenerator() {
    }

    private static boolean isSubWordDelim(int c) {
        return c >= 0 && c < 256 && !Character.isLowerCase(c) && !Character.isUpperCase(c) && !Character.isDigit(c);
    }

    static String removePossesives(String in) {
        StringBuilder processed = new StringBuilder(in.length());
        for (int p = 0; p < in.length(); ++p) {
            boolean isPossesiveAtEnd;
            boolean isPossesive = p > 2 && (in.charAt(p - 1) == 's' || in.charAt(p - 1) == 'S') && in.charAt(p - 2) == '\'' && !FullTextQueryGenerator.isSubWordDelim(in.charAt(p - 3)) && FullTextQueryGenerator.isSubWordDelim(in.charAt(p));
            boolean bl = isPossesiveAtEnd = p > 2 && p == in.length() - 1 && (in.charAt(p) == 's' || in.charAt(p) == 'S') && in.charAt(p - 1) == '\'';
            if (isPossesive) {
                processed.delete(processed.length() - 2, processed.length());
            }
            if (isPossesiveAtEnd) {
                processed.delete(processed.length() - 1, processed.length());
                continue;
            }
            processed.append(in.charAt(p));
        }
        return processed.toString();
    }

    private static String processSubWords(String in) {
        StringBuilder processed = new StringBuilder();
        in.chars().forEach(i -> {
            if (FullTextQueryGenerator.isSubWordDelim(i)) {
                processed.append(' ');
            } else {
                processed.append((char)i);
            }
        });
        return processed.toString();
    }

    private static String preprocess(String searchTerm, boolean escape) {
        String lowerCase = searchTerm.toLowerCase();
        String preprocessed = FullTextQueryGenerator.removePossesives(lowerCase);
        if (escape) {
            StringBuilder escaped = new StringBuilder(preprocessed.length());
            preprocessed.chars().forEach(i -> {
                if (!Character.isSupplementaryCodePoint(i) && TO_ESCAPE.contains(Character.toString((char)i))) {
                    escaped.append("\\");
                }
                escaped.append((char)i);
            });
            return escaped.toString();
        }
        return FullTextQueryGenerator.processSubWords(preprocessed);
    }

    private static String toEdgyWildcards(String preprocessedTerm) {
        return "*" + preprocessedTerm + "*";
    }

    private static String toInternalWildcards(String preprocessedTerm) {
        StringBuilder withWildcards = new StringBuilder();
        Arrays.stream(preprocessedTerm.split(" ")).forEach(partial -> {
            if (withWildcards.length() > 0) {
                withWildcards.append(' ');
            }
            withWildcards.append('*').append((String)partial).append('*');
        });
        return withWildcards.toString();
    }

    private static String toExactWords(String preprocessedTerm) {
        return preprocessedTerm;
    }

    private static String toExactPhrase(String preprocessedTerm) {
        return "\"" + preprocessedTerm + "\"";
    }

    public static String create(String searchTerm, FullTextQueryMode mode) {
        if (searchTerm == null) {
            return null;
        }
        if (mode == FullTextQueryMode.AS_IS) {
            return searchTerm;
        }
        String preprocessed = FullTextQueryGenerator.preprocess(searchTerm, false);
        if (mode == FullTextQueryMode.EDGES) {
            return FullTextQueryGenerator.toEdgyWildcards(preprocessed);
        }
        if (mode == FullTextQueryMode.ALLTERMS) {
            return FullTextQueryGenerator.toInternalWildcards(preprocessed);
        }
        if (mode == FullTextQueryMode.EXACT_WORDS) {
            return FullTextQueryGenerator.toExactWords(preprocessed);
        }
        if (mode == FullTextQueryMode.EXACT_PHRASE) {
            return FullTextQueryGenerator.toExactPhrase(preprocessed);
        }
        throw new IllegalArgumentException("Unsupported mode: " + mode);
    }
}

