/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit;

import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.FindAndReplaceService;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.ErrorField;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.FieldValidationType;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.ReplaceResolutionContentFragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.bulkedit.model.ReplaceStatus;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.impl.servlets.validators.FragmentValidator;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.FragmentsFindAndReplaceRequest;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.TextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ValidationMessage;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FindAndReplaceService.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-5469)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FindAndReplaceServiceImpl
implements FindAndReplaceService {
    private static final Logger log = LoggerFactory.getLogger(FindAndReplaceServiceImpl.class);
    @Reference
    private FragmentService fragmentService;
    @Reference
    private FragmentValidator fragmentValidator;

    @Override
    public List<ReplaceResolutionContentFragment> findAndReplace(ResourceResolver resourceResolver, FragmentsFindAndReplaceRequest findAndReplaceRequest) throws ContentFragmentException {
        ArrayList<ReplaceResolutionContentFragment> result = new ArrayList<ReplaceResolutionContentFragment>();
        boolean dryRun = findAndReplaceRequest.getDryRun();
        boolean ignoreErrors = findAndReplaceRequest.getIgnoreErrors();
        String find = findAndReplaceRequest.getFind();
        String replace = findAndReplaceRequest.getReplace();
        List<String> paths = findAndReplaceRequest.getPaths();
        for (String path : paths) {
            Resource resource = resourceResolver.getResource(path);
            if (resource == null) continue;
            Fragment fragment = this.fragmentService.getFragment(resource);
            ContentFragment cf = fragment.convert();
            Map<String, List<String>> initialValues = this.attemptFindAndReplace(cf, find, replace);
            List<ValidationMessage> validationResult = this.fragmentValidator.validate(cf, resourceResolver).getValidationMessages();
            result.add(this.computeFindAdReplaceStatus(cf, validationResult, initialValues, resource.getPath()));
            this.commitChangesIfPossible(dryRun, ignoreErrors, fragment, cf, validationResult, initialValues);
        }
        return result;
    }

    Map<String, List<String>> attemptFindAndReplace(ContentFragment cf, String find, String replace) {
        HashMap<String, List<String>> initialValues = new HashMap<String, List<String>>();
        cf.getFields().stream().filter(field -> DataType.TEXT.equals((Object)field.getType()) || DataType.LONG_TEXT.equals((Object)field.getType())).forEach(field -> {
            if (field instanceof TextFragmentField) {
                Collection oldValue = ((TextFragmentField)field).getValues();
                List<String> valueAfterReplace = oldValue.stream().map(oldItem -> oldItem.replace(find, replace)).collect(Collectors.toList());
                ((TextFragmentField)field).setValues(valueAfterReplace);
                initialValues.put(field.getName(), (List<String>)oldValue);
            } else if (field instanceof LongTextFragmentField) {
                Collection oldValue = ((LongTextFragmentField)field).getValues();
                List<String> valueAfterReplace = oldValue.stream().map(oldItem -> oldItem.replace(find, replace)).collect(Collectors.toList());
                ((LongTextFragmentField)field).setValues(valueAfterReplace);
                initialValues.put(field.getName(), (List<String>)oldValue);
            }
        });
        return initialValues;
    }

    ReplaceResolutionContentFragment computeFindAdReplaceStatus(ContentFragment cf, List<ValidationMessage> validationResult, Map<String, List<String>> initialValues, String path) {
        Map<String, List<ValidationMessage>> errorsGroupedByField = validationResult.stream().collect(Collectors.groupingBy(ValidationMessage::getProperty));
        ReplaceResolutionContentFragment response = new ReplaceResolutionContentFragment();
        ArrayList<ErrorField> errorFields = new ArrayList<ErrorField>();
        for (String fieldInErrorName : errorsGroupedByField.keySet()) {
            ErrorField errField = new ErrorField();
            errField.setFieldName(fieldInErrorName);
            errField.setDetails(errorsGroupedByField.get(fieldInErrorName).stream().map(errMsg -> this.convertToValidationType(errMsg.getMessage())).collect(Collectors.toList()));
            errorFields.add(errField);
        }
        response.setFieldsInError(errorFields);
        response.setStatus(validationResult.size() > 0 ? ReplaceStatus.ERROR : this.discriminateOkVsNotApplicable(initialValues, cf));
        response.setPath(path);
        return response;
    }

    private FieldValidationType convertToValidationType(String msg) {
        if (msg.toLowerCase().contains("url")) {
            return FieldValidationType.REGEX_URL;
        }
        if (msg.toLowerCase().contains("email")) {
            return FieldValidationType.REGEX_EMAIL;
        }
        if (msg.toLowerCase().contains("custom")) {
            return FieldValidationType.REGEX_CUSTOM;
        }
        if (msg.toLowerCase().contains("size must be between")) {
            return FieldValidationType.MAX_LENGTH;
        }
        return FieldValidationType.REQUIRED;
    }

    ReplaceStatus discriminateOkVsNotApplicable(Map<String, List<String>> initialValues, ContentFragment cf) {
        Optional<Boolean> contentChanged = cf.getFields().stream().filter(field -> DataType.TEXT.equals((Object)field.getType()) || DataType.LONG_TEXT.equals((Object)field.getType())).map(field -> {
            Collection current = new ArrayList();
            if (field instanceof TextFragmentField) {
                current = ((TextFragmentField)field).getValues();
            } else if (field instanceof LongTextFragmentField) {
                current = ((LongTextFragmentField)field).getValues();
            }
            List initial = (List)initialValues.get(field.getName());
            if (current.size() == initial.size()) {
                for (int i = 0; i <= current.size() - 1; ++i) {
                    if (((String)current.get(i)).equals(initial.get(i))) continue;
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }).filter(changed -> changed).findFirst();
        if (contentChanged.isPresent()) {
            return ReplaceStatus.OK;
        }
        return ReplaceStatus.NOT_APPLICABLE;
    }

    boolean commitChangesIfPossible(boolean dryRun, boolean ignoreErrors, Fragment fragment, ContentFragment cf, List<ValidationMessage> validationResult, Map<String, List<String>> initialValues) throws ContentFragmentException {
        if (!dryRun) {
            if (validationResult.isEmpty()) {
                this.fragmentService.patchFragment(fragment, cf);
                return true;
            }
            if (ignoreErrors) {
                List<String> fieldInError = validationResult.stream().map(msg -> this.extractFieldName(msg.getProperty())).collect(Collectors.toList());
                if (!validationResult.isEmpty()) {
                    this.revertValuesForErrorFieldsToInitial(cf, initialValues, fieldInError);
                    this.fragmentService.patchFragment(fragment, cf);
                    return true;
                }
            }
        }
        return false;
    }

    void revertValuesForErrorFieldsToInitial(ContentFragment cf, Map<String, List<String>> initialValues, List<String> fieldInError) {
        cf.getFields().stream().filter(field -> fieldInError.contains(field.getName())).filter(field -> DataType.TEXT.equals((Object)field.getType()) || DataType.LONG_TEXT.equals((Object)field.getType())).forEach(field -> {
            if (field instanceof TextFragmentField) {
                ((TextFragmentField)field).setValues((List)initialValues.get(field.getName()));
            } else if (field instanceof LongTextFragmentField) {
                ((LongTextFragmentField)field).setValues((List)initialValues.get(field.getName()));
            }
        });
    }

    private String extractFieldName(String validationMessage) {
        if (!validationMessage.contains("fields.")) {
            log.error("Unexpected format - missing fields - for validation error in case of {}.", (Object)validationMessage);
            return validationMessage;
        }
        String core = validationMessage.replace("fields.", "");
        if (!core.contains(".")) {
            log.error("Unexpected format - no field specified - for validation error in case of {}.", (Object)validationMessage);
            return validationMessage;
        }
        return core.substring(0, core.indexOf("."));
    }
}

