/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2;

import com.adobe.cq.dam.cfm.headless.backend.SortingField;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Column;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Condition;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.ConditionBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Join;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.JoinType;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Option;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.QueryBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Selector;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.ColumnImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.ConditionBuilderImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.JoinImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.OptionDef;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.SelectorImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Sql2Builder
implements QueryBuilder {
    private Selector selector;
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Join> joins = new ArrayList<Join>();
    private Condition condition;
    private final List<SortingField> sortingFields = new ArrayList<SortingField>();
    private final List<OptionDef> options = new ArrayList<OptionDef>();

    private Sql2Builder() {
    }

    public static QueryBuilder newBuilder() {
        return new Sql2Builder();
    }

    public static ConditionBuilder newCondition() {
        return new ConditionBuilderImpl(null);
    }

    @Override
    public QueryBuilder selector(String nodeType, String alias) {
        this.selector = new SelectorImpl(nodeType, alias);
        return this;
    }

    @Override
    public QueryBuilder selector(String nodeType) {
        this.selector(nodeType, null);
        return this;
    }

    @Override
    public QueryBuilder field(String alias, String name) {
        this.columns.add(new ColumnImpl(alias, name));
        return this;
    }

    @Override
    public QueryBuilder field(String name) {
        this.field(null, name);
        return this;
    }

    @Override
    public QueryBuilder join(JoinType type, String nodeType, String alias, Condition joinCondition) {
        this.joins.add(new JoinImpl(type, new SelectorImpl(nodeType, alias), joinCondition));
        return this;
    }

    @Override
    public QueryBuilder condition(Condition condition) {
        if (this.condition != null) {
            throw new IllegalStateException("Only one condition per query allowed");
        }
        this.condition = condition;
        return this;
    }

    @Override
    public QueryBuilder orderBy(String alias, String name, boolean isDescending) {
        this.sortingFields.add(new SortingField(alias, name, isDescending));
        return this;
    }

    @Override
    public QueryBuilder orderBy(String primaryAlias, String primaryName, String secondaryAlias, String secondaryName, boolean isDescending) {
        this.sortingFields.add(new SortingField(primaryAlias, primaryName, isDescending, secondaryAlias, secondaryName));
        return this;
    }

    @Override
    public QueryBuilder orderBy(String alias, String name) {
        this.orderBy(alias, name, false);
        return this;
    }

    @Override
    public QueryBuilder orderBy(String name, boolean isDescending) {
        this.orderBy(null, name, isDescending);
        return this;
    }

    @Override
    public QueryBuilder orderBy(String name) {
        this.orderBy(null, name, false);
        return this;
    }

    @Override
    public QueryBuilder execute(Consumer<QueryBuilder> fn) {
        fn.accept(this);
        return this;
    }

    @Override
    public QueryBuilder option(Option option, Object ... parameters) {
        this.options.add(new OptionDef(option, parameters));
        return this;
    }

    private void verifyState() {
        if (this.selector == null) {
            throw new IllegalStateException("No selector specified");
        }
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("No fields to query specified");
        }
    }

    private boolean addTextOnSubsequentItems(StringBuilder statement, String text, boolean isFirstItem) {
        if (!isFirstItem) {
            statement.append(text);
        }
        return false;
    }

    private void addFields(StringBuilder sql2) {
        boolean isFirst = true;
        for (Column column : this.columns) {
            isFirst = this.addTextOnSubsequentItems(sql2, ", ", isFirst);
            column.addToStatement(sql2);
        }
    }

    private void addJoins(StringBuilder sql2) {
        if (!this.joins.isEmpty()) {
            sql2.append(' ');
            boolean isFirst = true;
            for (Join join : this.joins) {
                isFirst = this.addTextOnSubsequentItems(sql2, " ", isFirst);
                join.addToStatement(sql2);
            }
        }
    }

    private void addCondition(StringBuilder sql2) {
        if (this.condition != null && this.condition.isDefined()) {
            sql2.append(" WHERE ");
            this.condition.addToExpression(sql2);
        }
    }

    private void addOrderBy(StringBuilder sql2) {
        if (!this.sortingFields.isEmpty()) {
            sql2.append(" ORDER BY ");
            boolean isFirst = true;
            for (SortingField field : this.sortingFields) {
                if (field.getSecondaryName() == null) {
                    ColumnImpl column = new ColumnImpl(field.getAlias(), field.getName());
                    isFirst = this.addTextOnSubsequentItems(sql2, ", ", isFirst);
                    ((Column)column).addToStatement(sql2);
                } else {
                    isFirst = this.addTextOnSubsequentItems(sql2, ", ", isFirst);
                    this.addCoalescedOrderBy(sql2, field);
                }
                if (!field.isDescending()) continue;
                sql2.append(" DESC");
            }
        }
    }

    private void addCoalescedOrderBy(StringBuilder sql2, SortingField field) {
        String auxFieldAlias = field.getSecondaryAlias();
        String auxFieldPath = field.getSecondaryName();
        sql2.append("COALESCE(");
        String alias = field.getAlias();
        if (alias != null) {
            sql2.append(alias).append('.');
        }
        sql2.append('[').append(field.getName()).append("], ");
        if (auxFieldAlias != null) {
            sql2.append(auxFieldAlias).append('.');
        }
        sql2.append('[').append(auxFieldPath).append("])");
    }

    private void addOptions(StringBuilder sql2) {
        if (!this.options.isEmpty()) {
            sql2.append(" OPTION (");
            boolean isFirst = true;
            for (OptionDef option : this.options) {
                option.verify();
                isFirst = this.addTextOnSubsequentItems(sql2, ", ", isFirst);
                option.addToBuilder(sql2);
            }
            sql2.append(")");
        }
    }

    @Override
    public String build() {
        this.verifyState();
        StringBuilder sql2 = new StringBuilder();
        sql2.append("SELECT ");
        this.addFields(sql2);
        sql2.append(" FROM ");
        this.selector.addToStatement(sql2);
        this.addJoins(sql2);
        this.addCondition(sql2);
        this.addOrderBy(sql2);
        this.addOptions(sql2);
        return sql2.toString();
    }
}

