/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2;

import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Option;

class OptionDef {
    private final Option option;
    private final Object[] parameters;

    OptionDef(Option option, Object ... parameters) {
        this.option = option;
        this.parameters = parameters;
    }

    void verify() {
        switch (this.option) {
            case NO_TRAVERSAL: {
                if (this.parameters == null || this.parameters.length <= 0) break;
                throw new IllegalArgumentException("NO_TRAVERSAL must not have any parameters");
            }
            case INDEX_TAG: {
                if (this.parameters != null && this.parameters.length == 1) break;
                throw new IllegalArgumentException("For INDEX_TAG an index tag is required.");
            }
        }
    }

    void addToBuilder(StringBuilder builder) {
        switch (this.option) {
            case NO_TRAVERSAL: {
                builder.append("TRAVERSAL FAIL");
                break;
            }
            case INDEX_TAG: {
                builder.append("INDEX TAG");
                builder.append("[");
                builder.append(this.parameters[0]);
                builder.append("]");
            }
        }
    }
}

