/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2;

import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Column;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.CompOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.FunctionalComparison;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.ColumnImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.CompUtil;
import java.util.Arrays;

public class FunctionalComparisonImpl
extends FunctionalComparison {
    FunctionalComparisonImpl(Function fn, Object ... parameters) {
        super(fn, parameters);
        this.verifyParameters();
    }

    private void ensureString(Object param) {
        if (!(param instanceof String)) {
            throw new IllegalStateException("Expected function parameter of type 'String'");
        }
    }

    private void verifyContainsParameters() {
        if (this.parameters.length < 2 || this.parameters.length > 3) {
            throw new IllegalStateException("Invalid function parameters for 'contains'; must be either (property, text) or (property, alias, text)");
        }
        Arrays.stream(this.parameters).forEach(this::ensureString);
    }

    private void verifyIsChildParameters() {
        if (this.parameters.length != 2) {
            throw new IllegalStateException("Invalid function parameters for 'isChild'; must be (childSelector, parentPath)");
        }
        Arrays.stream(this.parameters).forEach(this::ensureString);
    }

    private void verifyIsDescendantParameters() {
        if (this.parameters.length != 2) {
            throw new IllegalStateException("Invalid function parameters for 'isDescendant'; must be (descendantSelector, ancestorPath)");
        }
        Arrays.stream(this.parameters).forEach(this::ensureString);
    }

    private void verifyCoalesceParameters() {
        int parameterCnt = this.parameters.length;
        if (parameterCnt != 4 && parameterCnt != 6) {
            throw new IllegalStateException("Invalid function parameters for 'coalesce'; must be either (path1, path2, compOp, value) or (alias1, path1, alias2, path2, compOp, value)");
        }
        Arrays.stream(this.parameters).limit((long)parameterCnt - 2L).forEach(this::ensureString);
        if (!(this.parameters[parameterCnt - 2] instanceof CompOp)) {
            throw new IllegalStateException("Expected function parameter of type 'CompOp'");
        }
    }

    private void verifyParameters() {
        switch (this.fn) {
            case CONTAINS: {
                this.verifyContainsParameters();
                break;
            }
            case ISCHILDNODE: {
                this.verifyIsChildParameters();
                break;
            }
            case ISDESCENDANTNODE: {
                this.verifyIsDescendantParameters();
                break;
            }
            case COALESCE: {
                this.verifyCoalesceParameters();
            }
        }
    }

    private void addContains(StringBuilder expression) {
        String text;
        String property = (String)this.parameters[0];
        String nodeType = null;
        if (this.parameters.length == 2) {
            text = (String)this.parameters[1];
        } else {
            nodeType = (String)this.parameters[1];
            text = (String)this.parameters[2];
        }
        ColumnImpl col = new ColumnImpl(nodeType, property);
        expression.append("CONTAINS(");
        ((Column)col).addToStatement(expression);
        expression.append(", '");
        expression.append(CompUtil.escapeString(text));
        expression.append("')");
    }

    private void addIsChildNode(StringBuilder expression) {
        String childSelector = (String)this.parameters[0];
        String parentSelector = (String)this.parameters[1];
        expression.append("ISCHILDNODE(");
        expression.append(childSelector);
        expression.append(", '");
        expression.append(CompUtil.escapeString(parentSelector));
        expression.append("')");
    }

    private void addIsDescendantNode(StringBuilder expression) {
        String descendantSelector = (String)this.parameters[0];
        String ancestorSelector = (String)this.parameters[1];
        expression.append("ISDESCENDANTNODE(");
        expression.append(descendantSelector);
        expression.append(", '");
        expression.append(CompUtil.escapeString(ancestorSelector));
        expression.append("')");
    }

    private void addCoalesce(StringBuilder expression) {
        Object value;
        CompOp compOp;
        String path2;
        String path1;
        String alias1 = null;
        String alias2 = null;
        if (this.parameters.length == 4) {
            path1 = (String)this.parameters[0];
            path2 = (String)this.parameters[1];
            compOp = (CompOp)((Object)this.parameters[2]);
            value = this.parameters[3];
        } else {
            alias1 = (String)this.parameters[0];
            path1 = (String)this.parameters[1];
            alias2 = (String)this.parameters[2];
            path2 = (String)this.parameters[3];
            compOp = (CompOp)((Object)this.parameters[4]);
            value = this.parameters[5];
        }
        expression.append("COALESCE(");
        if (alias1 != null) {
            expression.append(alias1).append('.');
        }
        expression.append('[');
        expression.append(path1);
        expression.append("], ");
        if (alias2 != null) {
            expression.append(alias2).append('.');
        }
        expression.append('[');
        expression.append(path2);
        expression.append("])");
        expression.append(' ').append(CompUtil.getCompOpRep(compOp));
        expression.append(' ').append(CompUtil.getValueRep(value));
    }

    @Override
    public void addToExpression(StringBuilder expression) {
        switch (this.fn) {
            case CONTAINS: {
                this.addContains(expression);
                break;
            }
            case ISCHILDNODE: {
                this.addIsChildNode(expression);
                break;
            }
            case ISDESCENDANTNODE: {
                this.addIsDescendantNode(expression);
                break;
            }
            case COALESCE: {
                this.addCoalesce(expression);
            }
        }
    }
}

