/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2;

import com.adobe.cq.dam.cfm.headless.backend.impl.builder.CompOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Comparison;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Condition;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.ConditionBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.LogOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.ColumnImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.ConditionImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.FieldComparisonImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.FunctionalComparisonImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.StaticComparisonImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.SubConditionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

class ConditionBuilderImpl
implements ConditionBuilder {
    private final List<Comparison> comparisons = new ArrayList<Comparison>();
    private final List<LogOp> logOps = new ArrayList<LogOp>();
    private final ConditionBuilder parentBuilder;

    ConditionBuilderImpl(ConditionBuilder parentBuilder) {
        this.parentBuilder = parentBuilder;
    }

    private void ensureComparisonLogOpsMatch() {
        if (this.comparisons.size() != this.logOps.size()) {
            throw new IllegalStateException("Invalid condition; number of comparisons and log ops doesn't match.");
        }
    }

    private void ensureParentBuilder() {
        if (this.parentBuilder == null) {
            throw new IllegalStateException("endSubCondition without previous startSubCondition");
        }
    }

    @Override
    public ConditionBuilder comparison(String name, String alias, CompOp comp, Object value) {
        this.ensureComparisonLogOpsMatch();
        this.comparisons.add(new StaticComparisonImpl(new ColumnImpl(alias, name), comp, value));
        return this;
    }

    @Override
    public ConditionBuilder comparison(Function fn, Object ... parameters) {
        this.ensureComparisonLogOpsMatch();
        this.comparisons.add(new FunctionalComparisonImpl(fn, parameters));
        return this;
    }

    @Override
    public ConditionBuilder comparison(String name1, String alias1, CompOp comp, String name2, String alias2) {
        this.ensureComparisonLogOpsMatch();
        this.comparisons.add(new FieldComparisonImpl(new ColumnImpl(alias1, name1), comp, new ColumnImpl(alias2, name2)));
        return this;
    }

    @Override
    public ConditionBuilder logOp(LogOp logOp) {
        if (this.comparisons.size() - 1 != this.logOps.size()) {
            throw new IllegalStateException("Invalid condition; number of comparisons and log ops doesn't match.");
        }
        this.logOps.add(logOp);
        return this;
    }

    @Override
    public ConditionBuilder fragment(LogOp logOp, String name, String alias, CompOp comp, Object value, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            if (!this.comparisons.isEmpty()) {
                this.logOp(logOp);
            }
            this.comparison(name, alias, comp, value);
        }
        return this;
    }

    @Override
    public ConditionBuilder fragment(LogOp logOp, BooleanSupplier condition, Function fn, Object ... parameters) {
        if (condition.getAsBoolean()) {
            if (!this.comparisons.isEmpty()) {
                this.logOp(logOp);
            }
            this.comparison(fn, parameters);
        }
        return this;
    }

    @Override
    public ConditionBuilder fragment(LogOp logOp, String name1, String alias1, CompOp comp, String name2, String alias2, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            if (!this.comparisons.isEmpty()) {
                this.logOp(logOp);
            }
            this.comparison(name1, alias1, comp, name2, alias2);
        }
        return this;
    }

    @Override
    public ConditionBuilder startSubCondition() {
        this.ensureComparisonLogOpsMatch();
        ConditionBuilderImpl childBuilder = new ConditionBuilderImpl(this);
        SubConditionImpl subCondition = new SubConditionImpl(childBuilder);
        this.comparisons.add(subCondition);
        return childBuilder;
    }

    @Override
    public ConditionBuilder startSubCondition(LogOp logOp, BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            if (!this.comparisons.isEmpty()) {
                this.logOp(logOp);
            }
            return this.startSubCondition();
        }
        return this;
    }

    @Override
    public ConditionBuilder endSubCondition() {
        this.ensureParentBuilder();
        return this.parentBuilder;
    }

    @Override
    public ConditionBuilder endSubCondition(BooleanSupplier condition) {
        if (condition.getAsBoolean()) {
            this.ensureParentBuilder();
            return this.parentBuilder;
        }
        return this;
    }

    @Override
    public ConditionBuilder execute(Consumer<ConditionBuilder> fn) {
        fn.accept(this);
        return this;
    }

    Condition buildCondition() {
        boolean isEmpty;
        boolean bl = isEmpty = this.comparisons.isEmpty() && this.logOps.isEmpty();
        if (!isEmpty && this.comparisons.size() - 1 != this.logOps.size()) {
            throw new IllegalStateException("Invalid condition; number of comparisons and log ops doesn't match");
        }
        return new ConditionImpl(this.comparisons, this.logOps);
    }

    @Override
    public Condition build() {
        if (this.parentBuilder != null) {
            throw new IllegalStateException("Can't build sub condition directly; number of calls to startSubCondition/endSubCondition doesn't match");
        }
        return this.buildCondition();
    }
}

