/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2;

import com.adobe.cq.dam.cfm.headless.backend.impl.builder.CompOp;
import java.util.Calendar;
import org.apache.jackrabbit.util.ISO8601;

public class CompUtil {
    private CompUtil() {
    }

    public static String getCompOpRep(CompOp compOp) {
        switch (compOp) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "<>";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUAL: {
                return ">=";
            }
            case LOWER_THAN: {
                return "<";
            }
            case LOWER_THAN_OR_EQUAL: {
                return "<=";
            }
            case IS: {
                return "IS";
            }
            case IS_NOT: {
                return "IS NOT";
            }
        }
        throw new IllegalArgumentException("Unsupported CompOp: " + compOp);
    }

    public static String escapeString(String text) {
        return text.replace("'", "''");
    }

    public static String getValueRep(Object value) {
        if (value instanceof CharSequence) {
            String str = ((CharSequence)value).toString();
            return "'" + CompUtil.escapeString(str) + "'";
        }
        if (value instanceof Calendar) {
            return "cast('" + ISO8601.format((Calendar)((Calendar)value)) + "' AS date)";
        }
        return value != null ? value.toString() : "NULL";
    }
}

