/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Option;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.Sql2Builder;
import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryMode;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.ScheduledOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TimeAuthorInformation;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.GenericResource;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Operations;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.ReferencedResource;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.dam.cfm.headless.commons.StatusPreviewInfo;
import com.adobe.cq.dam.cfm.openapi.models.FullTextSearchCriteria;
import com.adobe.cq.dam.cfm.openapi.models.ResourceStatus;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    public static final String PN_REPLICATED = "cq:lastReplicated";
    public static final String PN_REPLICATED_BY = "cq:lastReplicatedBy";
    public static final String PN_REPLICATION_ACTION = "cq:lastReplicationAction";
    public static final String PV_REPL_ACTION_ACTIVATE = "Activate";
    public static final String PV_REPL_ACTION_DEACTIVATE = "Deactivate";
    public static final Pattern UUID_REGEX_PATTERN_RAW = Pattern.compile("[{]?[0-9a-fA-F]{8}-([0-9a-fA-F]{4}-){3}[0-9a-fA-F]{12}[}]?");
    public static final Pattern UUID_REGEX_PATTERN = Pattern.compile("^" + UUID_REGEX_PATTERN_RAW + "$");
    public static final Pattern WEAK_ETAG_PATTERN = Pattern.compile("W/\"[a-fA-F0-9]{32}\"");

    private Utils() {
    }

    public static Node getAssetContentNode(ContentFragment contentFragment) {
        return Utils.getNode(contentFragment, "jcr:content");
    }

    public static Node getAssetNode(ContentFragment contentFragment) {
        return Utils.getNode(contentFragment, null);
    }

    private static Node getNode(ContentFragment contentFragment, String subPath) {
        Resource res = (Resource)contentFragment.adaptTo(Resource.class);
        if (res == null) {
            return null;
        }
        Session session = (Session)res.getResourceResolver().adaptTo(Session.class);
        if (session == null) {
            return null;
        }
        Node node = null;
        try {
            String path = StringUtils.isEmpty((CharSequence)subPath) ? res.getPath() : res.getPath() + "/" + subPath;
            node = session.getNode(path);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return node;
    }

    public static String getDateOrTimeLocalized(Calendar cal, String semanticType) {
        if (cal == null) {
            return null;
        }
        if ("date".equals(semanticType)) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format(((GregorianCalendar)cal).toZonedDateTime());
        }
        if ("time".equals(semanticType)) {
            return DateTimeFormatter.ISO_LOCAL_TIME.format(((GregorianCalendar)cal).toZonedDateTime());
        }
        return ISO8601.format((Calendar)cal);
    }

    @NotNull
    public static StatusInfo determineStatusInfo(@NotNull Resource resource) {
        Node assetContent = Optional.ofNullable(resource.getChild("jcr:content")).map(contentResource -> (Node)contentResource.adaptTo(Node.class)).orElse(null);
        if (assetContent == null) {
            return StatusInfo.NEW;
        }
        Calendar modifiedAt = Utils.getCalendarProperty(assetContent, "jcr:lastModified");
        Calendar publishedAt = Utils.getCalendarProperty(assetContent, PN_REPLICATED);
        return Utils.determineStatusInfo(assetContent, modifiedAt, publishedAt);
    }

    @NotNull
    public static StatusInfo determineStatusInfo(Node assetContent, Calendar modifiedAt, Calendar publishedAt) {
        String lastRepAction = Utils.getStringProperty(assetContent, PN_REPLICATION_ACTION);
        return Utils.determineStatusInfo(lastRepAction, modifiedAt, publishedAt);
    }

    public static StatusInfo determineStatusInfo(String lastRepAction, Calendar modifiedAt, Calendar publishedAt) {
        StatusInfo status;
        if (PV_REPL_ACTION_DEACTIVATE.equals(lastRepAction)) {
            return StatusInfo.UNPUBLISHED;
        }
        StatusInfo statusInfo = status = modifiedAt != null ? StatusInfo.DRAFT : StatusInfo.NEW;
        if (publishedAt == null || !PV_REPL_ACTION_ACTIVATE.equals(lastRepAction)) {
            return status;
        }
        return modifiedAt == null || publishedAt.after(modifiedAt) ? StatusInfo.PUBLISHED : StatusInfo.MODIFIED;
    }

    public static StatusPreviewInfo determineStatusPreviewInfo(Calendar modifiedAt, Calendar lastReplicatedPreview) {
        if (lastReplicatedPreview == null) {
            return null;
        }
        if (modifiedAt == null) {
            return StatusPreviewInfo.IN_SYNC;
        }
        return modifiedAt.after(lastReplicatedPreview) ? StatusPreviewInfo.OUT_OF_SYNC : StatusPreviewInfo.IN_SYNC;
    }

    public static String getStringProperty(Node node, String property) {
        String value = null;
        try {
            value = node.getProperty(property).getString();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return value;
    }

    public static Calendar getCalendarProperty(Node node, String property) {
        Calendar value = null;
        try {
            value = node.getProperty(property).getDate();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return value;
    }

    public static boolean getBooleanProperty(Node node, String property) {
        boolean value = false;
        try {
            value = node.getProperty(property).getBoolean();
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return value;
    }

    public static OffsetDateTime convertCalendarToOffsetDateTime(Calendar calendar) {
        return calendar == null ? null : OffsetDateTime.ofInstant(calendar.toInstant(), ZoneId.of(calendar.getTimeZone().getID()));
    }

    public static TimeAuthorInformation createTimeAuthorInformation(@Nullable Calendar at, @Nullable String by) {
        return new TimeAuthorInformation(Utils.convertCalendarToOffsetDateTime(at), by);
    }

    public static TimeAuthorInformation getCreatedInfo(ValueMap valueMap) {
        String createdBy = (String)valueMap.get("jcr:createdBy", String.class);
        Calendar createdAt = (Calendar)valueMap.get("jcr:created", Calendar.class);
        return Utils.createTimeAuthorInformation(createdAt, createdBy);
    }

    public static TimeAuthorInformation getModifiedInfo(ValueMap valueMap) {
        String modifiedBy = (String)valueMap.get("jcr:lastModifiedBy", String.class);
        Calendar modifiedAt = (Calendar)valueMap.get("jcr:lastModified", Calendar.class);
        return Utils.createTimeAuthorInformation(modifiedAt, modifiedBy);
    }

    public static void setModifiedPublishedStatus(Resource resource, GenericResource auditable) {
        Utils.setModifiedPublishedStatus(resource, auditable, true, true);
    }

    public static void setStatus(Resource resource, ReferencedResource reference) {
        Utils.setModifiedPublishedStatus(resource, reference, false, false);
    }

    private static void setModifiedPublishedStatus(Resource resource, GenericResource auditable, boolean includeModified, boolean includePublished) {
        ScheduledOperation scheduledReplication;
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource == null) {
            log.error("Unable to get jcr:content from the Resource {}", (Object)resource.getPath());
            return;
        }
        ValueMap vm = contentResource.getValueMap();
        String modifiedBy = (String)vm.get("jcr:lastModifiedBy", String.class);
        Calendar modifiedAt = (Calendar)vm.get("jcr:lastModified", Calendar.class);
        if (includeModified) {
            auditable.setModified(Utils.createTimeAuthorInformation(modifiedAt, modifiedBy));
        }
        String publishedBy = (String)vm.get(PN_REPLICATED_BY, String.class);
        Calendar publishedAt = (Calendar)vm.get(PN_REPLICATED, Calendar.class);
        if (includePublished && ObjectUtils.allNotNull((Object[])new Object[]{publishedBy, publishedAt})) {
            auditable.setPublished(Utils.createTimeAuthorInformation(publishedAt, publishedBy));
        }
        if ((scheduledReplication = ScheduledOperation.getOperation(resource)) != null) {
            auditable.setOperations(new Operations(scheduledReplication));
        }
        String lastReplicationAction = (String)vm.get(PN_REPLICATION_ACTION, String.class);
        StatusInfo status = Utils.determineStatusInfo(lastReplicationAction, modifiedAt, publishedAt);
        auditable.setStatus(status);
    }

    public static void setPreviewStatus(Resource resource, GenericResource auditable) {
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource == null) {
            log.error("Unable to get jcr:content from the Resource {}", (Object)resource.getPath());
            return;
        }
        ValueMap vm = contentResource.getValueMap();
        Calendar modifiedAt = (Calendar)vm.get("jcr:lastModified", Calendar.class);
        Calendar lastReplicatedPreview = (Calendar)vm.get("cq:lastReplicated_preview", Calendar.class);
        StatusPreviewInfo statusPreview = Utils.determineStatusPreviewInfo(modifiedAt, lastReplicatedPreview);
        auditable.setPreviewStatus(statusPreview);
    }

    public static boolean folderHasChildren(ResourceResolver resolver, String folderPath, String type) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalStateException("ResourceResolver provided is not JCR-based, can't execute");
        }
        try {
            String alias = "f";
            String sql2 = Sql2Builder.newBuilder().selector(type, alias).field("*").condition(Sql2Builder.newCondition().comparison(Function.ISCHILDNODE, alias, folderPath).build()).option(Option.NO_TRAVERSAL, new Object[0]).build();
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(sql2, "JCR-SQL2");
            query.setLimit(1L);
            QueryResult result = query.execute();
            return result.getRows().getSize() > 0L;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    @Nullable
    public static Resource getResourceByUuid(@NotNull String uuid, @NotNull ResourceResolver resolver) {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalStateException("ResourceResolver provided is not JCR-based, can't execute");
        }
        try {
            if (Utils.isValidUUID(uuid)) {
                String resourcePath = session.getNodeByIdentifier(uuid).getPath();
                return resolver.getResource(resourcePath);
            }
        }
        catch (RepositoryException e) {
            return null;
        }
        return null;
    }

    public static String getUuidFromRequestPath(@NotNull String pathInfo) {
        Matcher isUUID = UUID_REGEX_PATTERN_RAW.matcher(pathInfo);
        return isUUID.find() ? isUUID.group(0) : null;
    }

    public static boolean isValidUUID(String str) {
        return str != null && UUID_REGEX_PATTERN.matcher(str).matches();
    }

    public static boolean eTagsAreEqual(@NotNull String eTag1, @NotNull String eTag2, boolean isStrongComparison) {
        if (isStrongComparison) {
            return Utils.isStrongETag(eTag1) && Utils.isStrongETag(eTag2) && eTag1.equals(eTag2);
        }
        String opaqueETag1 = Utils.isWeakETag(eTag1) ? eTag1.substring(2) : eTag1;
        String opaqueETag2 = Utils.isWeakETag(eTag2) ? eTag2.substring(2) : eTag2;
        return opaqueETag1.equals(opaqueETag2);
    }

    public static boolean isWeakETag(@NotNull String eTag) {
        return WEAK_ETAG_PATTERN.matcher(eTag).matches();
    }

    public static boolean isStrongETag(@NotNull String eTag) {
        return !Utils.isWeakETag(eTag);
    }

    public static List<String> valuesToList(String values, String valuesSeparator) {
        return Stream.of(values.split(valuesSeparator)).map(String::trim).collect(Collectors.toList());
    }

    public static String escapeJcrPath(String path) {
        if (path.contains("'")) {
            return path.replace("'", "''");
        }
        return path;
    }

    public static Calendar convertDateTime(OffsetDateTime datetime) {
        try {
            Instant instant = datetime.toInstant();
            Date date = Date.from(instant);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (IllegalArgumentException ex) {
            log.info("Error converting datetime: {}.", (Object)datetime);
            return null;
        }
    }

    public static StatusInfo convertStatus(ResourceStatus status) {
        StatusInfo converted = null;
        switch (status) {
            case NEW: {
                converted = StatusInfo.NEW;
                break;
            }
            case MODIFIED: {
                converted = StatusInfo.MODIFIED;
                break;
            }
            case DRAFT: {
                converted = StatusInfo.DRAFT;
                break;
            }
            case PUBLISHED: {
                converted = StatusInfo.PUBLISHED;
                break;
            }
            case UNPUBLISHED: {
                converted = StatusInfo.UNPUBLISHED;
            }
        }
        return converted;
    }

    public static FullTextQueryMode convertQueryMode(FullTextSearchCriteria.QueryModeEnum queryMode) {
        FullTextQueryMode ftQueryMode = null;
        switch (queryMode) {
            case EDGES: {
                ftQueryMode = FullTextQueryMode.EDGES;
                break;
            }
            case AS_IS: {
                ftQueryMode = FullTextQueryMode.AS_IS;
                break;
            }
            case ALL_TERMS: {
                ftQueryMode = FullTextQueryMode.ALLTERMS;
                break;
            }
            case EXACT_PHRASE: {
                ftQueryMode = FullTextQueryMode.EXACT_PHRASE;
                break;
            }
            case EXACT_WORDS: {
                ftQueryMode = FullTextQueryMode.EXACT_WORDS;
            }
        }
        return ftQueryMode;
    }
}

