/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.extensions.ContentFragmentReferenceResolver;
import com.adobe.cq.dam.cfm.headless.backend.ReferencesListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.references.ReferenceInfo;
import com.adobe.cq.dam.cfm.headless.backend.impl.references.ReferenceType;
import com.adobe.cq.dam.cfm.headless.backend.impl.references.ReferencesSearchService;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.xf.ExperienceFragmentVariation;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.commons.ReferenceSearch;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ReferencesListGenerator.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ReferencesListGeneratorImpl
implements ReferencesListGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ReferencesListGeneratorImpl.class);
    private static final String PAGE_SEARCH_ROOT_CONTENT = "/jcr:root/content";
    @Reference
    private ContentFragmentReferenceResolver contentFragmentReferenceResolver;

    @Override
    public Map<String, List<ReferenceInfo>> getReferencedBy(ResourceResolver resourceResolver, List<String> paths) {
        HashMap<String, List<ReferenceInfo>> references = new HashMap<String, List<ReferenceInfo>>();
        ReferencesSearchService referencesSearchService = this.getReferenceSearchService(resourceResolver);
        for (String path : paths) {
            ArrayList<ReferenceInfo> items = new ArrayList<ReferenceInfo>();
            references.put(path, items);
            Iterator<Page> pResult = referencesSearchService.searchPages(path, PAGE_SEARCH_ROOT_CONTENT);
            List<ReferenceInfo> pages = this.pageToReferenceInfo(pResult);
            items.addAll(pages);
            Iterator<ContentFragment> cfResult = referencesSearchService.searchContentFragments(path);
            List<ReferenceInfo> contentFragments = this.contentFragmentToReferenceInfo(cfResult);
            items.addAll(contentFragments);
        }
        return references;
    }

    ReferencesSearchService getReferenceSearchService(ResourceResolver resourceResolver) {
        return new ReferencesSearchService(resourceResolver, this.contentFragmentReferenceResolver, new ReferenceSearch());
    }

    private List<ReferenceInfo> pageToReferenceInfo(Iterator<Page> it) {
        ArrayList<ReferenceInfo> references = new ArrayList<ReferenceInfo>();
        while (it.hasNext()) {
            Page page = it.next();
            ReferenceInfo info = this.toReferenceInfo(page);
            references.add(info);
        }
        return references;
    }

    private List<ReferenceInfo> contentFragmentToReferenceInfo(Iterator<ContentFragment> it) {
        ArrayList<ReferenceInfo> references = new ArrayList<ReferenceInfo>();
        while (it.hasNext()) {
            ContentFragment cf = it.next();
            ReferenceInfo info = this.toReferenceInfo(cf);
            if (info == null) continue;
            references.add(info);
        }
        return references;
    }

    private ReferenceInfo toReferenceInfo(ContentFragment cf) {
        String title = cf.getTitle();
        Resource resource = (Resource)cf.adaptTo(Resource.class);
        if (resource == null) {
            LOG.warn("Couldn't adapt content fragment to resource");
            return null;
        }
        StatusInfo status = this.getStatus(resource, cf.getLastModifiedDate());
        return new ReferenceInfo(resource.getPath(), title, status, ReferenceType.CONTENT_FRAGMENT);
    }

    private ReferenceInfo toReferenceInfo(Page page) {
        ReferenceType type = this.getPageType(page);
        Resource resource = page.getContentResource();
        StatusInfo status = this.getStatus(resource, page.getLastModified());
        return new ReferenceInfo(page.getPath(), page.getTitle(), status, type);
    }

    private ReferenceType getPageType(Page page) {
        return this.isExperienceFragment(page) ? ReferenceType.EXPERIENCE_FRAGMENT : ReferenceType.PAGE;
    }

    private boolean isExperienceFragment(Page page) {
        return page.adaptTo(ExperienceFragmentVariation.class) != null;
    }

    private StatusInfo getStatus(Resource res, Calendar modifiedAt) {
        ReplicationStatus replStatus = (ReplicationStatus)res.adaptTo(ReplicationStatus.class);
        if (replStatus == null) {
            return null;
        }
        Calendar publishedAt = replStatus.getLastPublished();
        ReplicationActionType replAction = replStatus.getLastReplicationAction();
        String lastRepAction = replAction != null ? replStatus.getLastReplicationAction().getName() : null;
        return Utils.determineStatusInfo(lastRepAction, modifiedAt, publishedAt);
    }
}

