/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.extensions.modelquery.AllowedModelsHandler;
import com.adobe.cq.dam.cfm.extensions.modelquery.ContentFragmentPredicateFactory;
import com.adobe.cq.dam.cfm.headless.backend.ModelsQueryManager;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Session;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModelsQueryManager.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ModelsQueryManagerImpl
implements ModelsQueryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelsQueryManagerImpl.class);
    private static final String CONF_ROOT = "/conf";
    private static final String CONTENT_DAM_ROOT = "/content/dam";
    static final String MODEL_RESOURCE_TYPE = "dam/cfm/models/console/components/data/entity/default";
    static final String MODEL_LOCATION_PATHS = "dam/cfm/models";
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private AllowedModelsHandler allowedModelsHandler;
    @Reference
    private ContentFragmentPredicateFactory predicateFactory;

    @Override
    @NotNull
    public Iterator<Resource> getModels(@NotNull Resource resource, @NotNull Map<String, String> filterPredicates) {
        Resource conf;
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            return Collections.emptyIterator();
        }
        FragmentTemplate model = (FragmentTemplate)resource.adaptTo(FragmentTemplate.class);
        if (model != null) {
            return Collections.singletonList(resource).iterator();
        }
        Resource modelResource = this.getContentFragmentModel(resource);
        if (modelResource != null) {
            return Collections.singletonList(modelResource).iterator();
        }
        if (ModelsQueryManagerImpl.isFolder(resource) && Text.isDescendantOrEqual((String)CONF_ROOT, (String)resource.getPath())) {
            return this.queryConfFolder(resource, new HashMap<String, String>(), filterPredicates);
        }
        Resource folder = resource;
        while (folder != null && Text.isDescendantOrEqual((String)CONF_ROOT, (String)resource.getPath()) && !ModelsQueryManagerImpl.isFolder(resource) && !CONF_ROOT.equals(resource.getPath())) {
            if ((folder = folder.getParent()) == null || !ModelsQueryManagerImpl.isFolder(resource)) continue;
            return this.queryConfFolder(folder, new HashMap<String, String>(), filterPredicates);
        }
        if (ModelsQueryManagerImpl.isFolder(resource) && Text.isDescendantOrEqual((String)CONTENT_DAM_ROOT, (String)resource.getPath())) {
            Set allowedModelPaths = this.allowedModelsHandler.getAllowedModelsResources(resource, new String[]{MODEL_LOCATION_PATHS}, this.getPredicates()).stream().map(Resource::getPath).collect(Collectors.toSet());
            if (allowedModelPaths.isEmpty()) {
                return Collections.emptyIterator();
            }
            Resource conf2 = resource.getResourceResolver().getResource(CONF_ROOT);
            if (conf2 != null) {
                ArrayList result = new ArrayList();
                Iterator<Resource> it = this.queryConfFolder(conf2, new HashMap<String, String>(), filterPredicates);
                it.forEachRemaining(r -> {
                    String path = StringUtils.removeEnd((String)r.getPath(), (String)"/jcr:content");
                    if (allowedModelPaths.contains(path)) {
                        result.add(r);
                    }
                });
                return result.iterator();
            }
        }
        if ((conf = resource.getResourceResolver().getResource(CONF_ROOT)) != null) {
            return this.queryConfFolder(conf, new HashMap<String, String>(), filterPredicates);
        }
        return Collections.emptyIterator();
    }

    @Nullable
    private Resource getContentFragmentModel(Resource resource) {
        return Optional.ofNullable((ContentFragment)resource.adaptTo(ContentFragment.class)).map(ContentFragment::getTemplate).map(t -> (Resource)t.adaptTo(Resource.class)).orElse(null);
    }

    Iterator<Resource> queryConfFolder(@NotNull Resource folder, @NotNull Map<String, String> predicates, @NotNull Map<String, String> additionalPredicates) {
        predicates.put("property", "sling:resourceType");
        predicates.put("property.value", MODEL_RESOURCE_TYPE);
        return this.queryFolder(folder, predicates, additionalPredicates);
    }

    private Iterator<Resource> queryFolder(@NotNull Resource folder, @NotNull Map<String, String> predicates, @NotNull Map<String, String> additionalPredicates) {
        Session session = (Session)folder.getResourceResolver().adaptTo(Session.class);
        if (session != null) {
            predicates.put("path", folder.getPath());
            predicates.put("path.self", "true");
            for (Map.Entry<String, String> entry : additionalPredicates.entrySet()) {
                predicates.putIfAbsent(entry.getKey(), entry.getValue());
            }
            predicates.putIfAbsent("p.limit", "-1");
            Query query = this.queryBuilder.createQuery(PredicateGroup.create(predicates), session);
            SearchResult searchResult = query.getResult();
            return searchResult.getResources();
        }
        LOGGER.warn("Cannot obtain a JCR Session from the passed resource.");
        return Collections.emptyIterator();
    }

    private static boolean isFolder(Resource resource) {
        String resourceType = resource.getResourceType();
        return "sling:Folder".equals(resourceType) || "sling:OrderedFolder".equals(resourceType);
    }

    private Collection<Predicate> getPredicates() {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(this.predicateFactory.createPredicate("ContentFragmentModelPredicate", Collections.emptyMap()));
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("includeDraft", false);
        parameters.put("includeDisabled", false);
        predicates.add(this.predicateFactory.createPredicate("ContentFragmentModelStatusPredicate", parameters));
        return predicates;
    }
}

