/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.headless.backend.Metrics;
import com.adobe.cq.dam.cfm.impl.Constants;
import java.util.concurrent.TimeUnit;
import org.apache.sling.commons.metrics.Counter;
import org.apache.sling.commons.metrics.MetricsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Metrics.class})
public class MetricsImpl
implements Metrics {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsImpl.class);
    @Reference
    MetricsService metricsService;

    @Override
    public void addMetricTimer(String metricList, String metricName, long timestampStart) {
        String metric = this.generateMetricName(metricList, metricName);
        long timeInMillis = System.currentTimeMillis() - timestampStart;
        if (this.metricsService != null) {
            this.metricsService.timer(metric).update(timeInMillis, TimeUnit.MILLISECONDS);
        }
        LOG.debug("{} took {} ms", (Object)metric, (Object)timeInMillis);
    }

    @Override
    public void addMetricCount(String metricList, String metricName, long count) {
        String metric = this.generateMetricName(metricList, metricName);
        if (this.metricsService != null) {
            Counter counter = this.metricsService.counter(Constants.METRICS_PREFIX_CF + metric);
            counter.increment(count);
        }
        LOG.debug("{}{} increased +{}", new Object[]{Constants.METRICS_PREFIX_CF, metric, count});
    }

    @Override
    public void addMetricCount(String metricList, String metricName) {
        this.addMetricCount(metricList, metricName, 1L);
    }

    private String generateMetricName(String metricList, String metricName) {
        return metricList == null ? String.format("%s:%s", Constants.METRICS_PREFIX_CF, metricName) : String.format("%s:%s:%s", Constants.METRICS_PREFIX_CF, metricList, metricName);
    }
}

