/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.headless.backend.LanguageCopiesProvider;
import com.adobe.cq.dam.cfm.headless.backend.impl.LanguageCopyDetails;
import com.adobe.cq.dam.cfm.headless.backend.impl.LanguageInfo;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.dam.commons.util.DamLanguageUtil;
import com.day.cq.wcm.api.LanguageManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={LanguageCopiesProvider.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY), @Reference(service=ToggleCondition.class, name="toggleCondition-languageCopies", target="(toggle.name=ft-sites-293)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class LanguageCopiesProviderImpl
implements LanguageCopiesProvider {
    @Reference
    protected LanguageManager languageManager;

    @NotNull
    private String getTitle(Resource resource) {
        return Optional.ofNullable(resource.getChild("jcr:content")).map(Resource::getValueMap).map(map -> (String)map.get("jcr:title", String.class)).orElse("");
    }

    private String getModelTitle(Resource resource, ResourceResolver resolver) {
        String NN_DATA = "data";
        return Optional.ofNullable(resource).map(r -> r.getChild("jcr:content/data")).map(Resource::getValueMap).map(vm -> (String)vm.get("cq:model", String.class)).map(modelPath -> resolver.getResource(modelPath + "/jcr:content")).map(Resource::getValueMap).map(vm -> (String)vm.get("jcr:title", String.class)).orElse(null);
    }

    private String getLocale(String path) {
        return DamLanguageUtil.getLanguageRootLocale((String)path);
    }

    private LanguageInfo collectLanguageInfo(ResourceResolver resourceResolver, String path) {
        Map infos = this.languageManager.getAdjacentLanguageInfo(resourceResolver, path);
        if (infos == null) {
            return new LanguageInfo();
        }
        List<LanguageCopyDetails> collect = infos.values().stream().map(languageCopy -> resourceResolver.getResource(languageCopy.getPath())).filter(Objects::nonNull).map(resource -> new LanguageCopyDetails(resource.getPath(), this.getTitle((Resource)resource), this.getLocale(resource.getPath()), this.getModelTitle((Resource)resource, resourceResolver), Utils.determineStatusInfo(resource))).collect(Collectors.toList());
        return new LanguageInfo(this.getLocale(path), collect);
    }

    @Override
    public Map<String, LanguageInfo> getLanguageInfo(ResourceResolver resourceResolver, List<String> paths) {
        return paths.stream().collect(Collectors.toMap(Function.identity(), path -> this.collectLanguageInfo(resourceResolver, (String)path)));
    }
}

