/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentElement;
import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.ContentVariation;
import com.adobe.cq.dam.cfm.FragmentData;
import com.adobe.cq.dam.cfm.FragmentTemplate;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.VersionDef;
import com.adobe.cq.dam.cfm.VersionedContent;
import com.adobe.cq.dam.cfm.headless.backend.FragmentConverter;
import com.adobe.cq.dam.cfm.headless.backend.FragmentSerializer;
import com.adobe.cq.dam.cfm.headless.backend.FragmentService;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.ScheduledOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.TimeAuthorInformation;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.VariationSerializerImpl;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Fragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.serializer.fragment.Variation;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.exceptions.ContentFragmentConflictException;
import com.adobe.cq.dam.cfm.headless.remoteapi.impl.servlet.cursors.GetFragmentsCursor;
import com.adobe.cq.dam.cfm.impl.util.Base64URLHelper;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModel;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentModelField;
import com.adobe.cq.dam.cfm.openapi.models.ContentFragmentVariation;
import com.adobe.cq.dam.cfm.openapi.models.CreateContentFragment;
import com.adobe.cq.dam.cfm.openapi.models.DataType;
import com.adobe.cq.dam.cfm.openapi.models.LongTextFragmentField;
import com.adobe.cq.dam.cfm.openapi.models.Version;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.dam.api.Asset;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FragmentService.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentServiceImpl
implements FragmentService {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentServiceImpl.class);
    private static final String EXCEPTION_MSG_CANT_DELETE = "Unable to delete content fragment";
    private static final String EXCEPTION_MSG_CANT_SAVE_FRAGMENT = "Unable to create a content fragment at path '%s'";
    private static final String EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT = "Resource is not a content fragment";
    private static final String EXCEPTION_MSG_EMPTY_CF_PATH = "Can not create content fragment at an empty path";
    private static final String EXCEPTION_MSG_RESOURCE_ALREADY_EXISTS = "Content fragment with name '%s' at '%s' already exists";
    private static final String EXCEPTION_MSG_PARENT_PATH_NOT_EXISTENT = "Given path '%s' is not a valid resource";
    private static final String CONTENT_DAM = "/content/dam";
    @Reference
    private ToggleRouter toggleRouter;
    @Reference
    private FragmentSerializer fragmentSerializer;
    @Reference
    private FragmentConverter fragmentConverter;
    @Reference
    private VariationSerializerImpl variationSerializer;

    @Override
    public Fragment getFragment(@NotNull Resource resource) throws ContentFragmentException {
        return this.getFragment(resource, 1);
    }

    @Override
    public Variation getVariation(@NotNull ContentFragment contentFragment, @NotNull String variationName, int depth) {
        return this.variationSerializer.transform((Pair<ContentFragment, VariationDef>)Pair.of((Object)contentFragment, (Object)this.getVariationDef(contentFragment, variationName)), depth);
    }

    @Override
    public Fragment getFragment(@NotNull Resource resource, int depth) throws ContentFragmentException {
        ContentFragment contentFragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (contentFragment == null) {
            LOG.error(EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT);
            return null;
        }
        if (this.toggleRouter.isEnabled("FT_SITES-11240")) {
            return (Fragment)this.fragmentSerializer.transform(contentFragment, depth);
        }
        return (Fragment)this.fragmentSerializer.transform(contentFragment, 1);
    }

    @Override
    @NotNull
    public List<Fragment> getFragments(@NotNull ResourceResolver resourceResolver, int limit, @Nullable GetFragmentsCursor cursor, @Nullable String folder) throws ContentFragmentException {
        if (StringUtils.isEmpty((CharSequence)folder)) {
            folder = CONTENT_DAM;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM [dam:Asset] AS cf WHERE (ISDESCENDANTNODE(cf,'%s') OR ISSAMENODE(cf,'%s')) ");
        arguments.add(Utils.escapeJcrPath(folder));
        arguments.add(Utils.escapeJcrPath(folder));
        query.append("AND cf.[jcr:content/contentFragment] = CAST('true' AS BOOLEAN) ");
        if (cursor != null) {
            query.append("AND (cf.[jcr:created] > cast('%s' AS date) ");
            arguments.add(cursor.getCreated().toString());
            query.append("OR (cf.[jcr:created] = cast('%s' AS date) AND cf.[jcr:uuid] > '%s')) ");
            arguments.add(cursor.getCreated().toString());
            arguments.add(cursor.getUuid().toString());
        }
        query.append("ORDER BY cf.[jcr:created], cf.[jcr:uuid] ");
        query.append("OPTION (INDEX TAG [fragments], LIMIT %s)");
        arguments.add(String.valueOf(limit));
        String queryPrepared = String.format(query.toString(), arguments.toArray(new String[0]));
        Iterator resourceIterator = resourceResolver.findResources(queryPrepared, "JCR-SQL2");
        ArrayList<Fragment> backingList = new ArrayList<Fragment>();
        while (resourceIterator.hasNext()) {
            Resource resource = (Resource)resourceIterator.next();
            Fragment fragmentResult = this.getFragment(resource);
            if (fragmentResult == null) continue;
            backingList.add(fragmentResult);
        }
        return Collections.unmodifiableList(backingList);
    }

    @Override
    public Fragment patchFragment(@NotNull Fragment fragment, @NotNull com.adobe.cq.dam.cfm.openapi.models.ContentFragment fragmentDto) throws ContentFragmentException {
        ContentFragment contentFragment = fragment.getContentFragment();
        Resource contentFragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        ResourceResolver resourceResolver = contentFragmentResource.getResourceResolver();
        contentFragment.setTitle(fragmentDto.getTitle());
        contentFragment.setDescription(fragmentDto.getDescription() != null ? fragmentDto.getDescription() : "");
        this.setData(fragment.getModel(), fragmentDto.getFields(), contentFragment);
        this.commitChanges(resourceResolver, "Unable to patch the content fragment at path " + fragmentDto.getPath());
        contentFragmentResource = resourceResolver.getResource(contentFragmentResource.getPath());
        return this.getFragment(contentFragmentResource);
    }

    @Override
    public Variation createVariation(ResourceResolver resourceResolver, ContentFragment contentFragment, String name, String title, String description) throws ContentFragmentException {
        Resource contentFragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        contentFragment.createVariation(name, title, description);
        this.commitChanges(resourceResolver, "Unable to create variation");
        contentFragmentResource = resourceResolver.getResource(contentFragmentResource.getPath());
        Optional<Variation> optionalVariation = this.getFragment(contentFragmentResource).getVariationByName(name);
        if (optionalVariation.isEmpty()) {
            throw new ContentFragmentException("Unable to create variation");
        }
        return optionalVariation.get();
    }

    @Override
    public Variation patchVariation(@NotNull Fragment fragment, @NotNull ContentFragmentVariation variationDto) throws ContentFragmentException {
        String variationName = variationDto.getName();
        ContentFragment contentFragment = fragment.getContentFragment();
        Resource contentFragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        ResourceResolver resourceResolver = contentFragmentResource.getResourceResolver();
        ((ContentElement)contentFragment.getElements().next()).getVariation(variationName).setTitle(variationDto.getTitle());
        ((ContentElement)contentFragment.getElements().next()).getVariation(variationName).setDescription(variationDto.getDescription());
        this.setData(fragment.getModel(), variationDto.getFields(), contentFragment, variationName);
        this.commitChanges(resourceResolver, "Unable to patch variation");
        contentFragmentResource = resourceResolver.getResource(contentFragmentResource.getPath());
        Optional<Variation> optionalVariation = this.getFragment(contentFragmentResource).getVariationByName(variationName);
        if (optionalVariation.isEmpty()) {
            throw new ContentFragmentException("Unable to patch variation");
        }
        return optionalVariation.get();
    }

    @Override
    @NotNull
    public Fragment createFragment(@NotNull CreateContentFragment fragmentRequest, @NotNull ResourceResolver resourceResolver) throws ContentFragmentException, RepositoryException {
        String name;
        String description;
        String contentFragmentModelPath = Base64URLHelper.toPath(fragmentRequest.getModelId());
        String title = fragmentRequest.getTitle();
        String parentPath = fragmentRequest.getParentPath();
        String string = description = fragmentRequest.getDescription() != null ? fragmentRequest.getDescription() : "";
        if (contentFragmentModelPath == null) {
            throw new ContentFragmentException("Unable to create Content Fragment - invalid payload");
        }
        Resource cfmResource = resourceResolver.getResource(contentFragmentModelPath);
        if (cfmResource == null) {
            throw new ContentFragmentException(String.format("Cannot create a resource of given model '%s'", contentFragmentModelPath));
        }
        ContentFragmentModel model = (ContentFragmentModel)cfmResource.adaptTo(ContentFragmentModel.class);
        if (model == null) {
            throw new ContentFragmentException(String.format("Cannot create a template from the given model '%s'", contentFragmentModelPath));
        }
        FragmentTemplate fragmentTemplate = (FragmentTemplate)cfmResource.adaptTo(FragmentTemplate.class);
        if (fragmentTemplate == null) {
            throw new ContentFragmentException(String.format("Cannot create a template from the given model '%s'", contentFragmentModelPath));
        }
        String string2 = name = fragmentRequest.getName() != null ? fragmentRequest.getName() : JcrUtil.createValidName((String)title, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING, (String)"-");
        if (!JcrUtil.isValidName((String)name)) {
            throw new ContentFragmentException(String.format("Given name '%s' is not a valid JCR name", name));
        }
        Resource parentResource = this.getParentResourceFromPath(resourceResolver, parentPath);
        Resource childResource = parentResource.getChild(name);
        if (childResource != null) {
            throw new ContentFragmentConflictException(String.format(EXCEPTION_MSG_RESOURCE_ALREADY_EXISTS, name, parentPath));
        }
        ContentFragment contentFragment = fragmentTemplate.createFragment(parentResource, name, title);
        Resource contentFragmentResource = (Resource)contentFragment.adaptTo(Resource.class);
        this.setContent(contentFragmentResource, description, parentPath, name);
        this.setData(model, fragmentRequest.getFields(), contentFragment);
        this.commitChanges(resourceResolver, String.format(EXCEPTION_MSG_CANT_SAVE_FRAGMENT, parentPath));
        contentFragmentResource = resourceResolver.getResource(contentFragmentResource.getPath());
        return this.getFragment(contentFragmentResource);
    }

    @Override
    public void deleteFragment(@NotNull Resource resource) throws ContentFragmentException, PersistenceException {
        ContentFragment fragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (fragment == null) {
            throw new ContentFragmentException(EXCEPTION_MSG_NOT_A_CONTENT_FRAGMENT);
        }
        ResourceResolver resourceResolver = resource.getResourceResolver();
        resourceResolver.delete(resource);
        this.commitChanges(resourceResolver, EXCEPTION_MSG_CANT_DELETE);
    }

    @Override
    public boolean restoreVersion(@NotNull Asset asset, @NotNull String versionId) {
        try {
            Asset restoredAsset = asset.restore(versionId);
            if (restoredAsset == null) {
                LOG.error("Revision id does not pertain to the current asset or does not exist.");
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected resource provided {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public ScheduledOperation getScheduledPublicationStatus(Resource resource) {
        if (this.toggleRouter.isEnabled("FT_SITES-14296")) {
            return ScheduledOperation.getOperation(resource);
        }
        return null;
    }

    private void commitChanges(ResourceResolver resourceResolver, String exceptionMessage) throws ContentFragmentException {
        try {
            resourceResolver.commit();
        }
        catch (PersistenceException e) {
            throw new ContentFragmentException(exceptionMessage, (Throwable)e);
        }
    }

    @Override
    public void deleteVersion(@NotNull ContentFragment contentFragment, String versionId) throws RepositoryException {
        Resource resource = (Resource)contentFragment.adaptTo(Resource.class);
        ResourceResolver resourceResolver = resource.getResourceResolver();
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session == null) {
            LOG.error("Unable to obtain session.");
            throw new RuntimeException("Unable to obtain session.");
        }
        VersionHistory versionHistory = session.getWorkspace().getVersionManager().getVersionHistory(resource.getPath());
        VersionDef versionDef = this.getVersionDef(contentFragment, versionId);
        if (versionDef != null) {
            versionHistory.removeVersion(versionDef.getDescription());
        }
    }

    @Override
    public Fragment getCFWithVersion(@NotNull ContentFragment fragment, @NotNull String versionId, ResourceResolver resourceResolver) {
        try {
            Resource versionResource = Utils.getResourceByUuid(versionId, resourceResolver);
            if (versionResource == null) {
                return null;
            }
            this.setVersionedElements(fragment, versionId);
            this.setVersionedTags(versionResource, fragment);
            Fragment result = (Fragment)this.fragmentSerializer.transform(fragment, 0);
            this.setVersionData(versionResource, result);
            result.setId(UUID.fromString(versionId));
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setContent(Resource contentFragmentResource, String description, String parentPath, String name) {
        ContentFragment fragment = (ContentFragment)contentFragmentResource.adaptTo(ContentFragment.class);
        if (fragment == null) {
            throw new IllegalArgumentException("Resource needs to be a content fragment");
        }
        Resource contentResource = contentFragmentResource.getChild("jcr:content");
        ModifiableValueMap properties = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
        if (properties != null) {
            properties.put((Object)"cq:name", (Object)name);
            properties.put((Object)"jcr:description", (Object)description);
            properties.put((Object)"cq:parentPath", (Object)parentPath);
        }
    }

    private Tag[] getTagsById(Resource metaDataResource, @NotNull String[] tagsIds) {
        TagManager tagManager = (TagManager)metaDataResource.getResourceResolver().adaptTo(TagManager.class);
        if (tagManager == null) {
            LOG.error("Cannot adapt resource resolver to tag manager.");
            return new Tag[0];
        }
        return (Tag[])Arrays.stream(tagsIds).map(arg_0 -> ((TagManager)tagManager).resolve(arg_0)).filter(Objects::nonNull).toArray(Tag[]::new);
    }

    private void setData(ContentFragmentModel model, List<ContentFragmentField> fragmentFields, ContentFragment contentFragment) throws ContentFragmentException {
        this.setData(model, fragmentFields, contentFragment, null);
    }

    private void setData(ContentFragmentModel model, List<ContentFragmentField> fragmentFields, ContentFragment contentFragment, String variationName) throws ContentFragmentException {
        for (ContentFragmentField fragmentField : fragmentFields) {
            ContentElement element = contentFragment.getElement(fragmentField.getName());
            Optional<ContentFragmentModelField> modelFieldOpt = model.getFields().stream().filter(field -> field.getName().equals(fragmentField.getName())).findFirst();
            if (modelFieldOpt.isPresent()) {
                LongTextFragmentField longTextFragmentField;
                Object value = this.fragmentConverter.getValue(fragmentField, modelFieldOpt.get());
                if (variationName == null) {
                    FragmentData fragmentData = element.getValue();
                    fragmentData.setValue(value);
                    if (DataType.LONG_TEXT.equals((Object)fragmentField.getType())) {
                        LongTextFragmentField longTextFragmentField2 = (LongTextFragmentField)fragmentField;
                        String contentType = longTextFragmentField2.getMimeType() != null ? longTextFragmentField2.getMimeType().toString() : element.getContentType();
                        fragmentData.setContentType(contentType);
                    }
                    element.setValue(fragmentData);
                    continue;
                }
                ContentVariation variation = element.getVariation(variationName);
                if (variation == null) {
                    throw new ContentFragmentException(String.format("Could not update content fragment '%s' with element '%s' and variation '%s'", contentFragment.getName(), element.getName(), variationName));
                }
                FragmentData fragmentData = variation.getValue();
                fragmentData.setValue(value);
                if (DataType.LONG_TEXT.equals((Object)fragmentField.getType()) && (longTextFragmentField = (LongTextFragmentField)fragmentField).getMimeType() != null) {
                    fragmentData.setContentType(longTextFragmentField.getMimeType().toString());
                }
                variation.setValue(fragmentData);
                continue;
            }
            LOG.error("Unexpected: Fragment field {} not found in model located at {} for content fragment at path {}.", new Object[]{fragmentField.getName(), model.getPath(), ((Resource)contentFragment.adaptTo(Resource.class)).getPath()});
        }
    }

    private Resource getParentResourceFromPath(ResourceResolver resourceResolver, String parentPath) throws ContentFragmentException {
        Resource parentResource;
        if (StringUtils.isEmpty((CharSequence)parentPath)) {
            throw new ContentFragmentException(EXCEPTION_MSG_EMPTY_CF_PATH);
        }
        if (!((String)parentPath).startsWith(CONTENT_DAM)) {
            parentPath = "/content/dam/" + (String)parentPath;
        }
        if ((parentResource = resourceResolver.getResource((String)(parentPath = ResourceUtil.normalize((String)parentPath)))) == null) {
            throw new ContentFragmentException(String.format(EXCEPTION_MSG_PARENT_PATH_NOT_EXISTENT, parentPath));
        }
        return parentResource;
    }

    private VersionDef getVersionDef(ContentFragment contentFragment, String versionId) {
        VersionDef versionDef = null;
        try {
            Iterator versionsIt = contentFragment.listVersions();
            while (versionsIt.hasNext() && versionDef == null) {
                VersionDef version = (VersionDef)versionsIt.next();
                if (!version.getIdentifier().equals(versionId)) continue;
                versionDef = version;
            }
            return versionDef;
        }
        catch (ContentFragmentException e) {
            return null;
        }
    }

    private void setVersionData(Resource resource, Fragment fragment) {
        Resource frozenResource = resource.getChild("jcr:frozenNode");
        if (frozenResource == null) {
            return;
        }
        Resource jcrNode = frozenResource.getChild("jcr:content");
        if (jcrNode == null) {
            return;
        }
        String name = (String)jcrNode.getValueMap().get("cq:name", String.class);
        String title = (String)jcrNode.getValueMap().get("jcr:title", String.class);
        String path = (String)jcrNode.getValueMap().get("cq:parentPath", String.class);
        String description = (String)jcrNode.getValueMap().get("jcr:description", (Object)"");
        String modifiedBy = (String)jcrNode.getValueMap().get("jcr:lastModifiedBy", String.class);
        Calendar modifiedAt = (Calendar)jcrNode.getValueMap().get("jcr:lastModified", Calendar.class);
        TimeAuthorInformation modified = Utils.createTimeAuthorInformation(modifiedAt, modifiedBy);
        String createdBy = (String)jcrNode.getValueMap().get("cq:versionCreator", String.class);
        Calendar createdAt = (Calendar)resource.getValueMap().get("jcr:created", Calendar.class);
        TimeAuthorInformation created = Utils.createTimeAuthorInformation(createdAt, createdBy);
        StatusInfo status = Utils.determineStatusInfo(frozenResource);
        if (jcrNode.getChild("model") == null) {
            fragment.setVariations(List.of());
        } else {
            List<Variation> variations = fragment.getVariations();
            for (Variation variation : variations) {
                @Nullable Resource modelResource = jcrNode.getChild("model");
                if (modelResource == null) {
                    fragment.setVariations(List.of());
                    continue;
                }
                Resource variationsResource = modelResource.getChild("variations");
                if (variationsResource == null) {
                    fragment.setVariations(List.of());
                    continue;
                }
                if (variationsResource.getChild(variation.getName()) == null) {
                    fragment.getVariations().remove(variation);
                    continue;
                }
                ValueMap vm = variationsResource.getValueMap();
                variation.setTitle((String)vm.get("jcr:title", String.class));
                variation.setDescription((String)vm.get("jcr:description", (Object)""));
                fragment.getVariations().set(variations.indexOf(variation), variation);
            }
        }
        fragment.setTitle(title);
        fragment.setDescription(description);
        fragment.setPath(path + "/" + name);
        fragment.setCreated(created);
        fragment.setModified(modified);
        fragment.setStatus(status);
    }

    private void setVersionedElements(ContentFragment fragment, String versionId) throws ContentFragmentException {
        VersionDef def = this.getVersionDef(fragment, versionId);
        Iterator elements = fragment.getElements();
        while (elements.hasNext()) {
            VersionedContent versionedContent;
            ContentElement element = (ContentElement)elements.next();
            try {
                versionedContent = element.getVersionedContent(def);
                fragment.getElement(element.getName()).getValue().setValue((Object)versionedContent.getContent());
                fragment.getElement(element.getName()).getValue().setContentType(versionedContent.getContentType());
            }
            catch (ContentFragmentException e) {
                fragment.getElement(element.getName()).getValue().setValue(null);
                fragment.getElement(element.getName()).getValue().setContentType(null);
            }
            Iterator variations = element.getVariations();
            while (variations.hasNext()) {
                ContentVariation variation = (ContentVariation)variations.next();
                FragmentData variationData = fragment.getElement(element.getName()).getVariation(variation.getName()).getValue();
                try {
                    versionedContent = variation.getVersionedContent(def);
                    variationData.setValue((Object)versionedContent.getContent());
                    variationData.setContentType(versionedContent.getContentType());
                    fragment.getElement(element.getName()).getVariation(variation.getName()).setValue(variationData);
                }
                catch (ContentFragmentException e) {
                    variationData.setValue(null);
                    variationData.setContentType(null);
                    fragment.getElement(element.getName()).getVariation(variation.getName()).setValue(variationData);
                }
            }
        }
    }

    private void setVersionedTags(Resource resource, ContentFragment fragment) throws ContentFragmentException {
        Resource frozenResource = resource.getChild("jcr:frozenNode");
        if (frozenResource == null) {
            return;
        }
        Resource jcrNode = frozenResource.getChild("jcr:content");
        if (jcrNode == null) {
            return;
        }
        Resource metadataResource = jcrNode.getChild("metadata");
        if (metadataResource == null) {
            return;
        }
        String[] tagIds = (String[])metadataResource.getValueMap().get("cq:tags", String[].class);
        if (tagIds != null) {
            try {
                fragment.setTags(this.getTagsById(resource, tagIds));
            }
            catch (ContentFragmentException e) {
                LOG.error("Unable to set the version's tags");
                return;
            }
        } else {
            fragment.setTags(new Tag[0]);
        }
        Resource damCfVariations = metadataResource.getChild("dam:cfVariations");
        if (damCfVariations != null) {
            Iterator variations = damCfVariations.listChildren();
            while (variations.hasNext()) {
                Resource variation = (Resource)variations.next();
                String[] variationTags = (String[])variation.getValueMap().get("cq:tags", String[].class);
                if (variationTags != null) {
                    try {
                        fragment.setVariationTags(this.getTagsById(variation, variationTags), variation.getName());
                        continue;
                    }
                    catch (ContentFragmentException e) {
                        return;
                    }
                }
                fragment.setVariationTags(new Tag[0], variation.getName());
            }
        }
    }

    public static Version generateVersionFromVersionDef(VersionDef versionDef, ResourceResolver resourceResolver) {
        Resource versionResource = Utils.getResourceByUuid(versionDef.getIdentifier(), resourceResolver);
        if (versionResource == null) {
            return null;
        }
        ValueMap versionValueMap = versionResource.getValueMap();
        Resource frozenResource = versionResource.getChild("jcr:frozenNode");
        if (frozenResource == null) {
            LOG.error("Resource with id '{}' is not a version.", (Object)versionDef.getIdentifier());
            return null;
        }
        Version version = new Version();
        version.setCreatedBy(frozenResource.getValueMap().get((Object)"jcr:createdBy").toString());
        version.setTitle(versionResource.getName());
        version.setId(UUID.fromString(versionValueMap.get((Object)"jcr:uuid").toString()));
        version.setCreated(Utils.convertCalendarToOffsetDateTime((Calendar)versionValueMap.get("jcr:created", Calendar.class)));
        return version;
    }

    private VariationDef getVariationDef(ContentFragment contentFragment, String variationName) {
        Iterator variationDefs = contentFragment.listAllVariations();
        Optional<VariationDef> optionalVariationDef = Arrays.stream(IteratorUtils.toArray((Iterator)variationDefs)).map(var -> (VariationDef)var).filter(variation -> variationName.equals(variation.getName())).findFirst();
        return optionalVariationDef.get();
    }
}

