/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.ContentFragmentException;
import com.adobe.cq.dam.cfm.VariationDef;
import com.adobe.cq.dam.cfm.headless.backend.FragmentField;
import com.adobe.cq.dam.cfm.headless.backend.FragmentFilter;
import com.adobe.cq.dam.cfm.headless.backend.FragmentListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.Paging;
import com.adobe.cq.dam.cfm.headless.backend.impl.Metrics;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.CompOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.ConditionBuilder;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.LogOp;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Option;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.Sql2Builder;
import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryGenerator;
import com.adobe.cq.dam.cfm.headless.backend.impl.misc.FullTextQueryMode;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.AbstractOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.Operation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.PublicationOperation;
import com.adobe.cq.dam.cfm.headless.backend.impl.operations.ScheduledOperation;
import com.adobe.cq.dam.cfm.headless.commons.StatusInfo;
import com.adobe.cq.dam.cfm.headless.commons.StatusPreviewInfo;
import com.adobe.cq.dam.cfm.tags.TagsHelper;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.dam.commons.util.DamLanguageUtil;
import com.day.cq.replication.Agent;
import com.day.cq.replication.AgentManager;
import com.day.cq.tagging.Tag;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.metrics.MetricsService;
import org.apache.sling.graphql.helpers.lazyloading.LazyLoadingMap;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FragmentListGenerator.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FragmentListGeneratorImpl
implements FragmentListGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentListGeneratorImpl.class);
    public static final String SEL_ASSET = "asset";
    public static final String FN_AT = "at";
    public static final String FN_BY = "by";
    public static final String FN_TITLE = "title";
    public static final String FN_MODEL = "model";
    public static final String FN_PATH = "path";
    public static final String FN_CREATED = "created";
    public static final String FN_CREATED_AT = "created/at";
    public static final String FN_MODIFIED = "modified";
    public static final String FN_MODIFIED_BY = "modified/by";
    public static final String FN_MODIFIED_AT = "modified/at";
    public static final String FN_MODIFIED_OR_CREATED = "modifiedOrCreated";
    public static final String FN_MODIFIED_OR_CREATED_BY = "modifiedOrCreated/by";
    public static final String FN_MODIFIED_OR_CREATED_AT = "modifiedOrCreated/at";
    public static final String FN_PUBLISHED = "published";
    public static final String FN_PUBLISHED_BY = "published/by";
    public static final String FN_PUBLISHED_AT = "published/at";
    public static final String FN_STATUS = "status";
    public static final String FN_STATUS_PREVIEW = "statusPreview";
    public static final String FN_MODEL_NAME = "name";
    public static final String FN_MODEL_PATH = "path";
    public static final String FN_PARENT = "parent";
    public static final String FN_PARENT_PATH = "path";
    public static final String FN_PARENT_NAME = "name";
    public static final String FN_FRAGMENT_NAME = "name";
    public static final String FN_HAS_CHILDREN = "hasChildren";
    public static final String FN_PARENT_TITLE = "title";
    public static final String FN_ID = "id";
    public static final String FN_OPERATIONS = "operations";
    public static final String FN_REPLICATION_OPERATION = "replication";
    public static final String FN_VARIATIONS = "variations";
    public static final String FN_TAGS = "tags";
    public static final String NT_ASSET = "dam:Asset";
    public static final String NN_DATA = "data";
    public static final String NN_METADATA = "metadata";
    public static final String NN_VARIATIONS = "dam:cfVariations";
    public static final String PN_MODEL = "cq:model";
    public static final String PN_TAGS = "cq:tags";
    public static final String PN_REPLICATED = "cq:lastReplicated";
    public static final String PN_REPLICATED_BY = "cq:lastReplicatedBy";
    public static final String PN_REPLICATION_ACTION = "cq:lastReplicationAction";
    private static final String PREVIEW_AGENT_ID = "preview";
    public static final String LAST_REPLICATED_PREVIEW = "cq:lastReplicated_preview";
    public static final String PN_REPLICATION_ACTION_PREVIEW = "cq:lastReplicationAction_preview";
    public static final String PP_MODEL_REF = "jcr:content/data/cq:model";
    public static final String PP_TAGS_REF = "jcr:content/metadata/cq:tags";
    public static final String PP_TAGS_VARIATIONS_REF = "jcr:content/metadata/dam:cfVariations/*/cq:tags";
    public static final String PP_CONTENT_FRAGMENT = "jcr:content/contentFragment";
    public static final String PP_MODIFIED = "jcr:content/jcr:lastModified";
    public static final String PP_MODIFIED_BY = "jcr:content/jcr:lastModifiedBy";
    public static final String PP_REPLICATED = "jcr:content/cq:lastReplicated";
    public static final String PP_REPLICATED_BY = "jcr:content/cq:lastReplicatedBy";
    public static final String PP_REPLICATION_ACTION = "jcr:content/cq:lastReplicationAction";
    public static final String PP_STAR = "*";
    public static final String PV_REPL_ACTION_ACTIVATE = "Activate";
    public static final String PV_REPL_ACTION_DEACTIVATE = "Deactivate";
    private static final String METRIC_LIST = "FragmentListGenerator.list";
    private static final String INDEX_TAG_FRAGMENTS = "fragments";
    private static final String INDEX_TAG_DAM_ASSET_LUCENE = "visualSimilaritySearch";
    public static final String DEFAULT_FILTER_PATH = "/content/dam";
    public static final String DEFAULT_AGENT_ID = "publish";
    @Reference
    private MetricsService metrics;
    @Reference
    protected AgentManager agentManager;
    @Reference
    private ToggleRouter toggleRouter;

    private void handleModelFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.model() != null) {
            for (String modelName : filter.model()) {
                bldr.fragment(LogOp.OR, PP_MODEL_REF, SEL_ASSET, CompOp.EQUAL, (Object)modelName, () -> modelName != null);
            }
        }
    }

    private void handleTagsFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.tags() != null) {
            for (String tag : filter.tags()) {
                bldr.fragment(LogOp.OR, PP_TAGS_REF, SEL_ASSET, CompOp.EQUAL, (Object)tag, () -> tag != null);
                if (!this.toggleRouter.isEnabled("FT_SITES-12441")) continue;
                bldr.fragment(LogOp.OR, PP_TAGS_VARIATIONS_REF, SEL_ASSET, CompOp.EQUAL, (Object)tag, () -> tag != null);
            }
        }
    }

    private void handleModifiedByFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.modifiedBy() != null) {
            for (String user : filter.modifiedBy()) {
                bldr.fragment(LogOp.OR, PP_MODIFIED_BY, SEL_ASSET, CompOp.EQUAL, (Object)user, () -> user != null);
            }
        }
    }

    private void handleCreatedByFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.createdBy() != null) {
            for (String user : filter.createdBy()) {
                bldr.fragment(LogOp.OR, "jcr:createdBy", SEL_ASSET, CompOp.EQUAL, (Object)user, () -> user != null);
            }
        }
    }

    private void handleModifiedOrCreatedFilter(ConditionBuilder bldr, FragmentFilter filter) {
        bldr.fragment(LogOp.AND, () -> filter.modifiedOrCreatedAfter() != null, Function.COALESCE, new Object[]{SEL_ASSET, PP_MODIFIED, SEL_ASSET, "jcr:created", CompOp.GREATER_THAN_OR_EQUAL, filter.modifiedOrCreatedAfter()});
        bldr.fragment(LogOp.AND, () -> filter.modifiedOrCreatedBefore() != null, Function.COALESCE, new Object[]{SEL_ASSET, PP_MODIFIED, SEL_ASSET, "jcr:created", CompOp.LOWER_THAN_OR_EQUAL, filter.modifiedOrCreatedBefore()});
    }

    private void handleModifiedOrCreatedByFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.modifiedOrCreatedBy() != null) {
            for (String user : filter.modifiedOrCreatedBy()) {
                bldr.fragment(LogOp.OR, () -> user != null, Function.COALESCE, new Object[]{SEL_ASSET, PP_MODIFIED_BY, SEL_ASSET, "jcr:createdBy", CompOp.EQUAL, user});
            }
        }
    }

    private void handlePublishedByFilter(ConditionBuilder bldr, FragmentFilter filter) {
        if (filter.publishedBy() != null) {
            for (String user : filter.publishedBy()) {
                bldr.fragment(LogOp.OR, PP_REPLICATED_BY, SEL_ASSET, CompOp.EQUAL, (Object)user, () -> user != null);
            }
        }
    }

    String createSql2(FragmentFilter filter, Paging paging, FullTextQueryMode queryMode) {
        return Sql2Builder.newBuilder().selector(NT_ASSET, SEL_ASSET).field(SEL_ASSET, PP_STAR).condition(Sql2Builder.newCondition().comparison(PP_CONTENT_FRAGMENT, SEL_ASSET, CompOp.EQUAL, (Object)true).fragment(LogOp.AND, PP_MODEL_REF, SEL_ASSET, CompOp.IS_NOT, null, () -> filter.model() == null).fragment(LogOp.AND, () -> true, Function.ISDESCENDANTNODE, SEL_ASSET, filter.path() != null ? filter.path() : DEFAULT_FILTER_PATH).startSubCondition(LogOp.AND, () -> filter.model() != null).execute(bldr -> this.handleModelFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.model() != null).fragment(LogOp.AND, PP_MODIFIED, SEL_ASSET, CompOp.GREATER_THAN_OR_EQUAL, (Object)filter.modifiedAfter(), () -> filter.modifiedAfter() != null).fragment(LogOp.AND, PP_MODIFIED, SEL_ASSET, CompOp.LOWER_THAN_OR_EQUAL, (Object)filter.modifiedBefore(), () -> filter.modifiedBefore() != null).startSubCondition(LogOp.AND, () -> filter.modifiedBy() != null).execute(bldr -> this.handleModifiedByFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.modifiedBy() != null).execute(bldr -> this.handleModifiedOrCreatedFilter((ConditionBuilder)bldr, filter)).startSubCondition(LogOp.AND, () -> filter.modifiedOrCreatedBy() != null).execute(bldr -> this.handleModifiedOrCreatedByFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.modifiedOrCreatedBy() != null).fragment(LogOp.AND, "jcr:created", SEL_ASSET, CompOp.GREATER_THAN_OR_EQUAL, (Object)filter.createdAfter(), () -> filter.createdAfter() != null).fragment(LogOp.AND, "jcr:created", SEL_ASSET, CompOp.LOWER_THAN_OR_EQUAL, (Object)filter.createdBefore(), () -> filter.createdBefore() != null).startSubCondition(LogOp.AND, () -> filter.createdBy() != null).execute(bldr -> this.handleCreatedByFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.createdBy() != null).fragment(LogOp.AND, PP_REPLICATED, SEL_ASSET, CompOp.GREATER_THAN_OR_EQUAL, (Object)filter.publishedAfter(), () -> filter.publishedAfter() != null).fragment(LogOp.AND, PP_REPLICATED, SEL_ASSET, CompOp.LOWER_THAN_OR_EQUAL, (Object)filter.publishedBefore(), () -> filter.publishedBefore() != null).startSubCondition(LogOp.AND, () -> filter.publishedBy() != null).execute(bldr -> this.handlePublishedByFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.publishedBy() != null).startSubCondition(LogOp.AND, () -> !filter.status().isEmpty()).fragment(LogOp.OR, PP_MODIFIED, SEL_ASSET, CompOp.IS, null, () -> filter.status().contains((Object)StatusInfo.NEW)).fragment(LogOp.OR, PP_MODIFIED, SEL_ASSET, CompOp.IS_NOT, null, () -> filter.status().contains((Object)StatusInfo.DRAFT)).fragment(LogOp.OR, PP_REPLICATION_ACTION, SEL_ASSET, CompOp.EQUAL, (Object)PV_REPL_ACTION_ACTIVATE, () -> filter.status().contains((Object)StatusInfo.MODIFIED) || filter.status().contains((Object)StatusInfo.PUBLISHED)).fragment(LogOp.OR, PP_REPLICATION_ACTION, SEL_ASSET, CompOp.EQUAL, (Object)PV_REPL_ACTION_DEACTIVATE, () -> filter.status().contains((Object)StatusInfo.UNPUBLISHED)).endSubCondition(() -> !filter.status().isEmpty()).fragment(LogOp.AND, () -> filter.fullTextSearch() != null, Function.CONTAINS, PP_STAR, FullTextQueryGenerator.create(filter.fullTextSearch(), queryMode)).startSubCondition(LogOp.AND, () -> filter.tags() != null).execute(bldr -> this.handleTagsFilter((ConditionBuilder)bldr, filter)).endSubCondition(() -> filter.tags() != null).execute(paging::addPagingToCondition).build()).execute(paging::addPagingToOrdering).option(Option.NO_TRAVERSAL, new Object[0]).option(Option.INDEX_TAG, filter.fullTextSearch() == null ? INDEX_TAG_FRAGMENTS : INDEX_TAG_DAM_ASSET_LUCENE).build();
    }

    private Map<String, Object> createParentInfo(ResourceResolver resolver, Node assetNode) throws RepositoryException {
        LazyLoadingMap parentInfo = new LazyLoadingMap();
        try {
            Node parentContent;
            Node parent = assetNode.getParent();
            String parentPath = parent.getPath();
            parentInfo.put((Object)"path", (Object)parentPath);
            String parentName = parent.getName();
            parentInfo.put((Object)"name", (Object)parentName);
            if (parent.hasNode("jcr:content") && (parentContent = parent.getNode("jcr:content")).hasProperty("jcr:title")) {
                String parentTitle = parentContent.getProperty("jcr:title").getString();
                parentInfo.put((Object)"title", (Object)parentTitle);
            }
            parentInfo.put((Object)FN_HAS_CHILDREN, () -> Utils.folderHasChildren(resolver, parentPath, "nt:folder"));
            parentInfo.put((Object)"hidden", (Object)Utils.getBooleanProperty(parent, "hidden"));
        }
        catch (RepositoryException re) {
            String assetPath = assetNode.getPath();
            int lastPathSepPos = assetPath.lastIndexOf(47);
            if (lastPathSepPos >= 0) {
                String parentPath = assetPath.substring(0, lastPathSepPos);
                int nameLastPos = parentPath.lastIndexOf(47);
                if (nameLastPos >= 0) {
                    parentInfo.put((Object)"path", (Object)parentPath);
                    String name = parentPath.substring(nameLastPos + 1);
                    parentInfo.put((Object)"name", (Object)name);
                    parentInfo.put((Object)"title", (Object)name);
                } else {
                    parentInfo.put((Object)"path", (Object)"/");
                    parentInfo.put((Object)"name", (Object)"");
                    parentInfo.put((Object)"title", (Object)"");
                }
            }
            throw new IllegalStateException("Unexpected asset path: " + assetPath);
        }
        return parentInfo;
    }

    Pair<Calendar, String> getModifiedOrCreatedInfo(Node asset, Node assetContent) {
        Calendar modifiedAt = Utils.getCalendarProperty(assetContent, "jcr:lastModified");
        if (modifiedAt != null) {
            String modifiedBy = Utils.getStringProperty(assetContent, "jcr:lastModifiedBy");
            return new ImmutablePair((Object)modifiedAt, (Object)modifiedBy);
        }
        Calendar createdAt = Utils.getCalendarProperty(asset, "jcr:created");
        String createdBy = Utils.getStringProperty(asset, "jcr:createdBy");
        return new ImmutablePair((Object)createdAt, (Object)createdBy);
    }

    @Nullable
    Map<String, Object> processRow(ResourceResolver resolver, Row row, FragmentFilter filter, LocalCache cache) throws RepositoryException {
        Node assetNode = row.getNode(SEL_ASSET);
        if (!assetNode.hasProperty(FragmentField.UUID.getPropertyPath())) {
            LOG.info("Asset node is missing UUID: {}", (Object)assetNode.getPath());
            return null;
        }
        String uuid = assetNode.getProperty(FragmentField.UUID.getPropertyPath()).getString();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing asset node at '{}', UUID: {}", (Object)assetNode.getPath(), (Object)uuid);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        Node assetContent = assetNode.getNode("jcr:content");
        Node dataNode = assetContent.getNode(NN_DATA);
        String modelPath = dataNode.getProperty(PN_MODEL).getString();
        Session session = assetNode.getSession();
        if (!session.nodeExists(modelPath + "/jcr:content")) {
            LOG.info("Corrupt/inconsistent fragment: {}", (Object)assetNode.getPath());
            return null;
        }
        Calendar modifiedAt = Utils.getCalendarProperty(assetContent, "jcr:lastModified");
        Calendar publishedAt = Utils.getCalendarProperty(assetContent, PN_REPLICATED);
        StatusInfo status = Utils.determineStatusInfo(assetContent, modifiedAt, publishedAt);
        if (!filter.status().isEmpty() && !filter.status().contains((Object)status)) {
            return null;
        }
        StatusPreviewInfo statusPreview = null;
        if (this.toggleRouter.isEnabled("ft-sites-125") && assetContent.hasProperty(LAST_REPLICATED_PREVIEW) && assetContent.hasProperty(PN_REPLICATION_ACTION_PREVIEW) && assetContent.getProperty(PN_REPLICATION_ACTION_PREVIEW).getString().equalsIgnoreCase(PV_REPL_ACTION_ACTIVATE)) {
            Calendar lastReplicatedPreview = Utils.getCalendarProperty(assetContent, LAST_REPLICATED_PREVIEW);
            statusPreview = Utils.determineStatusPreviewInfo(modifiedAt, lastReplicatedPreview);
        }
        Locale fragmentLocale = LanguageUtil.getLocale((String)DamLanguageUtil.getLanguageRootLocale((String)assetContent.getPath()));
        if (!(Objects.isNull(filter.locale()) || filter.locale().isEmpty() || filter.locale().contains(fragmentLocale))) {
            return null;
        }
        HashMap<String, Object> hitObj = new HashMap<String, Object>(4);
        hitObj.put("name", assetNode.getName());
        hitObj.put(FN_ID, uuid);
        HashMap<String, String> model = new HashMap<String, String>(4);
        String title = Utils.getStringProperty(assetContent, "jcr:title");
        if (title == null) {
            title = "";
        }
        String modifiedBy = Utils.getStringProperty(assetContent, "jcr:lastModifiedBy");
        hitObj.put(FN_MODIFIED, Utils.createTimeAuthorInformation(modifiedAt, modifiedBy));
        Pair<Calendar, String> modifiedOrCreated = this.getModifiedOrCreatedInfo(assetNode, assetContent);
        hitObj.put(FN_MODIFIED_OR_CREATED, Utils.createTimeAuthorInformation((Calendar)modifiedOrCreated.getLeft(), (String)modifiedOrCreated.getRight()));
        String createdBy = Utils.getStringProperty(assetNode, "jcr:createdBy");
        Calendar createdAt = Utils.getCalendarProperty(assetNode, "jcr:created");
        hitObj.put(FN_CREATED, Utils.createTimeAuthorInformation(createdAt, createdBy));
        String publishedBy = Utils.getStringProperty(assetContent, PN_REPLICATED_BY);
        if (publishedBy != null && publishedAt != null) {
            hitObj.put(FN_PUBLISHED, Utils.createTimeAuthorInformation(publishedAt, publishedBy));
        }
        hitObj.put(FN_STATUS, (Object)status);
        hitObj.put(FN_STATUS_PREVIEW, (Object)statusPreview);
        hitObj.put(FN_OPERATIONS, this.getOperations(resolver, assetNode, cache));
        Node modelContentNode = session.getNode(modelPath + "/jcr:content");
        String modelName = modelContentNode.getProperty("jcr:title").getString();
        model.put("name", modelName);
        model.put("path", modelPath);
        hitObj.put(FN_PARENT, this.createParentInfo(resolver, assetNode));
        LOG.debug("Adding fragment {}", (Object)title);
        hitObj.put("title", title);
        hitObj.put(FN_MODEL, model);
        String path = assetNode.getPath();
        hitObj.put("path", path);
        List<Object> tags = new ArrayList();
        if (this.toggleRouter.isEnabled("FT_SITES-8257")) {
            tags = this.getTags(resolver, path);
        }
        hitObj.put(FN_TAGS, tags);
        hitObj.put(FN_VARIATIONS, this.getVariations(resolver, path));
        return hitObj;
    }

    @Override
    public Iterator<Map<String, Object>> getList(ResourceResolver resolver, FragmentFilter filter, Paging paging, FullTextQueryMode queryMode) {
        long start = System.currentTimeMillis();
        String sql2 = this.createSql2(filter, paging, queryMode);
        LOG.debug("SQL2 used to determine fragment list: {}", (Object)sql2);
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalStateException("ResourceResolver provided is not JCR-based, can't execute");
        }
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query toExecute = qm.createQuery(sql2, "JCR-SQL2");
            paging.modifyQueryObject(toExecute);
            QueryResult result = toExecute.execute();
            ArrayList<Map<String, Object>> hits = new ArrayList<Map<String, Object>>();
            Metrics.duration(this.metrics, start, "FragmentListGenerator.list.execute");
            LocalCache cache = this.createLocalCache();
            RowIterator rows = result.getRows();
            long maxPageSize = paging.getLimit() + 2L;
            while (rows.hasNext() && (long)hits.size() < maxPageSize) {
                long rowFetchStart = System.currentTimeMillis();
                Row row = rows.nextRow();
                Metrics.duration(this.metrics, rowFetchStart, "FragmentListGenerator.list.rowFetch");
                Map<String, Object> processedRow = this.processRow(resolver, row, filter, cache);
                if (processedRow == null) continue;
                hits.add(processedRow);
            }
            Metrics.duration(this.metrics, start, METRIC_LIST);
            return hits.iterator();
        }
        catch (RepositoryException re) {
            LOG.error("Error retrieving asset list", (Throwable)re);
            return Collections.emptyIterator();
        }
    }

    LocalCache createLocalCache() {
        return new LocalCache();
    }

    private Object getOperations(ResourceResolver resolver, Node assetNode, LocalCache cache) {
        LazyLoadingMap operations = new LazyLoadingMap();
        try {
            String path = assetNode.getPath();
            operations.put((Object)FN_REPLICATION_OPERATION, () -> this.getReplicationOperation(resolver, path, cache));
        }
        catch (RepositoryException e) {
            LOG.error("Failed to get the path of the asset node {0}", (Throwable)e);
        }
        return operations;
    }

    private Operation getReplicationOperation(ResourceResolver resolver, String path, LocalCache cache) {
        long startTime = System.currentTimeMillis();
        AbstractOperation op = this.getReplicationOperation(path, cache);
        Resource resource = resolver.getResource(path);
        if (op == null && resource != null) {
            op = this.getScheduledOperation(resource);
        }
        if (op == null) {
            LOG.warn("Resource not found {}", (Object)path);
        }
        if (LOG.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            LOG.debug("Time Elapsed {}", (Object)(endTime - startTime));
        }
        return op;
    }

    private PublicationOperation getReplicationOperation(String path, LocalCache cache) {
        Agent agent = this.getAgent(DEFAULT_AGENT_ID, cache);
        if (cache.getReplicationQueueEntries() == null) {
            cache.setReplicationQueueEntries(PublicationOperation.buildReplicationQueueEntries(agent));
        }
        return PublicationOperation.getOperation(path, cache.getReplicationQueueEntries(), agent);
    }

    private ScheduledOperation getScheduledOperation(Resource resource) {
        return ScheduledOperation.getOperation(resource);
    }

    private Agent getAgent(String agentId, LocalCache cache) {
        Agent cachedAgent = cache.getAgent();
        if (null != cachedAgent) {
            return cachedAgent;
        }
        Map agents = this.agentManager.getAgents();
        Agent agent = agents.getOrDefault(agentId, null);
        if (agent == null) {
            LOG.warn("Could not find agent with id {}", (Object)agentId);
        } else {
            cache.setAgent(agent);
        }
        return agent;
    }

    private List<String> getVariations(ResourceResolver resolver, String path) {
        Resource resource = resolver.getResource(path);
        if (null == resource) {
            return Collections.emptyList();
        }
        ContentFragment fragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (null == fragment) {
            return Collections.emptyList();
        }
        ArrayList<String> variations = new ArrayList<String>();
        Iterator variationDefs = fragment.listAllVariations();
        while (variationDefs.hasNext()) {
            VariationDef variationDef = (VariationDef)variationDefs.next();
            variations.add(variationDef.getName());
        }
        return variations;
    }

    private List<com.adobe.cq.dam.cfm.openapi.models.Tag> getTags(ResourceResolver resolver, String path) {
        ArrayList<com.adobe.cq.dam.cfm.openapi.models.Tag> tagsList = new ArrayList<com.adobe.cq.dam.cfm.openapi.models.Tag>();
        Resource resource = resolver.getResource(path);
        if (null == resource) {
            LOG.error("Could not retrieve resource from path '{}'", (Object)path);
            return tagsList;
        }
        ContentFragment fragment = (ContentFragment)resource.adaptTo(ContentFragment.class);
        if (null == fragment) {
            LOG.error("Resource with path '{}' cannot be adapted to a content fragment", (Object)path);
            return tagsList;
        }
        try {
            Tag[] tags;
            for (Tag tag : tags = fragment.getTags()) {
                com.adobe.cq.dam.cfm.openapi.models.Tag tagData = TagsHelper.map(tag);
                tagsList.add(tagData);
            }
        }
        catch (ContentFragmentException e) {
            LOG.error("Failed to get the tags of the asset node {0}", (Throwable)e);
        }
        return tagsList;
    }

    private static class LocalCache {
        Map<String, Pair<String, Integer>> replicationQueueEntries;
        Agent agent;

        private LocalCache() {
        }

        public Map<String, Pair<String, Integer>> getReplicationQueueEntries() {
            return this.replicationQueueEntries;
        }

        public void setReplicationQueueEntries(Map<String, Pair<String, Integer>> replicationQueueEntries) {
            this.replicationQueueEntries = replicationQueueEntries;
        }

        public Agent getAgent() {
            return this.agent;
        }

        public void setAgent(Agent agent) {
            this.agent = agent;
        }
    }
}

