/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.headless.backend.FolderListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.Paging;
import com.adobe.cq.dam.cfm.headless.backend.impl.Metrics;
import com.adobe.cq.dam.cfm.headless.backend.impl.Utils;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Function;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.Option;
import com.adobe.cq.dam.cfm.headless.backend.impl.builder.sql2.Sql2Builder;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.metrics.MetricsService;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={FolderListGenerator.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class FolderListGeneratorImpl
implements FolderListGenerator {
    public static final String ALIAS_FOLDER = "folder";
    private static final Logger LOG = LoggerFactory.getLogger(FolderListGeneratorImpl.class);
    private static final String NT_FOLDER = "nt:folder";
    public static final String FN_NAME = "name";
    public static final String FN_PATH = "path";
    public static final String FN_TITLE = "title";
    public static final String FN_HAS_CHILDREN = "hasChildren";
    public static final String FN_HIDDEN = "hidden";
    private static final String METRIC_LIST = "FolderListGenerator.list";
    @Reference
    private MetricsService metrics;

    @NotNull
    Map<String, Object> processRow(Row row, ResourceResolver resolver) throws RepositoryException {
        Node folderNode = row.getNode(ALIAS_FOLDER);
        HashMap<String, Object> hitObj = new HashMap<String, Object>(4);
        String name = folderNode.getName();
        String path = folderNode.getPath();
        String title = this.getFolderTitle(folderNode);
        boolean hasChildren = Utils.folderHasChildren(resolver, path, NT_FOLDER);
        boolean hidden = Utils.getBooleanProperty(folderNode, FN_HIDDEN);
        LOG.debug("Adding folder {}", (Object)path);
        hitObj.put(FN_NAME, name);
        hitObj.put(FN_PATH, path);
        hitObj.put(FN_TITLE, title);
        hitObj.put(FN_HAS_CHILDREN, hasChildren);
        hitObj.put(FN_HIDDEN, hidden);
        return hitObj;
    }

    private String getFolderTitle(Node folderNode) throws RepositoryException {
        String title = Utils.getStringProperty(folderNode, "{http://www.jcp.org/jcr/1.0}title");
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            return title;
        }
        if (!folderNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            return folderNode.getName();
        }
        Node folderContent = folderNode.getNode("{http://www.jcp.org/jcr/1.0}content");
        title = Utils.getStringProperty(folderContent, "{http://www.jcp.org/jcr/1.0}title");
        return StringUtils.isNotEmpty((CharSequence)title) ? title : folderNode.getName();
    }

    String createSql2(Paging paging, String rootPath) {
        return Sql2Builder.newBuilder().selector(NT_FOLDER, ALIAS_FOLDER).field("*").condition(Sql2Builder.newCondition().comparison(Function.ISCHILDNODE, ALIAS_FOLDER, rootPath).execute(paging::addPagingToCondition).build()).execute(paging::addPagingToOrdering).option(Option.NO_TRAVERSAL, new Object[0]).build();
    }

    @Override
    public Iterator<Map<String, Object>> getList(ResourceResolver resolver, Paging paging, String rootPath) {
        long start = System.currentTimeMillis();
        String sql2 = this.createSql2(paging, rootPath);
        LOG.debug("SQL2 used to determine folder list: {}", (Object)sql2);
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalStateException("ResourceResolver provided is not JCR-based, can't execute");
        }
        try {
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query toExecute = qm.createQuery(sql2, "JCR-SQL2");
            long maxPageSize = paging.getLimit() + 2L;
            toExecute.setLimit(maxPageSize);
            paging.modifyQueryObject(toExecute);
            QueryResult result = toExecute.execute();
            ArrayList<Map<String, Object>> hits = new ArrayList<Map<String, Object>>();
            Metrics.duration(this.metrics, start, "FolderListGenerator.list.execute");
            RowIterator rows = result.getRows();
            while (rows.hasNext()) {
                long rowFetchStart = System.currentTimeMillis();
                Row row = rows.nextRow();
                Metrics.duration(this.metrics, rowFetchStart, "FolderListGenerator.list.rowFetch");
                Map<String, Object> processedRow = this.processRow(row, resolver);
                hits.add(processedRow);
            }
            Metrics.duration(this.metrics, start, METRIC_LIST);
            return hits.iterator();
        }
        catch (RepositoryException re) {
            LOG.error("Error retrieving asset list", (Throwable)re);
            return Collections.emptyIterator();
        }
    }
}

