/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.dam.cfm.headless.backend.impl.workflow.RevisionManager;
import com.adobe.granite.toggle.api.ToggleCondition;
import com.day.cq.replication.Preprocessor;
import com.day.cq.replication.ReplicationAction;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.ReplicationOptions;
import com.day.cq.replication.ReplicationStatus;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Preprocessor.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=FT_SITES-9948)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class ContentFragmentActivationPreprocessor
implements Preprocessor {
    private static final Logger log = LoggerFactory.getLogger(ContentFragmentActivationPreprocessor.class);
    public static final String FT_CF_VERSIONING_ON_PUBLISH = "FT_SITES-9948";
    public static final String VERSION_MANAGER_SERVICE_NAME = "version-manager";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private ServiceUserMapped serviceUserMapped;

    public void preprocess(ReplicationAction action, ReplicationOptions options) throws ReplicationException {
        String path = action.getPath();
        try (ResourceResolver resolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", VERSION_MANAGER_SERVICE_NAME));){
            Resource resource = resolver.getResource(path);
            if (!options.isSuppressVersions() && resource != null) {
                ContentFragment cf = (ContentFragment)resource.adaptTo(ContentFragment.class);
                ReplicationStatus rs = (ReplicationStatus)resource.adaptTo(ReplicationStatus.class);
                if (cf != null && rs != null && rs.getLastReplicationAction() == ReplicationActionType.ACTIVATE) {
                    this.createVersion(cf, resource.getPath(), resolver, action);
                }
            }
        }
        catch (LoginException e) {
            throw new ReplicationException("Unable to obtain a resource resolver for version management (started by " + action.getUserId() + ")", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ReplicationException("Unable to create version for " + path, e);
        }
    }

    private void createVersion(@NotNull ContentFragment cf, @NotNull String resourcePath, @NotNull ResourceResolver resolver, @NotNull ReplicationAction action) throws Exception {
        if (!RevisionManager.shouldCreateNewVersion(cf)) {
            log.info("Refuse to create new version for unmodified content fragment {}.", (Object)resourcePath);
            return;
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
        String hint = "Created during activation at " + formatter.format(cal.getTime()) + " by " + action.getUserId();
        RevisionManager.createRevision(resolver, resourcePath, hint);
    }
}

