/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.cfm.headless.backend.impl;

import com.adobe.cq.dam.cfm.headless.backend.AllowedPermissionsListGenerator;
import com.adobe.cq.dam.cfm.headless.backend.impl.Metrics;
import com.adobe.cq.dam.cfm.headless.backend.impl.permissions.ContentFragmentPermissions;
import com.adobe.cq.dam.cfm.openapi.models.Permission;
import com.adobe.granite.security.authorization.AuthorizationService;
import com.adobe.granite.toggle.api.ToggleCondition;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.authorization.PrivilegeCollection;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.metrics.MetricsService;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AllowedPermissionsListGenerator.class}, reference={@Reference(service=ToggleCondition.class, name="toggleCondition", target="(toggle.name=ft-sites-249)", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)})
public class AllowedPermissionsListGeneratorImpl
implements AllowedPermissionsListGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AllowedPermissionsListGeneratorImpl.class);
    private static final String DAM_ROOT = "/content/dam/";
    private static final String METRIC_LIST = "AllowedPermissionsListGeneratorImpl.list";
    @Reference
    private MetricsService metrics;
    @Reference
    private AuthorizationService authorizationService;

    @Override
    public Map<String, List<Permission>> getAllowedPermissions(@NotNull ResourceResolver resourceResolver, @NotNull List<String> paths, @NotNull List<Permission> preferredPermissions) {
        long start = System.currentTimeMillis();
        JackrabbitSession session = this.getSession(resourceResolver);
        if (null == session) {
            return Collections.emptyMap();
        }
        JackrabbitAccessControlManager jAcMgr = AllowedPermissionsListGeneratorImpl.getAccessControlManager(session);
        if (null == jAcMgr) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Permission>> allowedPermissions = new HashMap<String, List<Permission>>();
        Map<String, PrivilegeCollection> cache = this.initCache();
        for (String path : paths) {
            long processItemStart = System.currentTimeMillis();
            Resource resource = resourceResolver.getResource(path);
            List<Permission> permissions = this.getPermissionsByResource(session, jAcMgr, resource, preferredPermissions, cache);
            allowedPermissions.put(path, permissions);
            Metrics.duration(this.metrics, processItemStart, "AllowedPermissionsListGeneratorImpl.list.item");
        }
        Metrics.duration(this.metrics, start, METRIC_LIST);
        return allowedPermissions;
    }

    private List<Permission> getPermissionsByResource(JackrabbitSession session, JackrabbitAccessControlManager jAcMgr, Resource resource, List<Permission> preferredPermissions, Map<String, PrivilegeCollection> cache) {
        if (!this.isAssetContent(resource)) {
            return Collections.emptyList();
        }
        return ContentFragmentPermissions.getAllowedPermissions(session, jAcMgr, resource, preferredPermissions, this.getAuthorizationService(), cache);
    }

    private JackrabbitSession getSession(ResourceResolver resolver) {
        Session session = (Session)resolver.adaptTo(Session.class);
        return session instanceof JackrabbitSession ? (JackrabbitSession)session : null;
    }

    private static JackrabbitAccessControlManager getAccessControlManager(JackrabbitSession session) {
        try {
            return (JackrabbitAccessControlManager)session.getAccessControlManager();
        }
        catch (RepositoryException e) {
            LOG.warn("Unable to retrieve the JackrabbitAccessControlManager, {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean isAssetContent(Resource resource) {
        if (null == resource) {
            return false;
        }
        return resource.getPath().startsWith(DAM_ROOT);
    }

    AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    Map<String, PrivilegeCollection> initCache() {
        return new HashMap<String, PrivilegeCollection>();
    }
}

